/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.generator.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.component.AbstractComponentGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public class TrinidadComponentGenerator
extends AbstractComponentGenerator {
    public TrinidadComponentGenerator(Log log, boolean is12) {
        super(log, is12);
    }

    protected void addSpecificImports(Set imports, ComponentBean component) {
        imports.add("org.apache.myfaces.trinidad.bean.FacesBean");
        Iterator properties = component.properties();
        properties = new FilteredIterator(properties, new AbstractComponentGenerator.NonVirtualFilter());
        if (properties.hasNext()) {
            imports.add("org.apache.myfaces.trinidad.bean.PropertyKey");
            AbstractComponentGenerator.ResolvableTypeFilter resolvable = new AbstractComponentGenerator.ResolvableTypeFilter();
            while (properties.hasNext()) {
                PropertyBean property = (PropertyBean)properties.next();
                if (resolvable.accept((Object)property)) {
                    imports.add("org.apache.myfaces.trinidad.util.ComponentUtils");
                }
                if (!property.isNoOp()) continue;
                imports.add("org.apache.myfaces.trinidad.logging.TrinidadLogger");
            }
        }
    }

    protected void writeConstructorContent(PrettyWriter out, ComponentBean component, int modifiers, String rendererType) throws IOException {
        out.println("super(" + rendererType + ");");
    }

    protected void writePropertyListMethods(PrettyWriter out, PropertyBean property, Collection gnoreList) {
    }

    public void writePropertyConstants(PrettyWriter out, String superclassName, ComponentBean component) throws IOException {
        out.println("static public final FacesBean.Type TYPE = new FacesBean.Type(");
        out.indent();
        out.println(superclassName + ".TYPE);");
        out.unindent();
        Iterator properties = component.properties();
        properties = new FilteredIterator(properties, new AbstractComponentGenerator.NonVirtualFilter());
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            String propName = property.getPropertyName();
            String propKey = Util.getConstantNameFromProperty(propName, "_KEY");
            String propAlias = property.getAliasOf();
            if (property.getDeprecated() != null) {
                out.println("@Deprecated");
            }
            out.println("static public final PropertyKey " + propKey + " =");
            out.indent();
            if (propAlias != null) {
                String aliasKey = Util.getConstantNameFromProperty(propAlias, "_KEY");
                out.print("TYPE.registerAlias(" + aliasKey + ", \"" + propName + "\");");
            } else {
                String propCaps;
                out.print("TYPE.registerKey(\"" + propName + "\"");
                String propFullClass = property.getPropertyClass();
                String propClass = Util.getClassFromFullClass(propFullClass);
                if (propClass == null) {
                    propClass = "String";
                }
                String propDefault = property.getDefaultValue();
                if (!"Object".equals(propClass) || propDefault != null) {
                    String boxedClass = Util.getBoxedClass(propClass);
                    out.print(", " + boxedClass + ".class");
                }
                if (propDefault != null) {
                    if (property.isEnum()) {
                        out.print(", Enum.valueOf(" + propClass + ".class," + this.convertStringToBoxedLiteral("String", propDefault) + ")");
                    } else {
                        out.print(", " + this.convertStringToBoxedLiteral(propClass, propDefault));
                    }
                }
                if ((propCaps = this._getPropertyCapabilities(property)) != null) {
                    out.print(", " + propCaps);
                }
                out.println(");");
            }
            out.unindent();
        }
    }

    protected void writePropertyDeclaration(PrettyWriter out, PropertyBean property) throws IOException {
    }

    protected boolean isAccessorMethodFinal() {
        return true;
    }

    protected void writePropertySetterMethodBody(PrettyWriter out, PropertyBean property, String propertyClass) throws IOException {
        String propName = property.getPropertyName();
        String propKey = Util.getConstantNameFromProperty(propName, "_KEY");
        String propVar = Util.getVariableFromName(propName);
        if (!property.isNoOp()) {
            if (Util.isPrimitiveClass(propertyClass)) {
                out.println("setProperty(" + propKey + ", " + this.convertVariableToBoxedForm(propertyClass, propVar) + ");");
            } else {
                out.println("setProperty(" + propKey + ", (" + propVar + "));");
            }
        } else {
            out.println("TrinidadLogger log = TrinidadLogger.createTrinidadLogger(this.getClass());");
            out.print("log.warning(\"property \\\"" + propName + "\\\" is ");
            out.print("using a no-op implementation. Used in extreme cases when the property value, beyond the default value, results in unwanted behavior.");
            out.println("\");");
        }
    }

    protected void writePropertyGetterMethodBody(PrettyWriter out, PropertyBean property) throws IOException {
        String propName = property.getPropertyName();
        String propertyFullClass = property.getPropertyClass();
        String propertyClass = Util.getClassFromFullClass(propertyFullClass);
        String propKey = Util.getConstantNameFromProperty(propName, "_KEY");
        String resolvableType = TrinidadComponentGenerator.resolveType(propertyFullClass);
        if (resolvableType != null) {
            if (resolvableType.equals("Character")) {
                out.println("return ComponentUtils.resolveCharacter((Character)getProperty(" + propKey + "));");
            } else {
                String resolveMethod = Util.getPrefixedPropertyName("resolve", resolvableType);
                String propertyDefault = property.getDefaultValue();
                out.print("return ComponentUtils." + resolveMethod + "(getProperty(" + propKey + ")");
                if (propertyDefault != null) {
                    out.print(", " + Util.convertStringToLiteral(propertyClass, propertyDefault));
                }
                out.println(");");
            }
        } else if (propertyClass.equals("Object")) {
            out.println("return getProperty(" + propKey + ");");
        } else {
            out.println("return (" + propertyClass + ")" + "getProperty(" + propKey + ");");
        }
    }

    public void writeStateManagementMethods(PrettyWriter out, ComponentBean component) throws IOException {
    }

    public void writePropertyListMethods(PrettyWriter out, PropertyBean property) throws IOException {
        String propName = property.getPropertyName();
        String propKey = Util.getConstantNameFromProperty(propName, "_KEY");
        String propertyClass = property.getPropertyClass();
        if (!"java.util.List".equals(propertyClass)) {
            this.getLog().error((CharSequence)("Invalid list type: " + propertyClass));
            return;
        }
        String[] params = property.getPropertyClassParameters();
        propertyClass = params == null || params.length == 0 ? "java.lang.Object" : params[0];
        propertyClass = Util.getClassFromFullClass(propertyClass);
        String singularName = TrinidadComponentGenerator.getSingular(propName);
        String propVar = Util.getVariableFromName(singularName);
        String description = property.getDescription();
        String addMethod = Util.getPrefixedPropertyName("add", singularName);
        String removeMethod = Util.getPrefixedPropertyName("remove", singularName);
        String getMethod = Util.getPrefixedPropertyName("get", propName);
        out.println();
        out.println("/**");
        if (description != null) {
            out.println(" * Adds a " + this.convertMultilineComment(description));
        }
        out.println(" */");
        if (property.getDeprecated() != null) {
            out.println("@Deprecated");
        }
        out.println("final public void " + addMethod + "(" + propertyClass + " " + propVar + ")");
        out.println("{");
        out.indent();
        out.println("if (" + propVar + " == null)");
        out.println("  throw new NullPointerException();");
        out.println();
        out.println("getFacesBean().addEntry(" + propKey + ", " + propVar + ");");
        out.unindent();
        out.println("}");
        out.println();
        out.println("/**");
        if (description != null) {
            out.println(" * Removes a " + this.convertMultilineComment(description));
        }
        out.println(" */");
        out.println("final public void " + removeMethod + "(" + propertyClass + " " + propVar + ")");
        out.println("{");
        out.indent();
        out.println("if (" + propVar + " == null)");
        out.println("  throw new NullPointerException();");
        out.println();
        out.println("getFacesBean().removeEntry(" + propKey + ", " + propVar + ");");
        out.unindent();
        out.println("}");
        out.println();
        out.println("/**");
        if (description != null) {
            out.println(" * Gets all " + this.convertMultilineComment(description));
        }
        out.println(" */");
        if (property.getDeprecated() != null) {
            out.println("@Deprecated");
        }
        out.println("final public " + propertyClass + "[] " + getMethod + "()");
        out.println("{");
        out.indent();
        out.println("return (" + propertyClass + "[]) getFacesBean().getEntries(");
        out.println("         " + propKey + ", " + propertyClass + ".class);");
        out.unindent();
        out.println("}");
    }

    public void writeOther(PrettyWriter out, ComponentBean component) throws IOException {
        this._writeGetBeanType(out);
        this.writeConstructor(out, component, 4);
        this._writeTypeLock(out, component);
    }

    protected void _writeGetBeanType(PrettyWriter out) throws IOException {
        out.println();
        out.println("@Override");
        out.println("protected FacesBean.Type getBeanType()");
        out.println("{");
        out.indent();
        out.println("return TYPE;");
        out.unindent();
        out.println("}");
    }

    private void _writeTypeLock(PrettyWriter out, ComponentBean component) throws IOException {
        out.println();
        out.println("static");
        out.println("{");
        out.indent();
        String rendererType = component.getRendererType();
        if (rendererType == null) {
            out.println("TYPE.lock();");
        } else {
            String componentFamily = component.findComponentFamily();
            out.println("TYPE.lockAndRegister(\"" + componentFamily + "\"," + "\"" + rendererType + "\");");
        }
        out.unindent();
        out.println("}");
    }

    private String _getPropertyCapabilities(PropertyBean property) {
        ArrayList<String> caps = new ArrayList<String>();
        if (property.isMethodBinding() || property.isLiteralOnly()) {
            caps.add("PropertyKey.CAP_NOT_BOUND");
        }
        if (property.isStateHolder()) {
            caps.add("PropertyKey.CAP_STATE_HOLDER");
        }
        if (property.isTransient()) {
            caps.add("PropertyKey.CAP_TRANSIENT");
        }
        if (property.isList()) {
            caps.add("PropertyKey.CAP_LIST");
        }
        if (caps.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < caps.size(); ++i) {
            if (i > 0) {
                sb.append(" | ");
            }
            sb.append(caps.get(i));
        }
        return sb.toString();
    }
}

