/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.GeneratorHelper;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.ComponentTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.TagAttributeFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.SourceTemplate;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public abstract class AbstractComponentTagGenerator
implements ComponentTagGenerator {
    public void writeImports(PrettyWriter out, SourceTemplate template, String packageName, String fullSuperclassName, String superclassName, ComponentBean component) {
        HashSet<ComponentBean> components = new HashSet<ComponentBean>();
        components.add(component);
        this.writeImports(out, template, packageName, fullSuperclassName, superclassName, components);
    }

    public void writeImports(PrettyWriter out, SourceTemplate template, String packageName, String fullSuperclassName, String superclassName, Collection components) {
        TreeSet<String> imports = new TreeSet<String>();
        Iterator lIterator = components.iterator();
        while (lIterator.hasNext()) {
            ComponentBean component = (ComponentBean)lIterator.next();
            Iterator properties = component.properties();
            properties = new FilteredIterator(properties, new TagAttributeFilter());
            if (!superclassName.equals(fullSuperclassName)) {
                imports.add(fullSuperclassName);
            }
            while (properties.hasNext()) {
                PropertyBean property = (PropertyBean)properties.next();
                String propertyClass = property.getPropertyClass();
                String[] propertyClassParams = property.getPropertyClassParameters();
                if (propertyClass == null || !property.isLiteralOnly()) continue;
                imports.add(propertyClass);
            }
            this.addSpecificImports(imports, component);
        }
        imports.removeAll(Util.PRIMITIVE_TYPES);
        GeneratorHelper.writeImports(out, packageName, imports);
    }

    public void writeClassBegin(PrettyWriter out, String className, String superclassName, ComponentBean component, SourceTemplate template) {
        int modifiers = component.getTagClassModifiers();
        String classStart = Modifier.toString(modifiers);
        out.println("/**");
        out.println(" * Auto-generated tag class.");
        out.println(" */");
        classStart = classStart.replaceAll("public abstract", "abstract public");
        out.println(classStart + " class " + className + " extends " + superclassName);
        out.println("{");
        out.indent();
    }

    public void writeConstructor(PrettyWriter out, ComponentBean component, int modifiers) throws IOException {
        String fullClassName = component.getTagClass();
        String className = Util.getClassFromFullClass(fullClassName);
        out.println();
        out.println("/**");
        out.println(" * Construct an instance of the " + className + ".");
        out.println(" */");
        out.println("public " + className + "()");
        out.println("{");
        out.println("}");
    }

    public void writeGetComponentType(PrettyWriter out, ComponentBean component) throws IOException {
        String componentType = component.getComponentType();
        out.println();
        out.println("public String getComponentType()");
        out.println("{");
        out.indent();
        out.println("return \"" + componentType + "\";");
        out.unindent();
        out.println("}");
    }

    public void writeGetRendererType(PrettyWriter out, ComponentBean component) throws IOException {
        String rendererType = component.getRendererType();
        out.println();
        out.println("public String getRendererType()");
        out.println("{");
        out.indent();
        out.println("return " + Util.convertStringToLiteral(rendererType) + ";");
        out.unindent();
        out.println("}");
    }

    public void writeClassEnd(PrettyWriter out) {
        out.unindent();
        out.println("}");
    }

    public void writePropertyMembers(PrettyWriter out, ComponentBean component) throws IOException {
        Iterator properties = component.properties();
        properties = new FilteredIterator(properties, new TagAttributeFilter());
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            this.writePropertyDeclaration(out, property);
            this.writePropertySetter(out, property);
        }
    }

    public void writePropertyMembers(PrettyWriter out, Collection components) throws IOException {
        Iterator lIterator = components.iterator();
        while (lIterator.hasNext()) {
            this.writePropertyMembers(out, (ComponentBean)lIterator.next());
        }
    }

    public void writeReleaseMethod(PrettyWriter out, ComponentBean component) throws IOException {
        HashSet<ComponentBean> components = new HashSet<ComponentBean>();
        components.add(component);
        this.writeReleaseMethod(out, components);
    }

    public void writeReleaseMethod(PrettyWriter out, Collection components) throws IOException {
        HashSet all = new HashSet();
        boolean special = false;
        Iterator lIterator = components.iterator();
        while (lIterator.hasNext()) {
            ComponentBean component = (ComponentBean)lIterator.next();
            Iterator prop = component.properties();
            special |= "org.apache.myfaces.trinidadinternal.taglib.UIXFormTag".equals(component.getTagClass());
            while (prop.hasNext()) {
                all.add(prop.next());
            }
        }
        FilteredIterator properties = all.iterator();
        if ((properties = new FilteredIterator(properties, new TagAttributeFilter())).hasNext() || special) {
            out.println();
            out.println("@Override");
            out.println("public void release()");
            out.println("{");
            out.indent();
            out.println("super.release();");
            while (properties.hasNext()) {
                PropertyBean property = (PropertyBean)properties.next();
                String propName = property.getPropertyName();
                String propVar = "_" + propName;
                out.print(propVar + " = ");
                String type = GeneratorHelper.getJspPropertyType(property, this.is12());
                if ("boolean".equals(type)) {
                    out.println("false;");
                    continue;
                }
                out.println("null;");
            }
            out.unindent();
            out.println("}");
        }
    }

    protected void addSpecificImports(Set imports, ComponentBean component) {
    }

    protected abstract boolean is12();

    protected abstract void writePropertyDeclaration(PrettyWriter var1, PropertyBean var2) throws IOException;

    protected abstract void writePropertySetter(PrettyWriter var1, PropertyBean var2) throws IOException;

    protected abstract void writeSetPropertyMethodBody(PrettyWriter var1, String var2, Iterator var3) throws IOException;
}

