/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.AbstractTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.TagAttributeFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.AbstractTagBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ConverterBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public abstract class AbstractConverterTagGenerator
extends AbstractTagGenerator {
    protected AbstractConverterTagGenerator(boolean is12, String licenseHeader, Log log) {
        super(is12, licenseHeader, log);
    }

    public void generateTagHandler(ConverterBean converter, File generatedSourceDirectory) {
        try {
            this.getLog().debug((CharSequence)("Generating " + converter.getTagClass()));
            StringWriter sw = new StringWriter();
            PrettyWriter out = new PrettyWriter(sw);
            Set imports = this.createImports(converter);
            this.writeHeader(out, converter, imports);
            this.writeClass(out, converter);
            this.writeConstructor(out, converter);
            this.writePropertyMethods(out, converter);
            this.writeDoStartTag(out, converter);
            this.writeCreateConverter(out, converter);
            this.writeSetProperties(out, converter);
            this.writeRelease(out, converter);
            this.writeEnd(out);
            File targetFile = this.createFile(generatedSourceDirectory, converter.getTagClass());
            targetFile.delete();
            FileWriter fw = new FileWriter(targetFile);
            StringBuffer buf = sw.getBuffer();
            fw.write(buf.toString());
            fw.close();
            targetFile.setReadOnly();
        }
        catch (Throwable e) {
            this.getLog().error((CharSequence)("Error generating " + converter.getTagClass()), e);
        }
    }

    protected abstract Set createImports(ConverterBean var1);

    protected abstract void writeSetProperty(PrettyWriter var1, PropertyBean var2);

    private void writeSetProperties(PrettyWriter out, ConverterBean converter) throws IOException {
        Iterator properties = converter.properties();
        if ((properties = new FilteredIterator(properties, new TagAttributeFilter())).hasNext()) {
            String converterFullClass = converter.getConverterClass();
            String converterClass = Util.getClassFromFullClass(converterFullClass);
            out.println();
            out.println("private void _setProperties(");
            out.indent();
            out.println(converterClass + " converter) throws JspException");
            out.unindent();
            out.println("{");
            out.indent();
            while (properties.hasNext()) {
                PropertyBean property = (PropertyBean)properties.next();
                this.writeSetProperty(out, property);
            }
            out.unindent();
            out.println("}");
        }
    }

    protected void writeCreateConverter(PrettyWriter out, ConverterBean converter) throws IOException {
        Iterator properties = converter.properties();
        properties = new FilteredIterator(properties, new TagAttributeFilter());
        String converterFullClass = converter.getConverterClass();
        String converterClass = Util.getClassFromFullClass(converterFullClass);
        out.println();
        if (this.is12()) {
            out.println("@Override");
        }
        out.println("protected Converter createConverter() throws JspException");
        out.println("{");
        out.indent();
        if (this.is12()) {
            out.println("String converterId = " + converterClass + ".CONVERTER_ID;");
            out.println("Application appl = FacesContext.getCurrentInstance().getApplication();");
            out.println(converterClass + " converter = " + "(" + converterClass + ")appl.createConverter(converterId);");
        } else {
            out.println(converterClass + " converter = " + "(" + converterClass + ")super.createConverter();");
        }
        if (properties.hasNext()) {
            out.println("_setProperties(converter);");
        }
        out.println("return converter;");
        out.unindent();
        out.println("}");
    }

    protected void writeDoStartTag(PrettyWriter out, ConverterBean converter) throws IOException {
        if (!this.is12()) {
            String converterFullClass = converter.getConverterClass();
            String converterClass = Util.getClassFromFullClass(converterFullClass);
            out.println();
            out.println("@Override");
            out.println("public int doStartTag() throws JspException");
            out.println("{");
            out.indent();
            out.println("super.setConverterId(" + converterClass + ".CONVERTER_ID);");
            out.println("return super.doStartTag();");
            out.unindent();
            out.println("}");
        }
    }

    private void writeClass(PrettyWriter out, AbstractTagBean abstractTag) {
        String className = Util.getClassFromFullClass(abstractTag.getTagClass());
        if (this.is12()) {
            out.println("public class " + className + " extends ConverterELTag");
        } else {
            out.println("public class " + className + " extends ConverterTag");
        }
        out.println("{");
        out.indent();
    }
}

