/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.GeneratorHelper;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.TagAttributeFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.AbstractTagBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public abstract class AbstractTagGenerator {
    protected Log _log;
    protected boolean _is12;
    protected String _licenseHeader;
    private static final String _AUTO_GENERATE_WARNING = "// WARNING: This file was automatically generated. Do not edit it directly,\n//          or you will lose your changes.\n\n";
    private final Map _RESOLVABLE_TYPES = this._createResolvableTypes();

    public AbstractTagGenerator(boolean is12, String licenseHeader, Log log) {
        this._log = log;
        this._licenseHeader = licenseHeader;
        this._is12 = is12;
    }

    protected void writePreamble(PrettyWriter out) {
        out.write(_AUTO_GENERATE_WARNING);
        out.write(this._licenseHeader);
    }

    protected Log getLog() {
        return this._log;
    }

    protected boolean is12() {
        return this._is12;
    }

    protected File createFile(File generatedSourceDirectory, String fullClassName) {
        this.getLog().debug((CharSequence)("Generating " + fullClassName));
        String sourcePath = Util.convertClassToSourcePath(fullClassName, ".java");
        File targetFile = new File(generatedSourceDirectory, sourcePath);
        targetFile.getParentFile().mkdirs();
        return targetFile;
    }

    protected void writeConstructor(PrettyWriter out, AbstractTagBean abstractTag) throws IOException {
        String fullClassName = abstractTag.getTagClass();
        String className = Util.getClassFromFullClass(fullClassName);
        out.println();
        out.println("/**");
        out.println(" * Construct an instance of the " + className + ".");
        out.println(" */");
        out.println("public " + className + "()");
        out.println("{");
        out.println("}");
    }

    protected void writePropertyMethods(PrettyWriter out, AbstractTagBean abstractTag) throws IOException {
        Iterator properties = abstractTag.properties();
        properties = new FilteredIterator(properties, new TagAttributeFilter());
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            out.println();
            this.writePropertyMember(out, property);
            this.writePropertySet(out, property);
        }
    }

    private void writePropertyMember(PrettyWriter out, PropertyBean property) throws IOException {
        String propName = property.getPropertyName();
        String propVar = "_" + Util.getVariableFromName(propName);
        String jspPropType = this.getJspPropertyType(property);
        out.println("private " + jspPropType + " " + propVar + ";");
    }

    private void writePropertySet(PrettyWriter out, PropertyBean property) throws IOException {
        String propName = property.getPropertyName();
        String propVar = Util.getVariableFromName(propName);
        String setMethod = Util.getPrefixedPropertyName("set", propName);
        String jspPropType = this.getJspPropertyType(property);
        out.println("public void " + setMethod + "(" + jspPropType + " " + propVar + ")");
        out.println("{");
        out.indent();
        out.println("_" + propVar + " = " + propVar + ";");
        out.unindent();
        out.println("}");
    }

    protected void writeRelease(PrettyWriter out, AbstractTagBean abstractTag) throws IOException {
        Iterator properties = abstractTag.properties();
        if ((properties = new FilteredIterator(properties, new TagAttributeFilter())).hasNext()) {
            out.println();
            if (this.is12()) {
                out.println("@Override");
            }
            out.println("public void release()");
            out.println("{");
            out.indent();
            out.println("super.release();");
            while (properties.hasNext()) {
                PropertyBean property = (PropertyBean)properties.next();
                String propName = property.getPropertyName();
                String propVar = "_" + Util.getVariableFromName(propName);
                out.println(propVar + " = null;");
            }
            out.unindent();
            out.println("}");
        }
    }

    private String getJspPropertyType(PropertyBean property) {
        if (property.isMethodExpression()) {
            return "MethodExpression";
        }
        if (this.is12() && property.isMethodBinding()) {
            return "MethodExpression";
        }
        if (this.is12() && !property.isLiteralOnly()) {
            return "ValueExpression";
        }
        return "String";
    }

    protected void writeEnd(PrettyWriter out) {
        out.unindent();
        out.println("}");
        out.close();
    }

    protected void writeImports(PrettyWriter out, AbstractTagBean abstractTagBean, Set imports) {
        imports.removeAll(Util.PRIMITIVE_TYPES);
        String packageName = Util.getPackageFromFullClass(abstractTagBean.getTagClass());
        GeneratorHelper.writeImports(out, packageName, imports);
    }

    protected final void writeHeader(PrettyWriter out, AbstractTagBean converter, Set imports) {
        String packageName = Util.getPackageFromFullClass(converter.getTagClass());
        this.writePreamble(out);
        out.println("package " + packageName + ";");
        out.println();
        this.writeImports(out, converter, imports);
        out.println("/**");
        out.println();
        out.println(" * Auto-generated tag class.");
        out.println(" */");
    }

    protected void addImportsFromPropertes(AbstractTagBean abstractTagBean, Set imports) {
        Iterator properties = abstractTagBean.properties();
        properties = new FilteredIterator(properties, new TagAttributeFilter());
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            String propertyClass = property.getPropertyClass();
            if (propertyClass != null) {
                imports.add(propertyClass);
            }
            if (!"java.lang.String[]".equals(propertyClass)) continue;
            imports.add("java.text.ParseException");
        }
    }

    protected String resolveDateType(String className, boolean useMaxTime) {
        String type = (String)this._RESOLVABLE_TYPES.get(className);
        return useMaxTime ? type + "WithMaxTime" : type;
    }

    protected String resolveType(String className) {
        return (String)this._RESOLVABLE_TYPES.get(className);
    }

    private Map _createResolvableTypes() {
        HashMap<String, String> resolvableTypes = new HashMap<String, String>();
        resolvableTypes.put("boolean", "Boolean");
        resolvableTypes.put("char", "Character");
        resolvableTypes.put("java.util.Date", "Date");
        resolvableTypes.put("int", "Integer");
        resolvableTypes.put("float", "Float");
        resolvableTypes.put("double", "Double");
        resolvableTypes.put("java.util.Locale", "Locale");
        resolvableTypes.put("long", "Long");
        resolvableTypes.put("java.lang.String", "String");
        resolvableTypes.put("java.lang.String[]", "StringArray");
        resolvableTypes.put("java.util.TimeZone", "TimeZone");
        return Collections.unmodifiableMap(resolvableTypes);
    }
}

