/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.AbstractTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.TagAttributeFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.AbstractTagBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ValidatorBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public abstract class AbstractValidatorTagGenerator
extends AbstractTagGenerator {
    public AbstractValidatorTagGenerator(boolean is12, String licenseHeader, Log log) {
        super(is12, licenseHeader, log);
    }

    public void generateTagHandler(ValidatorBean validator, File generatedSourceDirectory) {
        try {
            this.getLog().debug((CharSequence)("Generating " + validator.getTagClass()));
            StringWriter sw = new StringWriter();
            PrettyWriter out = new PrettyWriter(sw);
            Set imports = this.createImports(validator);
            this.writeHeader(out, validator, imports);
            this.writeClass(out, validator);
            this.writeConstructor(out, validator);
            this.writePropertyMethods(out, validator);
            this.writeDoStartTag(out, validator);
            this.writeCreateValidator(out, validator);
            this.writeSetProperties(out, validator);
            this.writeRelease(out, validator);
            this.writeEnd(out);
            File targetFile = this.createFile(generatedSourceDirectory, validator.getTagClass());
            targetFile.delete();
            FileWriter fw = new FileWriter(targetFile);
            StringBuffer buf = sw.getBuffer();
            fw.write(buf.toString());
            fw.close();
            targetFile.setReadOnly();
        }
        catch (Throwable e) {
            this.getLog().error((CharSequence)("Error generating " + validator.getTagClass()), e);
        }
    }

    protected abstract Set createImports(ValidatorBean var1);

    protected void writeClass(PrettyWriter out, AbstractTagBean abstractTag) {
        String className = Util.getClassFromFullClass(abstractTag.getTagClass());
        if (this.is12()) {
            out.println("public class " + className + " extends ValidatorELTag");
        } else {
            out.println("public class " + className + " extends ValidatorTag");
        }
        out.println("{");
        out.indent();
    }

    private void writeDoStartTag(PrettyWriter out, ValidatorBean validator) throws IOException {
        out.println();
        if (!this.is12()) {
            String validatorFullClass = validator.getValidatorClass();
            String validatorClass = Util.getClassFromFullClass(validatorFullClass);
            out.println("public int doStartTag() throws JspException");
            out.println("{");
            out.indent();
            out.println("super.setValidatorId(" + validatorClass + ".VALIDATOR_ID);");
            out.println("return super.doStartTag();");
            out.unindent();
            out.println("}");
        }
    }

    private void writeCreateValidator(PrettyWriter out, ValidatorBean validator) throws IOException {
        Iterator properties = validator.properties();
        if ((properties = new FilteredIterator(properties, new TagAttributeFilter())).hasNext()) {
            String validatorFullClass = validator.getValidatorClass();
            String validatorClass = Util.getClassFromFullClass(validatorFullClass);
            out.println();
            if (this.is12()) {
                out.println("@Override");
            }
            out.println("protected Validator createValidator() throws JspException");
            out.println("{");
            out.indent();
            if (this.is12()) {
                out.println("String validatorId = " + validatorClass + ".VALIDATOR_ID;");
                out.println("Application appl = FacesContext.getCurrentInstance().getApplication();");
                out.println(validatorClass + " validator = " + "(" + validatorClass + ")appl.createValidator(validatorId);");
            } else {
                out.println(validatorClass + " validator = " + "(" + validatorClass + ")super.createValidator();");
            }
            out.println("_setProperties(validator);");
            out.println("return validator;");
            out.unindent();
            out.println("}");
        }
    }

    private void writeSetProperties(PrettyWriter out, ValidatorBean validator) throws IOException {
        Iterator properties = validator.properties();
        if ((properties = new FilteredIterator(properties, new TagAttributeFilter())).hasNext()) {
            String validatorFullClass = validator.getValidatorClass();
            String validatorClass = Util.getClassFromFullClass(validatorFullClass);
            out.println();
            out.println("private void _setProperties(");
            out.indent();
            out.println(validatorClass + " validator) throws JspException");
            out.unindent();
            out.println("{");
            out.indent();
            while (properties.hasNext()) {
                PropertyBean property = (PropertyBean)properties.next();
                this.writeSetProperty(out, property);
            }
            out.unindent();
            out.println("}");
        }
    }

    protected abstract void writeSetProperty(PrettyWriter var1, PropertyBean var2);
}

