/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.GeneratorHelper;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.AbstractComponentTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.TagAttributeFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.MethodSignatureBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public class MyFacesComponentTagGenerator
extends AbstractComponentTagGenerator {
    private boolean _is12;

    public MyFacesComponentTagGenerator(boolean is12) {
        this._is12 = is12;
    }

    protected boolean is12() {
        return this._is12;
    }

    protected void addSpecificImports(Set imports, ComponentBean component) {
        imports.add("javax.faces.component.UIComponent");
        imports.add(component.getComponentClass());
        if (this._is12) {
            imports.add("javax.el.ValueExpression");
        }
        Iterator properties = component.properties();
        properties = new FilteredIterator(properties, new TagAttributeFilter());
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            String propertyClass = property.getPropertyClass();
            if (GeneratorHelper.isConverter(propertyClass)) {
                if (!this._is12) {
                    imports.add("javax.faces.el.ValueBinding");
                }
                imports.add("javax.faces.convert.Converter");
                continue;
            }
            if (property.isMethodBinding()) {
                if (this._is12) {
                    imports.add("javax.el.MethodExpression");
                    if (GeneratorHelper.isActionListener(property, this._is12)) {
                        imports.add("javax.faces.event.MethodExpressionActionListener");
                    }
                    if (GeneratorHelper.isValueChangeListener(property, this._is12)) {
                        imports.add("javax.faces.event.MethodExpressionValueChangeListener");
                    }
                    if (!GeneratorHelper.isValidator(property, this._is12)) continue;
                    imports.add("javax.faces.validator.MethodExpressionValidator");
                    continue;
                }
                imports.add("javax.faces.el.MethodBinding");
                continue;
            }
            if (property.isMethodExpression()) {
                imports.add("javax.el.MethodExpression");
                continue;
            }
            if (GeneratorHelper.isActionListener(property, this._is12)) {
                imports.add("javax.faces.event.MethodExpressionActionListener");
                continue;
            }
            if (GeneratorHelper.isValueChangeListener(property, this._is12)) {
                imports.add("javax.faces.event.MethodExpressionValueChangeListener");
                continue;
            }
            if (!GeneratorHelper.isValidator(property, this._is12)) continue;
            imports.add("javax.faces.validator.MethodExpressionValidator");
        }
    }

    protected void writePropertyDeclaration(PrettyWriter out, PropertyBean property) throws IOException {
        String fieldPropName = property.getFieldPropertyName();
        String jspPropType = GeneratorHelper.getJspPropertyType(property, this._is12);
        out.println();
        out.println("private " + jspPropType + " " + fieldPropName + ";");
    }

    protected void writePropertySetter(PrettyWriter out, PropertyBean property) throws IOException {
        String propName = property.getPropertyName();
        String fieldPropName = property.getFieldPropertyName();
        String jspPropName = property.getJspPropertyName();
        String propVar = Util.getVariableFromName(propName);
        String setMethod = Util.getPrefixedPropertyName("set", jspPropName);
        String jspPropType = GeneratorHelper.getJspPropertyType(property, this._is12);
        out.println("public void " + setMethod + "(" + jspPropType + " " + propVar + ")");
        out.println("{");
        out.indent();
        out.println(fieldPropName + " = " + propVar + ";");
        out.unindent();
        out.println("}");
    }

    public void writeGetComponentType(PrettyWriter out, ComponentBean component) throws IOException {
        String componentType = component.getComponentType();
        if ("javax.faces.HtmlColumn".equals(componentType)) {
            componentType = "javax.faces.Column";
        }
        out.println();
        out.println("@Override");
        out.println("public String getComponentType()");
        out.println("{");
        out.indent();
        out.println("return \"" + componentType + "\";");
        out.unindent();
        out.println("}");
    }

    public void writeSetPropertiesMethod(PrettyWriter out, String componentClass, ComponentBean component) throws IOException {
        HashSet<ComponentBean> components = new HashSet<ComponentBean>();
        components.add(component);
        this.writeSetPropertiesMethod(out, componentClass, components);
    }

    public void writeSetPropertiesMethod(PrettyWriter out, String componentClass, Collection components) throws IOException {
        HashSet all = new HashSet();
        Iterator lIterator = components.iterator();
        while (lIterator.hasNext()) {
            ComponentBean component = (ComponentBean)lIterator.next();
            Iterator prop = component.properties();
            while (prop.hasNext()) {
                all.add(prop.next());
            }
        }
        FilteredIterator properties = all.iterator();
        properties = new FilteredIterator(properties, new TagAttributeFilter());
        out.println();
        if (this._is12) {
            out.println("@Override");
        }
        out.println("protected void setProperties(UIComponent component)");
        out.unindent();
        out.println("{");
        out.indent();
        this.writeSetPropertyMethodBody(out, componentClass, properties);
        out.unindent();
        out.println("}");
    }

    protected void writeSetPropertyMethodBody(PrettyWriter out, String componentClass, Iterator properties) throws IOException {
        if ("HtmlColumn".equals(componentClass)) {
            componentClass = "UIColumn";
        }
        out.println("if (!(component instanceof " + componentClass + "))");
        out.println("{");
        out.indent();
        out.print("throw new IllegalArgumentException(");
        out.print("\"Component \" + component.getClass().getName() + \" is no " + componentClass + "\"");
        out.println(");");
        out.unindent();
        out.println("}");
        out.println(componentClass + " comp = (" + componentClass + ")component;");
        out.println();
        out.println("super.setProperties(component);");
        out.println();
        if (!this._is12) {
            out.println("FacesContext context = FacesContext.getCurrentInstance();");
        }
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            this._writeSetPropertiesCase(out, componentClass, property);
        }
    }

    private void _writeSetPropertiesCase(PrettyWriter out, String componentClass, PropertyBean property) throws IOException {
        if (property.isMethodBinding()) {
            this._writeSetMethodBinding(out, componentClass, property);
        } else if (property.isMethodExpression()) {
            this._writeSetMethodExpression(out, componentClass, property);
        } else if (GeneratorHelper.isConverter(property.getPropertyClass())) {
            this._writeSetConverter(out, componentClass, property.getPropertyName());
        } else {
            this._writeSetProperty(out, property);
        }
    }

    private void _writeSetProperty(PrettyWriter out, PropertyBean property) {
        String propName = property.getPropertyName();
        String propVar = "_" + propName;
        out.println("if (" + propVar + " != null) ");
        out.println("{");
        out.indent();
        if (property.isLiteralOnly()) {
            out.println("comp.getAttributes().put(\"" + propName + "\", " + propVar + ");");
        } else if (this._is12) {
            out.println("comp.setValueExpression(\"" + propName + "\", " + propVar + ");");
        } else {
            this._writeSetValueBinding(out, propName, propVar);
        }
        out.unindent();
        out.println("}");
    }

    private void _writeSetValueBinding(PrettyWriter out, String propName, String propVar) {
        out.println("if (isValueReference(" + propVar + ")");
        out.println("{");
        out.indent();
        out.println("ValueBinding vb = context.getApplication().createValueBinding(" + propVar + ");");
        out.println("comp.setValueBinding(\"" + propName + "\", " + propVar + ");");
        out.unindent();
        out.println("}");
        out.println("else");
        out.println("{");
        out.indent();
        out.println("comp.getAttributes().put(\"" + propName + "\", " + propVar + ");");
        out.unindent();
        out.println("}");
    }

    private void _writeSetMethodBinding(PrettyWriter out, String componentClass, PropertyBean property) throws IOException {
        String propName = property.getPropertyName();
        String propKey = Util.getConstantNameFromProperty(propName, "_KEY");
        String propVar = "_" + propName;
        if (this._is12) {
            out.println("if (" + propVar + " != null)");
            out.println("{");
            out.indent();
            if (GeneratorHelper.isActionListener(property, this._is12)) {
                out.println("comp.addActionListener(new MethodExpressionActionListener(" + propVar + "));");
            } else if (GeneratorHelper.isValueChangeListener(property, this._is12)) {
                out.println("comp.addValueChangeListener(new MethodExpressionValueChangeListener(" + propVar + "));");
            } else if (GeneratorHelper.isValidator(property, this._is12)) {
                out.println("comp.addValidator(new MethodExpressionValidator(" + propVar + "));");
            } else {
                out.println("bean.setProperty(" + componentClass + "." + propKey + ", " + "new MethodExpressionMethodBinding(" + propVar + "));");
            }
            out.unindent();
            out.println("}");
        } else {
            String classArray;
            String[] paramTypes;
            MethodSignatureBean signature = property.getMethodBindingSignature();
            String[] stringArray = paramTypes = signature != null ? signature.getParameterTypes() : null;
            if (paramTypes == null || paramTypes.length == 0) {
                classArray = "new Class[0]";
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("new Class[]{");
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(paramTypes[i]);
                    sb.append(".class");
                }
                sb.append(',');
                sb.append('}');
                classArray = sb.toString();
            }
            out.println("if (" + propVar + " != null)");
            out.println("{");
            out.indent();
            if (this.isStringMethodBindingReturnType(signature)) {
                out.println("MethodBinding mb;");
                out.println("if (isValueReference(" + propVar + "))");
                out.indent();
                out.println("mb = createMethodBinding(" + propVar + ", " + classArray + ");");
                out.unindent();
                out.println("else");
                out.indent();
                out.println("mb = new org.apache.myfaces.trinidadinternal.taglib.ConstantMethodBinding(" + propVar + ");");
                out.unindent();
            } else {
                out.println("MethodBinding mb = createMethodBinding(" + propVar + ", " + classArray + ");");
            }
            out.println("bean.setProperty(" + componentClass + "." + propKey + ", mb);");
            out.unindent();
            out.println("}");
        }
    }

    private void _writeSetMethodExpression(PrettyWriter out, String componentClass, PropertyBean property) throws IOException {
        String propName = property.getPropertyName();
        String propVar = property.getFieldPropertyName();
        out.println("if (" + propVar + " != null) ");
        out.println("{");
        out.indent();
        if (GeneratorHelper.isAction(property)) {
            out.println("comp.setActionExpression(" + propVar + ");");
        } else if (GeneratorHelper.isActionListener(property, this._is12)) {
            out.println("comp.addActionListener(new MethodExpressionActionListener(" + propVar + "));");
        } else {
            out.println("comp." + Util.getPrefixedPropertyName("set", propName) + "(" + propVar + ");");
        }
        out.unindent();
        out.println("}");
    }

    private void _writeSetKeyStroke(PrettyWriter out, String componentClass, String propName) throws IOException {
        String propKey = Util.getConstantNameFromProperty(propName, "_KEY");
        String propVar = "_" + propName;
        if (this._is12) {
            out.println("if (" + propVar + " != null)");
            out.println("{");
            out.indent();
            out.println("if (!" + propVar + ".isLiteralText())");
            out.println("{");
            out.indent();
            out.println("bean.setValueExpression(" + componentClass + "." + propKey + ", " + propVar + ");");
            out.unindent();
            out.println("}");
            out.println("else");
            out.println("{");
            out.indent();
            out.println("Object val = " + propVar + ".getValue(null);");
            out.println("if (val != null)");
            out.indent();
            out.println("bean.setProperty(" + componentClass + "." + propKey + ",");
            out.println("\tKeyStroke.getKeyStroke(val.toString()));");
            out.unindent();
            out.unindent();
            out.println("}");
            out.unindent();
            out.println("}");
        } else {
            out.println("if (" + propVar + " != null)");
            out.println("{");
            out.indent();
            out.println("if (isValueReference(" + propVar + "))");
            out.println("{");
            out.indent();
            out.println("ValueBinding vb = createValueBinding(" + propVar + ");");
            out.println("bean.setValueBinding(" + componentClass + "." + propKey + ", vb);");
            out.unindent();
            out.println("}");
            out.println("else");
            out.println("{");
            out.indent();
            out.println("bean.setProperty(" + componentClass + "." + propKey + ",");
            out.println("\tKeyStroke.getKeyStroke(" + propVar + "));");
            out.unindent();
            out.println("}");
            out.unindent();
            out.println("}");
        }
    }

    private void _writeSetConverter(PrettyWriter out, String componentClass, String propName) throws IOException {
        String propKey = Util.getConstantNameFromProperty(propName, "_KEY");
        String propVar = "_" + propName;
        out.println("if (" + propVar + " != null)");
        out.println("{");
        out.indent();
        if (this._is12) {
            out.println("if (!" + propVar + ".isLiteralText())");
            out.println("{");
            out.indent();
            out.println("comp.setValueExpression(\"" + propName + "\", " + propVar + ");");
            out.unindent();
            out.println("}");
            out.println("else");
            out.println("{");
            out.indent();
            out.println("String s = " + propVar + ".getExpressionString();");
            out.println("if (s != null)");
            out.println("{");
            out.indent();
            out.println("Converter converter = getFacesContext().getApplication().");
            out.indent();
            out.println("createConverter(s);");
            out.unindent();
            out.println("comp.setConverter(converter);");
            out.unindent();
            out.println("}");
            out.unindent();
            out.println("}");
        } else {
            out.println("if (isValueReference(" + propVar + "))");
            out.println("{");
            out.indent();
            out.println("ValueBinding vb = createValueBinding(" + propVar + ");");
            out.println("bean.setValueBinding(" + componentClass + "." + propKey + ", vb);");
            out.unindent();
            out.println("}");
            out.println("else");
            out.println("{");
            out.indent();
            out.println("Converter converter = getFacesContext().getApplication().");
            out.indent();
            out.println("createConverter(" + propVar + ");");
            out.unindent();
            out.println("bean.setProperty(" + componentClass + "." + propKey + ", converter);");
            out.unindent();
            out.println("}");
        }
        out.unindent();
        out.println("}");
    }

    private boolean isStringMethodBindingReturnType(MethodSignatureBean sig) {
        return sig != null && "java.lang.String".equals(sig.getReturnType());
    }
}

