/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib;

import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.plugin.logging.Log;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.AbstractValidatorTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ValidatorBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public class TrinidadValidatorTagGenerator
extends AbstractValidatorTagGenerator {
    public TrinidadValidatorTagGenerator(boolean _is12, String _licenseHeader, Log _log) {
        super(_is12, _licenseHeader, _log);
    }

    protected Set createImports(ValidatorBean validator) {
        TreeSet<String> imports = new TreeSet<String>();
        if (this.is12()) {
            imports.add("javax.faces.webapp.ValidatorELTag");
            imports.add("javax.faces.context.FacesContext");
            imports.add("javax.faces.application.Application");
        } else {
            imports.add("javax.faces.webapp.ValidatorTag");
        }
        imports.add("javax.servlet.jsp.JspException");
        imports.add(validator.getValidatorClass());
        imports.add("javax.faces.validator.Validator");
        if (this.is12()) {
            imports.add("javax.el.ValueExpression");
        } else {
            imports.add("javax.faces.el.ValueBinding");
        }
        imports.add("org.apache.myfaces.trinidadinternal.taglib.util.TagUtils");
        this.addImportsFromPropertes(validator, imports);
        return imports;
    }

    protected void writeSetProperty(PrettyWriter out, PropertyBean property) {
        String propName = property.getPropertyName();
        String propFullClass = property.getPropertyClass();
        String propClass = Util.getClassFromFullClass(propFullClass);
        String propVar = "_" + Util.getVariableFromName(propName);
        out.println("if (" + propVar + " != null)");
        out.println("{");
        out.indent();
        if (this.is12()) {
            out.println("if (!" + propVar + ".isLiteralText())");
            out.println("{");
            out.indent();
            out.println("validator.setValueExpression(\"" + propName + "\", " + propVar + ");");
            out.unindent();
            out.println("}");
            String propType = null;
            propType = "Date".equals(propClass) ? this.resolveDateType(propFullClass, property.getUseMaxTime()) : this.resolveType(propFullClass);
            if (propType != null) {
                out.println("else");
                out.println("{");
                out.indent();
                if ("StringArray".equals(propType)) {
                    out.println("try");
                    out.println("{");
                }
                out.println(propClass + " value = TagUtils.get" + propType + "(" + propVar + ".getValue(null));");
                String setMethod = Util.getPrefixedPropertyName("set", propName);
                out.println("validator." + setMethod + "(value);");
                if ("StringArray".equals(propType)) {
                    out.println("}");
                    out.println("catch (ParseException pe)");
                    out.println("{");
                    out.indent();
                    out.println("throw new JspException(");
                    out.println("  pe.getMessage() + \": \" + \"Position \" + pe.getErrorOffset());");
                    out.unindent();
                    out.println("}");
                }
                out.unindent();
                out.println("}");
            }
        } else {
            out.println("if (TagUtils.isValueReference(" + propVar + "))");
            out.println("{");
            out.indent();
            out.println("ValueBinding vb = TagUtils.getValueBinding(" + propVar + ");");
            out.println("validator.setValueBinding(\"" + propName + "\", vb);");
            out.unindent();
            out.println("}");
            String propType = null;
            propType = "Date".equals(propClass) ? this.resolveDateType(propFullClass, property.getUseMaxTime()) : this.resolveType(propFullClass);
            if (propType != null) {
                out.println("else");
                out.println("{");
                out.indent();
                if ("StringArray".equals(propType)) {
                    out.println("try");
                    out.println("{");
                }
                out.println(propClass + " value = TagUtils.get" + propType + "(" + propVar + ");");
                String setMethod = Util.getPrefixedPropertyName("set", propName);
                out.println("validator." + setMethod + "(value);");
                if ("StringArray".equals(propType)) {
                    out.println("}");
                    out.println("catch (ParseException pe)");
                    out.println("{");
                    out.indent();
                    out.println("throw new JspException(");
                    out.println("  pe.getMessage() + \": \" + \"Position \" + pe.getErrorOffset());");
                    out.unindent();
                    out.println("}");
                }
                out.unindent();
                out.println("}");
            }
        }
        out.unindent();
        out.println("}");
    }
}

