/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class PrettyWriter
extends PrintWriter {
    private int _indentation;
    private boolean _pending = true;
    private static final String _TAB_INDENT = "  ";
    private static final char[] _TAB_INDENT_CHARS = "  ".toCharArray();

    public PrettyWriter(OutputStream out) {
        super(out);
    }

    public PrettyWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public PrettyWriter(Writer out) {
        super(out);
    }

    public PrettyWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void indent() {
        ++this._indentation;
    }

    public void unindent() {
        --this._indentation;
    }

    public void write(String string, int offset, int length) {
        if (this._unlatchPending()) {
            for (int i = 0; i < this._indentation; ++i) {
                super.write(_TAB_INDENT, 0, 2);
            }
        }
        super.write(string, offset, length);
    }

    public void write(char[] chars, int offset, int length) {
        if (this._unlatchPending()) {
            for (int i = 0; i < this._indentation; ++i) {
                super.write(_TAB_INDENT_CHARS, 0, 2);
            }
        }
        super.write(chars, offset, length);
    }

    public void println() {
        super.println();
        this._latchPending();
    }

    public void println(boolean x) {
        super.println(x);
        this._latchPending();
    }

    public void println(char x) {
        super.println(x);
        this._latchPending();
    }

    public void println(int x) {
        super.println(x);
        this._latchPending();
    }

    public void println(long x) {
        super.println(x);
        this._latchPending();
    }

    public void println(float x) {
        super.println(x);
        this._latchPending();
    }

    public void println(double x) {
        super.println(x);
        this._latchPending();
    }

    public void println(char[] x) {
        super.println(x);
        this._latchPending();
    }

    public void println(String x) {
        int fromIndex = 0;
        int index = x.indexOf(10);
        while (index != -1 && index + 1 < x.length()) {
            super.println(x.substring(fromIndex, index));
            this._latchPending();
            fromIndex = index + 1;
            index = x.indexOf(10, fromIndex);
        }
        super.println(x.substring(fromIndex));
        this._latchPending();
    }

    public void println(Object x) {
        super.println(x);
        this._latchPending();
    }

    private boolean _unlatchPending() {
        boolean pending = this._pending;
        if (pending) {
            this._pending = false;
        }
        return pending;
    }

    private boolean _latchPending() {
        boolean pending = this._pending;
        if (!pending) {
            this._pending = true;
        }
        return !pending;
    }
}

