/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.parse;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ExampleBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ObjectBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;

public class AbstractTagBean
extends ObjectBean {
    private String _description;
    private String _longDescription;
    private QName _tagName;
    private String _tagClass;
    protected Map _properties;
    private int _tagClassModifiers;
    private Map _examples;
    private int _exampleIdx = 0;

    public AbstractTagBean() {
        this(false);
    }

    public AbstractTagBean(boolean isComponentBean) {
        if (!isComponentBean) {
            this._properties = new LinkedHashMap();
        }
        this._examples = new LinkedHashMap();
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setLongDescription(String longDescription) {
        this._longDescription = longDescription;
    }

    public String getLongDescription() {
        return this._longDescription;
    }

    public void setTagClass(String tagClass) {
        this._tagClass = tagClass;
    }

    public String getTagClass() {
        return this._tagClass;
    }

    public void setTagName(QName tagName) {
        this._tagName = tagName;
    }

    public QName getTagName() {
        return this._tagName;
    }

    public void addProperty(PropertyBean property) {
        this._properties.put(property.getPropertyName(), property);
    }

    public PropertyBean findProperty(String propertyName) {
        return (PropertyBean)this._properties.get(propertyName);
    }

    public boolean hasProperties() {
        return !this._properties.isEmpty();
    }

    public Iterator properties() {
        return this._properties.values().iterator();
    }

    public void addExample(ExampleBean example) {
        String key = this._generateExampleKey();
        example.setKey(key);
        this._examples.put(key, example);
    }

    public boolean hasExamples() {
        return !this._examples.isEmpty();
    }

    public ExampleBean findExample(String key) {
        return (ExampleBean)this._examples.get(key);
    }

    public Iterator examples() {
        return this._examples.values().iterator();
    }

    public void parseTagClassModifier(String modifier) {
        this.addTagClassModifier(this._parseModifier(modifier));
    }

    protected int _parseModifier(String text) {
        if ("public".equals(text)) {
            return 1;
        }
        if ("protected".equals(text)) {
            return 4;
        }
        if ("private".equals(text)) {
            return 2;
        }
        if ("abstract".equals(text)) {
            return 1024;
        }
        if ("final".equals(text)) {
            return 16;
        }
        throw new IllegalArgumentException("Unrecognized modifier: " + text);
    }

    public void addTagClassModifier(int modifier) {
        this._tagClassModifiers |= modifier;
    }

    public int getTagClassModifiers() {
        int modifiers = this._tagClassModifiers;
        if (!(Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers))) {
            modifiers |= 1;
        }
        return modifiers;
    }

    public int propertiesSize() {
        return this._properties.size();
    }

    private String _generateExampleKey() {
        String key = "Example" + Integer.toString(this._exampleIdx);
        ++this._exampleIdx;
        return key;
    }
}

