/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.parse;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.MethodSignatureBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ObjectBean;

public class AttributeBean
extends ObjectBean
implements Comparable {
    private String _attributeName;
    private String _attributeClass;
    private String[] _attributeClassParameters;
    private String _description;
    private String _defaultValue;
    private String _alternateClass;
    private boolean _virtual;
    private MethodSignatureBean _signature;
    private static final Pattern _GENERIC_TYPE = Pattern.compile("([^<]+)<(.+)>");
    private static final String[] _EMPTY_ARRAY = new String[0];

    public void setAttributeName(String attributeName) {
        this._attributeName = attributeName;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public void setAttributeClass(String attributeClass) {
        Matcher matcher = _GENERIC_TYPE.matcher(attributeClass);
        if (matcher.matches()) {
            this._attributeClass = matcher.group(1);
            this._attributeClassParameters = matcher.group(2).split(",");
        } else {
            this._attributeClass = attributeClass;
            this._attributeClassParameters = _EMPTY_ARRAY;
        }
    }

    public String[] getAttributeClassParameters() {
        return this._attributeClassParameters;
    }

    public String getAttributeClass() {
        return this._attributeClass;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public void setAlternateClass(String alternateClass) {
        this._alternateClass = alternateClass;
    }

    public String getAlternateClass() {
        return this._alternateClass;
    }

    public void setMethodBindingSignature(MethodSignatureBean signature) {
        this._signature = signature;
    }

    public MethodSignatureBean getMethodBindingSignature() {
        return this._signature;
    }

    public void setVirtual(boolean virtual) {
        this._virtual = virtual;
    }

    public boolean isVirtual() {
        return this._virtual;
    }

    public int compareTo(Object o) {
        if (o instanceof AttributeBean) {
            AttributeBean attr = (AttributeBean)o;
            return this._attributeName.compareTo(attr._attributeName);
        }
        return 1;
    }
}

