/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.parse;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.AbstractTagBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.EventBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.EventRefBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacesConfigBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacetBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.CompoundIterator;

public class ComponentBean
extends AbstractTagBean {
    private String _description;
    private String _longDescription;
    private String _componentType;
    private String _componentFamily;
    private String _componentClass;
    private String _componentSupertype;
    private String _componentSuperclass;
    private String _rendererType;
    private String _implementationType;
    private String _tagHandler;
    private String _tagSuperclass;
    private String _localName;
    private String _nodeClass;
    private boolean _namingContainer;
    private boolean _children = true;
    private Map _properties;
    private Map _facets;
    private Map _events;
    private int _componentClassModifiers;
    private int _tagClassModifiers;
    private String[] _unsupportedAgents = new String[0];
    private static final String _TRINIDAD_COMPONENT_BASE = "org.apache.myfaces.trinidad.component.UIXComponentBase";
    private static final String _TRINIDAD_COMPONENT_TAG = "org.apache.myfaces.trinidad.webapp.UIXComponentTag";
    private static final Logger _LOG = Logger.getLogger(ComponentBean.class.getName());

    public ComponentBean() {
        super(true);
        this._properties = new LinkedHashMap();
        this._facets = new LinkedHashMap();
        this._events = new LinkedHashMap();
    }

    public void setLocalName(String localName) {
        this._localName = localName;
    }

    public String getLocalName() {
        return this._localName;
    }

    public void setNodeClass(String nodeClass) {
        this._nodeClass = nodeClass;
    }

    public String getNodeClass() {
        return this._nodeClass;
    }

    public void setComponentType(String componentType) {
        this._componentType = componentType;
    }

    public String getComponentType() {
        return this._componentType;
    }

    public void setComponentFamily(String componentFamily) {
        this._componentFamily = componentFamily;
    }

    public String getComponentFamily() {
        return this._componentFamily;
    }

    public boolean hasComponentFamily() {
        return this._componentFamily != null;
    }

    public void setComponentClass(String componentClass) {
        this._componentClass = componentClass;
    }

    public String getComponentClass() {
        return this._componentClass;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setLongDescription(String longDescription) {
        this._longDescription = longDescription;
    }

    public String getLongDescription() {
        return this._longDescription;
    }

    public void setUnsupportedAgents(String[] unsupportedAgents) {
        if (unsupportedAgents == null) {
            throw new NullPointerException("unsupportedAgents");
        }
        this._unsupportedAgents = unsupportedAgents;
    }

    public String[] getUnsupportedAgents() {
        return this._unsupportedAgents;
    }

    public void setTagSuperclass(String tagSuperclass) {
        this._tagSuperclass = tagSuperclass;
    }

    public String getTagSuperclass() {
        return this._tagSuperclass;
    }

    public void setTagHandler(String tagHandler) {
        this._tagHandler = tagHandler;
    }

    public String getTagHandler() {
        return this._tagHandler;
    }

    public void setNamingContainer(boolean namingContainer) {
        this._namingContainer = namingContainer;
    }

    public boolean isNamingContainer() {
        return this._namingContainer;
    }

    public void setComponentSupertype(String componentSupertype) {
        this._componentSupertype = componentSupertype;
    }

    public String getComponentSupertype() {
        return this._componentSupertype;
    }

    public void setComponentSuperclass(String componentSuperclass) {
        this._componentSuperclass = componentSuperclass;
    }

    public String getComponentSuperclass() {
        return this._componentSuperclass;
    }

    public void setRendererType(String rendererType) {
        this._rendererType = rendererType;
    }

    public String getRendererType() {
        return this._rendererType;
    }

    public String getDefaultRendererType() {
        ComponentBean parent = this.resolveSupertype();
        return parent != null ? parent.findRendererType() : null;
    }

    public String getImplementationType() {
        return this._implementationType;
    }

    public void setImplementationType(String implementationType) {
        this._implementationType = implementationType;
    }

    public void addProperty(PropertyBean property) {
        this._properties.put(property.getPropertyName(), property);
    }

    public PropertyBean findProperty(String propertyName) {
        return (PropertyBean)this._properties.get(propertyName);
    }

    public PropertyBean findProperty(String propertyName, boolean flatten) {
        ComponentBean parent;
        PropertyBean prop = this.findProperty(propertyName);
        if (prop == null && flatten && (parent = this.resolveSupertype()) != null) {
            prop = parent.findProperty(propertyName, flatten);
        }
        return prop;
    }

    public boolean hasProperties() {
        return this.hasProperties(false);
    }

    public boolean hasProperties(boolean flatten) {
        ComponentBean parent;
        boolean hasProperties;
        boolean bl = hasProperties = !this._properties.isEmpty();
        if (!hasProperties && flatten && (parent = this.resolveSupertype()) != null) {
            hasProperties |= parent.hasProperties(flatten);
        }
        return hasProperties;
    }

    public Iterator properties() {
        return this._properties.values().iterator();
    }

    public Iterator properties(boolean flatten) {
        if (flatten) {
            return this.getFlattenedProperties().values().iterator();
        }
        return this.properties();
    }

    protected Map getFlattenedProperties() {
        HashMap props = new HashMap(this._properties);
        ComponentBean parent = this.resolveSupertype();
        if (parent != null) {
            Map superProps = parent.getFlattenedProperties();
            Iterator iter = superProps.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (props.containsKey(entry.getKey())) continue;
                props.put(entry.getKey(), entry.getValue());
            }
        }
        return props;
    }

    public int propertiesSize() {
        return this._properties.size();
    }

    public void addFacet(FacetBean facet) {
        this._facets.put(facet.getFacetName(), facet);
    }

    public FacetBean findFacet(String facetName) {
        return (FacetBean)this._facets.get(facetName);
    }

    public FacetBean findFacet(String facetName, boolean flatten) {
        ComponentBean parent;
        FacetBean facet = this.findFacet(facetName);
        if (facet == null && flatten && (parent = this.resolveSupertype()) != null) {
            facet = parent.findFacet(facetName, flatten);
        }
        return facet;
    }

    public boolean hasFacets() {
        return this.hasFacets(false);
    }

    public boolean hasFacets(boolean flatten) {
        ComponentBean parent;
        boolean hasFacets;
        boolean bl = hasFacets = !this._facets.isEmpty();
        if (!hasFacets && flatten && (parent = this.resolveSupertype()) != null) {
            hasFacets |= parent.hasFacets(flatten);
        }
        return hasFacets;
    }

    public Iterator facets() {
        return this._facets.values().iterator();
    }

    public Iterator facets(boolean flatten) {
        if (flatten) {
            return this.getFlattenedFacets().values().iterator();
        }
        return this.facets();
    }

    protected Map getFlattenedFacets() {
        HashMap facets = new HashMap(this._facets);
        ComponentBean parent = this.resolveSupertype();
        if (parent != null) {
            Map superFacets = parent.getFlattenedFacets();
            Iterator iter = superFacets.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (facets.containsKey(entry.getKey())) continue;
                facets.put(entry.getKey(), entry.getValue());
            }
        }
        return facets;
    }

    public void setChildren(boolean children) {
        this._children = children;
    }

    public boolean hasChildren() {
        return this._children;
    }

    public void addComponentClassModifier(int modifier) {
        this._componentClassModifiers |= modifier;
    }

    public int getComponentClassModifiers() {
        int modifiers = this._componentClassModifiers;
        if (!(Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers))) {
            modifiers |= 1;
        }
        return modifiers;
    }

    public void parseComponentClassModifier(String modifier) {
        this.addComponentClassModifier(this._parseModifier(modifier));
    }

    public void parseTagClassModifier(String modifier) {
        this.addTagClassModifier(this._parseModifier(modifier));
    }

    public void parseUnsupportedAgents(String unsupportedAgents) {
        this.setUnsupportedAgents(unsupportedAgents.split(" "));
    }

    public void addTagClassModifier(int modifier) {
        this._tagClassModifiers |= modifier;
    }

    public int getTagClassModifiers() {
        int modifiers = this._tagClassModifiers;
        if (!(Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers))) {
            modifiers |= 1;
        }
        return modifiers;
    }

    public void addEvent(EventRefBean eventRef) {
        if (eventRef.getEventType() == null) {
            _LOG.warning("Missing event type in component \"" + this._componentType + "\"");
        } else {
            this._events.put(eventRef.getEventType(), eventRef);
        }
    }

    public boolean hasEvents() {
        return this.hasEvents(false);
    }

    public boolean hasEvents(boolean flatten) {
        ComponentBean parent;
        boolean hasEvents;
        boolean bl = hasEvents = !this._events.isEmpty();
        if (!hasEvents && flatten && (parent = this.resolveSupertype()) != null) {
            hasEvents |= parent.hasEvents(flatten);
        }
        return hasEvents;
    }

    public EventBean findEvent(String eventName) {
        return (EventBean)this._events.get(eventName);
    }

    public EventBean findEvent(String eventName, boolean flatten) {
        ComponentBean parent;
        EventBean event = this.findEvent(eventName);
        if (event == null && flatten && (parent = this.resolveSupertype()) != null) {
            event = parent.findEvent(eventName, flatten);
        }
        return event;
    }

    public Iterator events() {
        return this._events.values().iterator();
    }

    public Iterator events(boolean flatten) {
        ComponentBean parent;
        Iterator events = this.events();
        if (flatten && (parent = this.resolveSupertype()) != null) {
            events = new CompoundIterator(events, parent.events(true));
        }
        return events;
    }

    public String findComponentFamily() {
        if (this._componentFamily != null) {
            return this._componentFamily;
        }
        ComponentBean parent = this.resolveSupertype();
        return parent != null ? parent.findComponentFamily() : null;
    }

    public ComponentBean findBehavioralComponent() {
        if (this._componentFamily != null) {
            return this;
        }
        ComponentBean component = this.resolveSupertype();
        return component != null ? component.findBehavioralComponent() : this;
    }

    public String findRendererType() {
        if (this._rendererType != null) {
            return this._rendererType;
        }
        ComponentBean parent = this.resolveSupertype();
        return parent != null ? parent.findRendererType() : null;
    }

    public String findComponentSuperclass() {
        if (this._componentSuperclass != null) {
            return this._componentSuperclass;
        }
        ComponentBean parent = this.resolveSupertype();
        return parent != null ? parent.findComponentClass() : _TRINIDAD_COMPONENT_BASE;
    }

    public String findJspTagSuperclass() {
        if (this._tagSuperclass != null) {
            return this._tagSuperclass;
        }
        ComponentBean parent = this.resolveSupertype();
        return parent != null ? parent.findJspTagClass() : _TRINIDAD_COMPONENT_TAG;
    }

    public ComponentBean resolveSupertype() {
        if (this._componentSupertype == null) {
            return null;
        }
        FacesConfigBean owner = this.getOwner();
        return owner != null ? owner.findComponent(this._componentSupertype) : null;
    }

    public boolean isTrinidadComponent() {
        String implementationType = this.getImplementationType();
        if (implementationType != null) {
            return "trinidad".equals(implementationType);
        }
        ComponentBean componentSupertype = this.resolveSupertype();
        if (componentSupertype != null) {
            if (_TRINIDAD_COMPONENT_BASE.equals(componentSupertype.getComponentClass())) {
                return true;
            }
            return componentSupertype.isTrinidadComponent();
        }
        return false;
    }

    protected String findComponentClass() {
        if (this._componentClass != null) {
            return this._componentClass;
        }
        ComponentBean parent = this.resolveSupertype();
        return parent != null ? parent.findComponentClass() : null;
    }

    protected String findJspTagClass() {
        String tagClass = this.getTagClass();
        if (tagClass != null) {
            return tagClass;
        }
        ComponentBean parent = this.resolveSupertype();
        return parent != null ? parent.findJspTagClass() : null;
    }

    protected void attach(FacesConfigBean owner) {
        super.attach(owner);
        Iterator events = this.events(false);
        while (events.hasNext()) {
            EventRefBean eventRef = (EventRefBean)events.next();
            eventRef.attach(owner);
        }
    }
}

