/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.parse;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ConverterBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.EventBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ObjectBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.RenderKitBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ValidatorBean;

public class FacesConfigBean
extends ObjectBean {
    private Map _converters = new TreeMap();
    private Map _validators = new TreeMap();
    private Map _components = new TreeMap();
    private Map _events = new TreeMap();
    private Map _renderKits = new TreeMap();
    private URL _currentResource = null;
    private static final Logger _LOG = Logger.getLogger(FacesConfigBean.class.getName());

    public void addConverter(ConverterBean converter) {
        converter.attach(this);
        if (converter.hasConverterId()) {
            this._converters.put(converter.getConverterId(), converter);
        }
    }

    public ConverterBean findConverter(String converterId) {
        return (ConverterBean)this._converters.get(converterId);
    }

    public boolean hasConverters() {
        return !this._converters.isEmpty();
    }

    public Iterator converters() {
        return this._converters.values().iterator();
    }

    public void addValidator(ValidatorBean validator) {
        validator.attach(this);
        if (validator.hasValidatorId()) {
            this._validators.put(validator.getValidatorId(), validator);
        }
    }

    public ValidatorBean findValidator(String validatorId) {
        return (ValidatorBean)this._validators.get(validatorId);
    }

    public boolean hasValidators() {
        return !this._validators.isEmpty();
    }

    public Iterator validators() {
        return this._validators.values().iterator();
    }

    public void addComponent(ComponentBean component) {
        if (component.getComponentType() != null) {
            component.attach(this);
            this._components.put(component.getComponentType(), component);
        }
    }

    public ComponentBean findComponent(String componentType) {
        return (ComponentBean)this._components.get(componentType);
    }

    public boolean hasComponents() {
        return !this._components.isEmpty();
    }

    public Iterator components() {
        return this._components.values().iterator();
    }

    public void addEvent(EventBean event) {
        if (event.getEventType() == null) {
            this._warning("Missing event type");
        } else if (event.getEventListenerClass() == null) {
            this._warning("Event \"" + event.getEventType() + "\" " + "has no listener class");
        } else if (event.getEventClass() == null) {
            this._warning("Event \"" + event.getEventType() + "\" " + "has no event class");
        } else {
            event.attach(this);
            this._events.put(event.getEventType(), event);
        }
    }

    private void _warning(String s) {
        _LOG.warning(s + "\n  parsing resource:" + this.getCurrentResource());
    }

    public EventBean findEvent(String eventType) {
        return (EventBean)this._events.get(eventType);
    }

    public boolean hasEvents() {
        return !this._events.isEmpty();
    }

    public Iterator events() {
        return this._events.values().iterator();
    }

    public void addRenderKit(RenderKitBean renderKit) {
        String renderKitId = renderKit.getRenderKitId();
        RenderKitBean existing = this.findRenderKit(renderKitId);
        if (existing == null) {
            renderKit.attach(this);
            this._renderKits.put(renderKitId, renderKit);
        } else {
            existing.addAllRenderers(renderKit);
        }
    }

    public RenderKitBean findRenderKit(String renderKitId) {
        return (RenderKitBean)this._renderKits.get(renderKitId);
    }

    public boolean hasRenderKits() {
        return !this._renderKits.isEmpty();
    }

    public Iterator renderKits() {
        return this._renderKits.values().iterator();
    }

    public URL getCurrentResource() {
        return this._currentResource;
    }

    public URL setCurrentResource(URL resource) {
        URL _cur = this._currentResource;
        this._currentResource = resource;
        return _cur;
    }
}

