/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.parse;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ConverterBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.EventBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.EventRefBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ExampleBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacesConfigBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacetBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.MethodSignatureBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.RenderKitBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.RendererBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ValidatorBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.rules.BeanPropertySetterRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FacesConfigParser {
    public void merge(FacesConfigBean owner, URL url) throws MojoExecutionException {
        try {
            URLConnection conn = url.openConnection();
            long lastModified = conn.getLastModified();
            InputStream is = conn.getInputStream();
            if (is != null) {
                owner.touch(lastModified);
                Digester digester = this.createDigester();
                digester.push((Object)url);
                digester.push((Object)owner);
                digester.parse(is);
                is.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse " + url, (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Failed to parse " + url, (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Failed to parse " + url, (Exception)e);
        }
    }

    protected static Digester createEmptyDigester() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        Digester digester = new Digester(spf.newSAXParser());
        digester.setNamespaceAware(true);
        return digester;
    }

    protected static void addComponentDigesterRules(Digester digester, boolean withCreate) {
        digester.setRuleNamespaceURI("http://java.sun.com/xml/ns/javaee");
        if (withCreate) {
            digester.addObjectCreate("faces-config/component", ComponentBean.class);
            digester.addBeanPropertySetter("faces-config/component/component-type", "componentType");
            digester.addBeanPropertySetter("faces-config/component/component-class", "componentClass");
            digester.addBeanPropertySetter("faces-config/component/description");
            digester.addSetNext("faces-config/component", "addComponent", ComponentBean.class.getName());
        }
        digester.addObjectCreate("faces-config/component/property", PropertyBean.class);
        digester.addBeanPropertySetter("faces-config/component/property/property-name", "propertyName");
        digester.addBeanPropertySetter("faces-config/component/property/property-class", "propertyClass");
        digester.addBeanPropertySetter("faces-config/component/property/description");
        digester.addBeanPropertySetter("faces-config/component/property/default-value", "defaultValue");
        digester.addSetNext("faces-config/component/property", "addProperty", PropertyBean.class.getName());
        digester.addObjectCreate("faces-config/component/facet", FacetBean.class);
        digester.addBeanPropertySetter("faces-config/component/facet/facet-name", "facetName");
        digester.addBeanPropertySetter("faces-config/component/facet/description");
        digester.addSetNext("faces-config/component/facet", "addFacet", FacetBean.class.getName());
        digester.setRuleNamespaceURI("http://myfaces.apache.org/maven-faces-plugin");
        digester.addBeanPropertySetter("faces-config/component/facet/facet-extension/hidden");
        digester.addObjectCreate("faces-config/component/facet/example", ExampleBean.class);
        digester.addBeanPropertySetter("faces-config/component/facet/example/source-description", "sourceDescription");
        digester.addBeanPropertySetter("faces-config/component/facet/example/source-code", "sourceCode");
        digester.addSetNext("faces-config/component/facet/example", "addExample", ExampleBean.class.getName());
        digester.addBeanPropertySetter("faces-config/component/component-extension/long-description", "longDescription");
        digester.addBeanPropertySetter("faces-config/component/component-extension/component-family", "componentFamily");
        digester.addBeanPropertySetter("faces-config/component/component-extension/component-supertype", "componentSupertype");
        digester.addBeanPropertySetter("faces-config/component/component-extension/component-superclass", "componentSuperclass");
        digester.addBeanPropertySetter("faces-config/component/component-extension/renderer-type", "rendererType");
        digester.addBeanPropertySetter("faces-config/component/component-extension/naming-container", "namingContainer");
        digester.addBeanPropertySetter("faces-config/component/component-extension/accepts-child-components", "children");
        digester.addBeanPropertySetter("faces-config/component/component-extension/tag-class", "tagClass");
        digester.addBeanPropertySetter("faces-config/component/component-extension/tag-superclass", "tagSuperclass");
        digester.addBeanPropertySetter("faces-config/component/component-extension/tag-handler", "tagHandler");
        digester.addBeanPropertySetter("faces-config/component/component-extension/implementation-type", "implementationType");
        digester.addCallMethod("faces-config/component/component-extension/tag-class-modifier", "parseTagClassModifier", 1);
        digester.addCallParam("faces-config/component/component-extension/tag-class-modifier", 0);
        digester.addCallMethod("faces-config/component/component-extension/unsupported-agents", "parseUnsupportedAgents", 1);
        digester.addCallParam("faces-config/component/component-extension/unsupported-agents", 0);
        digester.addCallMethod("faces-config/component/component-extension/component-class-modifier", "parseComponentClassModifier", 1);
        digester.addCallParam("faces-config/component/component-extension/component-class-modifier", 0);
        digester.addRule("faces-config/component/component-extension/tag-name", (Rule)new BeanPropertySetterRule("tagName"));
        digester.addBeanPropertySetter("faces-config/component/component-extension/uix2-local-name", "localName");
        digester.addBeanPropertySetter("faces-config/component/component-extension/uix2-node-class", "nodeClass");
        digester.addObjectCreate("faces-config/component/component-extension/example", ExampleBean.class);
        digester.addBeanPropertySetter("faces-config/component/component-extension/example/source-description", "sourceDescription");
        digester.addBeanPropertySetter("faces-config/component/component-extension/example/source-code", "sourceCode");
        digester.addSetNext("faces-config/component/component-extension/example", "addExample", ExampleBean.class.getName());
        digester.addObjectCreate("faces-config/component/component-extension/event", EventRefBean.class);
        digester.addBeanPropertySetter("faces-config/component/component-extension/event/event-type", "eventType");
        digester.addBeanPropertySetter("faces-config/component/component-extension/event/event-delivery-phase", "eventDeliveryPhases");
        digester.addBeanPropertySetter("faces-config/component/component-extension/event/ignore-source-interface", "ignoreSourceInterface");
        digester.addSetNext("faces-config/component/component-extension/event", "addEvent", EventRefBean.class.getName());
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/state-holder", "stateHolder");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/jsp-property-name", "jspPropertyName");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/list", "list");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/required");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/alias-of", "aliasOf");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/virtual");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/transient");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/literal-only", "literalOnly");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/enum", "enum");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/alternate-class", "alternateClass");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/tag-attribute-excluded", "tagAttributeExcluded");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/hidden");
        digester.addCallMethod("faces-config/component/property/property-extension/property-values", "parsePropertyValues", 1);
        digester.addCallParam("faces-config/component/property/property-extension/property-values", 0);
        digester.addCallMethod("faces-config/component/property/property-extension/unsupported-agents", "parseUnsupportedAgents", 1);
        digester.addCallParam("faces-config/component/property/property-extension/unsupported-agents", 0);
        digester.addCallMethod("faces-config/component/property/property-extension/unsupported-render-kits", "parseUnsupportedRenderKits", 1);
        digester.addCallParam("faces-config/component/property/property-extension/unsupported-render-kits", 0);
        digester.addObjectCreate("faces-config/component/property/property-extension/method-binding-signature", MethodSignatureBean.class);
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/method-binding-signature/return-type", "returnType");
        digester.addCallMethod("faces-config/component/property/property-extension/method-binding-signature/parameter-type", "addParameterType", 1);
        digester.addCallParam("faces-config/component/property/property-extension/method-binding-signature/parameter-type", 0);
        digester.addSetNext("faces-config/component/property/property-extension/method-binding-signature", "setMethodBindingSignature", MethodSignatureBean.class.getName());
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/property-metadata/use-max-time", "useMaxTime");
        digester.addBeanPropertySetter("faces-config/component/property/property-extension/property-metadata/deprecated");
        digester.addCallMethod("faces-config/component/property/property-extension/property-metadata/no-op", "makeNoOp");
        digester.setRuleNamespaceURI("http://www.w3.org/2001/XInclude");
        digester.addFactoryCreate("faces-config/component/include", ComponentIncludeFactory.class);
    }

    protected static void addConverterDigesterRules(Digester digester) {
        digester.setRuleNamespaceURI("http://java.sun.com/xml/ns/javaee");
        digester.addObjectCreate("faces-config/converter", ConverterBean.class);
        digester.addBeanPropertySetter("faces-config/converter/converter-id", "converterId");
        digester.addBeanPropertySetter("faces-config/converter/converter-class", "converterClass");
        digester.addBeanPropertySetter("faces-config/converter/description");
        digester.addSetNext("faces-config/converter", "addConverter", ConverterBean.class.getName());
        digester.addObjectCreate("faces-config/converter/property", PropertyBean.class);
        digester.addBeanPropertySetter("faces-config/converter/property/property-name", "propertyName");
        digester.addBeanPropertySetter("faces-config/converter/property/property-class", "propertyClass");
        digester.addBeanPropertySetter("faces-config/converter/property/description");
        digester.addBeanPropertySetter("faces-config/converter/property/default-value", "defaultValue");
        digester.addSetNext("faces-config/converter/property", "addProperty", PropertyBean.class.getName());
        digester.setRuleNamespaceURI("http://myfaces.apache.org/maven-faces-plugin");
        digester.addBeanPropertySetter("faces-config/converter/converter-extension/long-description", "longDescription");
        digester.addBeanPropertySetter("faces-config/converter/converter-extension/tag-class", "tagClass");
        digester.addRule("faces-config/converter/converter-extension/tag-name", (Rule)new BeanPropertySetterRule("tagName"));
        digester.addCallMethod("faces-config/converter/converter-extension/tag-class-modifier", "parseTagClassModifier", 1);
        digester.addCallParam("faces-config/converter/converter-extension/tag-class-modifier", 0);
        digester.addObjectCreate("faces-config/converter/converter-extension/example", ExampleBean.class);
        digester.addBeanPropertySetter("faces-config/converter/converter-extension/example/source-description", "sourceDescription");
        digester.addBeanPropertySetter("faces-config/converter/converter-extension/example/source-code", "sourceCode");
        digester.addSetNext("faces-config/converter/converter-extension/example", "addExample", ExampleBean.class.getName());
        digester.addBeanPropertySetter("faces-config/converter/property/property-extension/tag-attribute-excluded", "tagAttributeExcluded");
    }

    protected static void addValidatorDigesterRules(Digester digester) {
        digester.setRuleNamespaceURI("http://java.sun.com/xml/ns/javaee");
        digester.addObjectCreate("faces-config/validator", ValidatorBean.class);
        digester.addBeanPropertySetter("faces-config/validator/validator-id", "validatorId");
        digester.addBeanPropertySetter("faces-config/validator/validator-class", "validatorClass");
        digester.addBeanPropertySetter("faces-config/validator/description");
        digester.addSetNext("faces-config/validator", "addValidator", ValidatorBean.class.getName());
        digester.addObjectCreate("faces-config/validator/property", PropertyBean.class);
        digester.addBeanPropertySetter("faces-config/validator/property/property-name", "propertyName");
        digester.addBeanPropertySetter("faces-config/validator/property/property-class", "propertyClass");
        digester.addBeanPropertySetter("faces-config/validator/property/description");
        digester.addBeanPropertySetter("faces-config/validator/property/default-value", "defaultValue");
        digester.addSetNext("faces-config/validator/property", "addProperty", PropertyBean.class.getName());
        digester.setRuleNamespaceURI("http://myfaces.apache.org/maven-faces-plugin");
        digester.addBeanPropertySetter("faces-config/validator/validator-extension/long-description", "longDescription");
        digester.addBeanPropertySetter("faces-config/validator/validator-extension/tag-class", "tagClass");
        digester.addRule("faces-config/validator/validator-extension/tag-name", (Rule)new BeanPropertySetterRule("tagName"));
        digester.addCallMethod("faces-config/validator/validator-extension/tag-class-modifier", "parseTagClassModifier", 1);
        digester.addCallParam("faces-config/validator/validator-extension/tag-class-modifier", 0);
        digester.addObjectCreate("faces-config/validator/validator-extension/example", ExampleBean.class);
        digester.addBeanPropertySetter("faces-config/validator/validator-extension/example/source-description", "sourceDescription");
        digester.addBeanPropertySetter("faces-config/validator/validator-extension/example/source-code", "sourceCode");
        digester.addSetNext("faces-config/validator/validator-extension/example", "addExample", ExampleBean.class.getName());
        digester.addBeanPropertySetter("faces-config/validator/property/property-extension/tag-attribute-excluded", "tagAttributeExcluded");
        digester.addBeanPropertySetter("faces-config/validator/property/property-extension/property-metadata/use-max-time", "useMaxTime");
    }

    protected static void addRenderKitDigesterRules(Digester digester) {
        digester.setRuleNamespaceURI("http://java.sun.com/xml/ns/javaee");
        digester.addObjectCreate("faces-config/render-kit", RenderKitBean.class);
        digester.addBeanPropertySetter("faces-config/render-kit/render-kit-id", "renderKitId");
        digester.addSetNext("faces-config/render-kit", "addRenderKit", RenderKitBean.class.getName());
        digester.addObjectCreate("faces-config/render-kit/renderer", RendererBean.class);
        digester.addBeanPropertySetter("faces-config/render-kit/renderer/description");
        digester.addBeanPropertySetter("faces-config/render-kit/renderer/component-family", "componentFamily");
        digester.addBeanPropertySetter("faces-config/render-kit/renderer/renderer-type", "rendererType");
        digester.addBeanPropertySetter("faces-config/render-kit/renderer/renderer-class", "rendererClass");
        digester.addSetNext("faces-config/render-kit/renderer", "addRenderer", RendererBean.class.getName());
        digester.setRuleNamespaceURI("http://myfaces.apache.org/maven-faces-plugin");
        digester.addBeanPropertySetter("faces-config/render-kit/renderer/renderer-extension/component-type", "componentType");
        digester.addBeanPropertySetter("faces-config/render-kit/renderer/renderer-extension/renderer-superclass", "rendererSuperclass");
    }

    protected static void addEventDigesterRules(Digester digester) {
        digester.setRuleNamespaceURI("http://myfaces.apache.org/maven-faces-plugin");
        digester.addObjectCreate("faces-config/faces-config-extension/event", EventBean.class);
        digester.addBeanPropertySetter("faces-config/faces-config-extension/event/description");
        digester.addBeanPropertySetter("faces-config/faces-config-extension/event/event-type", "eventType");
        digester.addBeanPropertySetter("faces-config/faces-config-extension/event/event-class", "eventClass");
        digester.addBeanPropertySetter("faces-config/faces-config-extension/event/event-listener-class", "eventListenerClass");
        digester.addBeanPropertySetter("faces-config/faces-config-extension/event/event-source-interface", "eventSourceInterface");
        digester.addSetNext("faces-config/faces-config-extension/event", "addEvent", EventBean.class.getName());
    }

    protected Digester createDigester() throws ParserConfigurationException, SAXException {
        Digester digester = FacesConfigParser.createEmptyDigester();
        FacesConfigParser.addComponentDigesterRules(digester, true);
        FacesConfigParser.addConverterDigesterRules(digester);
        FacesConfigParser.addValidatorDigesterRules(digester);
        FacesConfigParser.addRenderKitDigesterRules(digester);
        FacesConfigParser.addEventDigesterRules(digester);
        return digester;
    }

    public static class ComponentIncludeFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) throws Exception {
            String href = attributes.getValue("href");
            if (href == null) {
                throw new IllegalStateException("Missing href attribute");
            }
            URL master = (URL)this.digester.getRoot();
            URL included = new URL(master, href);
            Digester includedDigester = FacesConfigParser.createEmptyDigester();
            FacesConfigParser.addComponentDigesterRules(includedDigester, false);
            includedDigester.push((Object)included);
            includedDigester.push(this.digester.peek());
            URLConnection conn = included.openConnection();
            InputStream is = conn.getInputStream();
            includedDigester.parse(is);
            is.close();
            return included;
        }
    }
}

