/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.parse;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacesConfigBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ObjectBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.RendererBean;

public class RenderKitBean
extends ObjectBean {
    private String _renderKitId = "";
    private Map _renderers = new TreeMap();

    public void setRenderKitId(String renderKitId) {
        this._renderKitId = renderKitId;
    }

    public String getRenderKitId() {
        return this._renderKitId;
    }

    public void addRenderer(RendererBean renderer) {
        String componentFamily = renderer.getComponentFamily();
        String rendererType = renderer.getRendererType();
        String compositeKey = componentFamily + "|" + rendererType;
        this._renderers.put(compositeKey, renderer);
        FacesConfigBean owner = this.getOwner();
        if (owner != null) {
            renderer.attach(owner);
        }
    }

    public RendererBean findRenderer(String componentFamily, String rendererType) {
        String compositeKey = componentFamily + "|" + rendererType;
        return (RendererBean)this._renderers.get(compositeKey);
    }

    public boolean hasRenderers() {
        return !this._renderers.isEmpty();
    }

    public Iterator renderers() {
        return this._renderers.values().iterator();
    }

    protected void attach(FacesConfigBean owner) {
        super.attach(owner);
        Iterator renderers = this.renderers();
        while (renderers.hasNext()) {
            RendererBean renderer = (RendererBean)renderers.next();
            renderer.attach(owner);
        }
    }

    void addAllRenderers(RenderKitBean renderKit) {
        Iterator i = renderKit._renderers.values().iterator();
        while (i.hasNext()) {
            this.addRenderer((RendererBean)i.next());
        }
    }
}

