/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.parse;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.AttributeBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacesConfigBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacetBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ObjectBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.CompoundIterator;

public class RendererBean
extends ObjectBean {
    private String _description;
    private String _componentFamily;
    private String _rendererType;
    private String _rendererClass;
    private String _rendererSuperclass;
    private String _componentType;
    private Map _attributes = new TreeMap();
    private Map _facets = new TreeMap();

    public void setComponentFamily(String componentFamily) {
        this._componentFamily = componentFamily;
    }

    public String getComponentFamily() {
        return this._componentFamily;
    }

    public void setRendererType(String rendererType) {
        this._rendererType = rendererType;
    }

    public String getRendererType() {
        return this._rendererType;
    }

    public void setRendererClass(String rendererClass) {
        this._rendererClass = rendererClass;
    }

    public String getRendererClass() {
        return this._rendererClass;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setComponentType(String componentType) {
        this._componentType = componentType;
    }

    public String getComponentType() {
        return this._componentType;
    }

    public void setRendererSuperclass(String rendererSuperclass) {
        this._rendererSuperclass = rendererSuperclass;
    }

    public String getRendererSuperclass() {
        return this._rendererSuperclass;
    }

    public String findComponentClass() {
        ComponentBean component = this.resolveComponentType();
        return component != null ? component.getComponentClass() : "org.apache.myfaces.trinidad.component.UIXComponent";
    }

    public String findComponentFamilyClass() {
        ComponentBean component = this.resolveComponentType();
        ComponentBean behavioral = component != null ? component.findBehavioralComponent() : null;
        return behavioral != null ? behavioral.getComponentClass() : "org.apache.myfaces.trinidad.component.UIXComponent";
    }

    public void addAttribute(AttributeBean attribute) {
        this._attributes.put(attribute.getAttributeName(), attribute);
    }

    public AttributeBean findAttribute(String attributeName) {
        ComponentBean component;
        AttributeBean attribute = (AttributeBean)this._attributes.get(attributeName);
        if (attribute == null && (component = this.resolveComponentType()) != null) {
            attribute = component.findProperty(attributeName);
        }
        return attribute;
    }

    public boolean hasAttributes() {
        ComponentBean component;
        boolean hasAttributes;
        boolean bl = hasAttributes = !this._attributes.isEmpty();
        if (!hasAttributes && (component = this.resolveComponentType()) != null) {
            hasAttributes |= component.hasProperties();
        }
        return hasAttributes;
    }

    public boolean hasAttributes(boolean flatten) {
        ComponentBean parent;
        ComponentBean component;
        boolean hasAttributes = this.hasAttributes();
        if (!hasAttributes && flatten && (component = this.resolveComponentType()) != null && (parent = component.resolveSupertype()) != null) {
            hasAttributes |= parent.hasProperties(true);
        }
        return hasAttributes;
    }

    public Iterator attributes() {
        CompoundIterator attributes = this._attributes.values().iterator();
        ComponentBean component = this.resolveComponentType();
        if (component != null) {
            attributes = new CompoundIterator(attributes, component.properties());
        }
        return attributes;
    }

    public Iterator attributes(boolean flatten) {
        ComponentBean parent;
        ComponentBean component;
        Iterator attributes = this.attributes();
        if (flatten && (component = this.resolveComponentType()) != null && (parent = component.resolveSupertype()) != null) {
            attributes = new CompoundIterator(attributes, parent.properties(true));
        }
        return attributes;
    }

    public void addFacet(FacetBean facet) {
        this._facets.put(facet.getFacetName(), facet);
    }

    public FacetBean findFacet(String facetName) {
        return (FacetBean)this._facets.get(facetName);
    }

    public boolean hasFacets() {
        boolean hasFacets = !this._facets.isEmpty();
        ComponentBean component = this.resolveComponentType();
        if (component != null) {
            hasFacets |= component.hasFacets();
        }
        return hasFacets;
    }

    public boolean hasFacets(boolean flatten) {
        ComponentBean parent;
        ComponentBean component;
        boolean hasFacets = this.hasFacets();
        if (!hasFacets && flatten && (component = this.resolveComponentType()) != null && (parent = component.resolveSupertype()) != null) {
            hasFacets |= parent.hasFacets(true);
        }
        return hasFacets;
    }

    public Iterator facets() {
        CompoundIterator facets = this._facets.values().iterator();
        ComponentBean component = this.resolveComponentType();
        if (component != null) {
            facets = new CompoundIterator(facets, component.facets());
        }
        return facets;
    }

    public Iterator facets(boolean flatten) {
        ComponentBean parent;
        ComponentBean component;
        Iterator facets = this.facets();
        if (flatten && (component = this.resolveComponentType()) != null && (parent = component.resolveSupertype()) != null) {
            facets = new CompoundIterator(facets, parent.facets(true));
        }
        return facets;
    }

    public ComponentBean resolveComponentType() {
        if (this._componentType == null) {
            return null;
        }
        FacesConfigBean owner = this.getOwner();
        return owner != null ? owner.findComponent(this._componentType) : null;
    }
}

