/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public class SourceTemplate {
    private File _file;
    private BufferedReader _reader;
    private Set _imports = new HashSet();
    private Map _fqcnMap = new HashMap();
    private Set _implements = new HashSet();
    private Map _substitutions = new HashMap();
    private Set _ignoreMethods = new HashSet();
    private static final String _IGNORE_PREFIX = "/**/";
    private static final String _IGNORE_PREFIX2 = "/**///";

    public SourceTemplate(File file) {
        this._file = file;
    }

    public void substitute(String in, String out) {
        this._substitutions.put(in, out);
    }

    public Set getImports() {
        return Collections.unmodifiableSet(this._imports);
    }

    public Set getImplements() {
        return Collections.unmodifiableSet(this._implements);
    }

    /*
     * Unable to fully structure code
     */
    public void readPreface() throws IOException {
        this._reader = new BufferedReader(new FileReader(this._file));
        block0: while (true) {
            if ((line = this._reader.readLine()) == null) {
                throw new EOFException("File " + this._file + " ended prematurely");
            }
            if (line.equals("{")) break;
            if (line.startsWith("import ")) {
                line = line.trim();
                imported = line.substring("import ".length(), line.length() - 1);
                this._imports.add(imported);
                this._fqcnMap.put(Util.getClassFromFullClass(imported), imported);
            }
            if ((index = line.indexOf(" implements ")) == -1) continue;
            clause = line.substring(index + " implements ".length());
            interfaces = clause.split(", ");
            i = 0;
            while (true) {
                if (i < interfaces.length) ** break;
                continue block0;
                className = interfaces[i];
                if (!Util.isFullClass(className) && (importedName = (String)this._fqcnMap.get(className)) != null) {
                    className = importedName;
                }
                this._implements.add(className);
                ++i;
            }
            break;
        }
    }

    public void writeContent(Writer out) throws IOException {
        while (true) {
            String line;
            if ((line = this._reader.readLine()) == null) {
                throw new EOFException("File " + this._file + " ended prematurely");
            }
            if (line.trim().startsWith(_IGNORE_PREFIX)) {
                String method;
                if (!line.trim().startsWith(_IGNORE_PREFIX2) || (method = line.trim().substring(_IGNORE_PREFIX2.length()).trim()).length() <= 0) continue;
                this._ignoreMethods.add(method);
                continue;
            }
            if (line.equals("}")) break;
            line = this._substitute(line);
            out.write(line);
            out.write("\n");
        }
    }

    public void close() throws IOException {
        this._reader.close();
    }

    private String _substitute(String in) {
        Iterator keys = this._substitutions.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = (String)this._substitutions.get(key);
            in = SourceTemplate._substitute(in, key, value);
        }
        return in;
    }

    private static String _substitute(String in, String from, String to) {
        int index = in.indexOf(from);
        if (index < 0) {
            return in;
        }
        StringBuffer buffer = new StringBuffer(in.length() + to.length() - from.length());
        buffer.append(in.substring(0, index));
        buffer.append(to);
        String suffix = in.substring(index + from.length());
        buffer.append(SourceTemplate._substitute(suffix, from, to));
        return buffer.toString();
    }

    public Collection getIgnoreMethods() {
        return this._ignoreMethods;
    }
}

