/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.util;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;

public class Util {
    private static final String[] _PRIMITIVE_TYPES = new String[]{"boolean", "byte", "char", "float", "double", "int", "short", "long"};
    private static final String[] _RESERVED_WORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    public static final Set RESERVED_WORDS = Util._createReservedWordsSet();
    public static final Set PRIMITIVE_TYPES = Util._createPrimitiveTypesSet();
    private static final Pattern _GENERIC_TYPE = Pattern.compile("([^<]+)<(.+)>");

    public static String convertClassToSourcePath(String className, String fileExtension) {
        return className.replace('.', File.separatorChar) + fileExtension;
    }

    public static boolean isFullClass(String className) {
        return className != null && className.indexOf(46) != -1;
    }

    public static String getGenericsFromProperty(PropertyBean property) {
        String gen = "";
        for (int i = 0; i < property.getAttributeClassParameters().length; ++i) {
            if (i > 0) {
                gen = gen + ",";
            }
            gen = gen + Util.getClassFromFullClass(property.getAttributeClassParameters()[i]);
        }
        return gen.length() > 0 ? "<" + gen + ">" : gen;
    }

    public static String getClassFromFullClass(String fullClass) {
        if (fullClass == null) {
            return null;
        }
        int lastSep = fullClass.lastIndexOf(46);
        return fullClass.substring(lastSep + 1);
    }

    public static String getPackageFromFullClass(String fullClass) {
        if (fullClass == null) {
            return null;
        }
        int lastSep = fullClass.lastIndexOf(46);
        if (lastSep == -1) {
            return "";
        }
        return fullClass.substring(0, lastSep);
    }

    public static String getConstantNameFromProperty(String propertyName) {
        return Util.getConstantNameFromProperty(propertyName, null);
    }

    public static String getConstantNameFromProperty(String propertyName, String constantSuffix) {
        StringBuffer constantName = new StringBuffer();
        for (int i = 0; i < propertyName.length(); ++i) {
            char ch = propertyName.charAt(i);
            if (i > 0 && Character.isUpperCase(ch) && Character.isLowerCase(propertyName.charAt(i - 1))) {
                constantName.append('_');
            }
            ch = Character.toUpperCase(ch);
            constantName.append(ch);
        }
        if (constantSuffix != null) {
            constantName.append(constantSuffix);
        }
        return constantName.toString();
    }

    public static String getPrefixedPropertyName(String prefix, String propertyName) {
        return prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static String getPropertyClass(PropertyBean property) {
        String propertyFullClass = property.getPropertyClass();
        String propertyClass = Util.getClassFromFullClass(propertyFullClass);
        String[] genericTypes = property.getPropertyClassParameters();
        if (genericTypes != null && genericTypes.length > 0) {
            StringBuffer buffer = new StringBuffer(60);
            buffer.append(propertyClass);
            buffer.append('<');
            int max = genericTypes.length - 1;
            for (int i = 0; i <= max; ++i) {
                Util._buildPropertyClass(buffer, genericTypes[i]);
                if (i >= max) continue;
                buffer.append(", ");
            }
            buffer.append('>');
            propertyClass = buffer.toString();
        }
        return propertyClass;
    }

    public static String getMethodNameFromEvent(String methodPrefix, String eventName, String methodSuffix) {
        return methodPrefix + Character.toUpperCase(eventName.charAt(0)) + eventName.substring(1) + methodSuffix;
    }

    public static String getMethodReaderFromProperty(String propertyName, String propertyClass) {
        String methodPrefix = "boolean".equals(propertyClass) ? "is" : "get";
        return Util.getPrefixedPropertyName(methodPrefix, propertyName);
    }

    public static String getEventNameFromEventType(String eventFullClass) {
        String eventName = Util.getClassFromFullClass(eventFullClass);
        return Character.toLowerCase(eventName.charAt(0)) + eventName.substring(1, eventName.length());
    }

    public static boolean isPrimitiveClass(String className) {
        return "boolean".equals(className) || "byte".equals(className) || "char".equals(className) || "double".equals(className) || "float".equals(className) || "int".equals(className) || "long".equals(className) || "short".equals(className);
    }

    public static String getAlternatePropertyClass(PropertyBean property) {
        StringBuffer buffer = new StringBuffer(60);
        Util._buildPropertyClass(buffer, property.getAlternateClass());
        return buffer.toString();
    }

    public static String getBoxedClass(String className) {
        if ("boolean".equals(className)) {
            return "Boolean";
        }
        if ("byte".equals(className)) {
            return "Byte";
        }
        if ("char".equals(className)) {
            return "Character";
        }
        if ("double".equals(className)) {
            return "Double";
        }
        if ("float".equals(className)) {
            return "Float";
        }
        if ("int".equals(className)) {
            return "Integer";
        }
        if ("long".equals(className)) {
            return "Long";
        }
        if ("short".equals(className)) {
            return "Short";
        }
        return className;
    }

    public static String primitiveDefaultValue(String className) {
        if ("boolean".equals(className)) {
            return "false";
        }
        if ("byte".equals(className)) {
            return "0";
        }
        if ("char".equals(className)) {
            return "''";
        }
        if ("double".equals(className)) {
            return "0.0d";
        }
        if ("float".equals(className)) {
            return "0.0f";
        }
        if ("int".equals(className)) {
            return "0";
        }
        if ("long".equals(className)) {
            return "0L";
        }
        if ("short".equals(className)) {
            return "0";
        }
        return className;
    }

    public static String fill(String base, int length) {
        if (base == null || base.length() > length) {
            return base;
        }
        StringBuffer filled = new StringBuffer(base);
        for (int i = base.length(); i < length; ++i) {
            filled.append(' ');
        }
        return filled.toString();
    }

    public static String getVariableFromClass(String className) {
        if (className == null) {
            return null;
        }
        for (int i = 0; i < className.length(); ++i) {
            char ch = className.charAt(i);
            if (!Character.isLowerCase(ch)) continue;
            if (i <= 0) break;
            return Character.toLowerCase(className.charAt(i - 1)) + className.substring(i);
        }
        throw new IllegalStateException("Class name \"" + className + "\" does not use initcaps");
    }

    public static String getVariableFromName(String name) {
        if (name == null) {
            return null;
        }
        if (RESERVED_WORDS.contains(name)) {
            name = name + "Param";
        }
        return name;
    }

    public static String convertStringToLiteral(String value) {
        return Util.convertStringToLiteral("String", value);
    }

    public static String convertStringToLiteral(String className, String value) {
        if (value == null) {
            return null;
        }
        if ("String".equals(className)) {
            return "\"" + value.replaceAll("'", "\\'") + "\"";
        }
        if ("Number".equals(className)) {
            if (value.indexOf(".") == -1) {
                return "Integer.valueOf(" + value + ")";
            }
            return "Double.valueOf(" + value + ")";
        }
        return value;
    }

    public static String getDefaultValue(PropertyBean property) {
        String propertyFullClass = property.getPropertyClass();
        String def = property.getDefaultValue();
        if (def == null || def.length() == 0) {
            return null;
        }
        if (Util.isPrimitiveClass(propertyFullClass)) {
            return def;
        }
        if ("java.lang.String".equals(propertyFullClass)) {
            if (def.startsWith("\"") && def.endsWith("\"")) {
                return def;
            }
            return "\"" + def + "\"";
        }
        return null;
    }

    private static void _buildPropertyClass(StringBuffer buffer, String type) {
        Matcher matcher = _GENERIC_TYPE.matcher(type);
        if (matcher.matches()) {
            buffer.append(Util.getClassFromFullClass(matcher.group(1)));
            buffer.append('<');
            String[] types = matcher.group(2).split(",");
            int max = types.length - 1;
            for (int i = 0; i <= max; ++i) {
                Util._buildPropertyClass(buffer, types[i]);
                if (i >= max) continue;
                buffer.append(", ");
            }
            buffer.append('>');
        } else {
            buffer.append(Util.getClassFromFullClass(type));
        }
    }

    private static Set _createPrimitiveTypesSet() {
        TreeSet<String> primitives = new TreeSet<String>();
        for (int i = 0; i < _PRIMITIVE_TYPES.length; ++i) {
            String type = _PRIMITIVE_TYPES[i];
            primitives.add(type);
            primitives.add(type + "[]");
        }
        return Collections.unmodifiableSet(primitives);
    }

    private static Set _createReservedWordsSet() {
        TreeSet<String> reserved = new TreeSet<String>();
        for (int i = 0; i < _RESERVED_WORDS.length; ++i) {
            String keyword = _RESERVED_WORDS[i];
            reserved.add(keyword);
        }
        return Collections.unmodifiableSet(reserved);
    }

    private Util() {
    }
}

