/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.XPointerFilter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public final class XIncludeFilter
extends XMLFilterImpl {
    public static final String XINCLUDE_NAMESPACE = "http://www.w3.org/2001/XInclude";
    private int depth = 0;
    private Stack bases = new Stack();
    private Stack locators = new Stack();
    private NamespaceSupport namespaces = new NamespaceSupport();

    public XIncludeFilter(XMLReader parent, URL base) {
        super(parent);
        this.bases.push(base);
    }

    public void setDocumentLocator(Locator locator) {
        this.locators.push(locator);
        super.setDocumentLocator(locator);
    }

    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        if (!namespaceURI.equals(XINCLUDE_NAMESPACE)) {
            this.namespaces.declarePrefix(prefix, namespaceURI);
            super.startPrefixMapping(prefix, namespaceURI);
        }
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        this.namespaces.pushContext();
        if (namespaceURI.equals(XINCLUDE_NAMESPACE) && localName.equals("include")) {
            String href = attributes.getValue("href");
            if (href == null) {
                throw new SAXException("Missing href attribute");
            }
            String xpointer = attributes.getValue("xpointer");
            this.doXInclude(href, xpointer);
        } else {
            super.startElement(namespaceURI, localName, qualifiedName, attributes);
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (!namespaceURI.equals(XINCLUDE_NAMESPACE)) {
            super.endElement(namespaceURI, localName, qualifiedName);
        }
        this.namespaces.popContext();
    }

    public void startDocument() throws SAXException {
        if (this.depth == 0) {
            super.startDocument();
        }
        ++this.depth;
    }

    public void endDocument() throws SAXException {
        this.locators.pop();
        --this.depth;
        if (this.depth == 0) {
            super.endDocument();
        }
    }

    private void doXInclude(String href, String xpointer) throws SAXException {
        URL target = this.resolveURL(href);
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            if (xpointer != null) {
                reader = new XPointerFilter(reader, this.namespaces, xpointer);
            }
            reader.setContentHandler(this);
            reader.setEntityResolver(this);
            reader.setErrorHandler(this);
            reader.setDTDHandler(this);
            this.bases.push(target);
            reader.parse(new InputSource(target.openStream()));
            this.bases.pop();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("Error during xinclude of " + target.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new SAXException("Error during xinclude of " + target.toExternalForm(), e);
        }
    }

    private URL resolveURL(String href) throws SAXException {
        URL base = (URL)this.bases.peek();
        try {
            return new URL(base, href);
        }
        catch (MalformedURLException e) {
            throw new SAXException("Error resolving href \"" + href + "\" " + "at base \"" + base + "\"", e);
        }
    }
}

