/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.util;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public final class XPointerFilter
extends XMLFilterImpl {
    private int _depth;
    private boolean[] _acceptChildNodes;
    private String[] _rootNamespaceURI;
    private String[] _rootLocalName;

    public XPointerFilter(XMLReader parent, NamespaceSupport namespaces, String xpointer) {
        super(parent);
        if (!xpointer.startsWith("/") || !xpointer.endsWith("/*")) {
            throw new IllegalArgumentException("Unsupported xpointer syntax: " + xpointer);
        }
        xpointer = xpointer.substring(0, xpointer.length() - 2).substring(1);
        String[] elements = xpointer.split("/");
        int count = elements.length;
        this._rootNamespaceURI = new String[count];
        this._rootLocalName = new String[count];
        this._acceptChildNodes = new boolean[count];
        for (int i = 0; i < count; ++i) {
            String[] parts = elements[i].split(":");
            String prefix = parts.length == 1 ? "" : parts[0];
            String namespaceURI = namespaces.getURI(prefix);
            this._rootNamespaceURI[i] = namespaceURI != null ? namespaceURI : "";
            this._rootLocalName[i] = parts.length == 1 ? parts[0] : parts[1];
            this._acceptChildNodes[i] = false;
        }
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this._depth < this._acceptChildNodes.length) {
            this._acceptChildNodes[this._depth] = this._rootNamespaceURI[this._depth].equals(namespaceURI) && this._rootLocalName[this._depth].equals(localName);
        } else if (this._acceptingChildNodes()) {
            super.startElement(namespaceURI, localName, qualifiedName, attributes);
        }
        ++this._depth;
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        --this._depth;
        if (this._depth >= this._acceptChildNodes.length && this._acceptingChildNodes()) {
            super.endElement(namespaceURI, localName, qualifiedName);
        }
    }

    private boolean _acceptingChildNodes() {
        for (int i = this._acceptChildNodes.length - 1; i >= 0; --i) {
            if (this._acceptChildNodes[i]) continue;
            return false;
        }
        return true;
    }
}

