/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.i18n;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.trinidadbuild.plugin.i18n.uixtools.JSLocaleElementsGenerator;

public class GenerateJavascriptLocalesMojo
extends AbstractMojo {
    private MavenProject project;
    private File targetDirectory;
    private String targetPath = "";
    private String locale;
    private boolean force;

    public void execute() throws MojoExecutionException {
        try {
            this.addResourceRoot(this.targetDirectory.getCanonicalPath());
            File outputDirectory = new File(this.targetDirectory, this.targetPath);
            boolean uptodate = false;
            if (this.force || !uptodate) {
                this.getLog().info((CharSequence)"Generating Javascript Locales");
                ArrayList<String> argsList = new ArrayList<String>();
                argsList.add("outDir=" + outputDirectory.getCanonicalPath());
                argsList.add("writeJavascript=true");
                argsList.add("writeSource=false");
                argsList.add("verbose=false");
                argsList.add("prettyPrint=true");
                String[] args = argsList.toArray(new String[0]);
                JSLocaleElementsGenerator.main(args);
            } else {
                this.getLog().info((CharSequence)"Nothing to generate - Javascript Locales are up to date");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected void addResourceRoot(String resourceRoot) {
        List resources = this.project.getBuild().getResources();
        Resource resource = new Resource();
        resource.setDirectory(resourceRoot);
        resources.add(resource);
    }

    private String[] getLocaleStrings() {
        if ("en_US".equals(this.locale)) {
            return new String[]{""};
        }
        Locale[] locales = Locale.getAvailableLocales();
        String[] localeStrings = new String[locales.length];
        for (int i = 0; i < localeStrings.length; ++i) {
            localeStrings[i] = locales[i].getDisplayName();
        }
        return localeStrings;
    }
}

