/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.i18n;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.trinidadbuild.plugin.i18n.uixtools.JSLocaleElementsGenerator;

public class GenerateLocaleElementsMojo
extends AbstractMojo {
    private MavenProject project;
    private File targetDirectory;
    private String locale;
    private boolean force;

    public void execute() throws MojoExecutionException {
        try {
            this.project.addCompileSourceRoot(this.targetDirectory.getCanonicalPath());
            boolean uptodate = true;
            if (!this.force) {
                String[] localeStrings = this.getLocaleStrings();
                String bundlePath = JSLocaleElementsGenerator._DEFAULT_BUNDLE_LOCATION_PATH;
                for (int i = 0; i < localeStrings.length; ++i) {
                    String path = bundlePath + "LocaleElements" + localeStrings[i] + ".java";
                    File targetFile = new File(this.targetDirectory, path);
                    if (targetFile.exists()) continue;
                    uptodate = false;
                    break;
                }
            }
            if (this.force || !uptodate) {
                this.getLog().info((CharSequence)"Generating LocaleElements");
                ArrayList<String> argsList = new ArrayList<String>();
                argsList.add("sourceDir=" + this.targetDirectory.getCanonicalPath());
                argsList.add("bundleOutDir=" + this.targetDirectory.getCanonicalPath());
                argsList.add("writeJavascript=false");
                argsList.add("writeSource=true");
                argsList.add("generateBundleBaseOnly=" + "en_US".equals(this.locale));
                argsList.add("verbose=false");
                argsList.add("prettyPrint=true");
                String[] args = argsList.toArray(new String[0]);
                JSLocaleElementsGenerator.main(args);
            } else {
                this.getLog().info((CharSequence)"Nothing to generate - LocaleElements are up to date");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private String[] getLocaleStrings() {
        if ("en_US".equals(this.locale)) {
            return new String[]{""};
        }
        Locale[] locales = Locale.getAvailableLocales();
        String[] localeStrings = new String[locales.length];
        for (int i = 0; i < localeStrings.length; ++i) {
            localeStrings[i] = locales[i].getDisplayName();
        }
        return localeStrings;
    }
}

