/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.i18n.uixtools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.myfaces.trinidadbuild.plugin.i18n.uixtools.LocaleDataResolver;
import org.apache.myfaces.trinidadbuild.plugin.i18n.uixtools.VersionUtils;

public class JSLocaleElementsGenerator {
    private static final String[] LOCALE_ELEMENTS_GET_KEYS = new String[]{"MonthNames", "MonthAbbreviations", "DayNames", "DayAbbreviations", "AmPmMarkers", "Eras", "DateTimePatterns", "DateTimeElements", "NumberElements", "CurrencyElements", "PercentElements"};
    private static final String[] LOCALE_ELEMENTS_MAPPINGS = new String[]{"MonthNames", "getMonths", "MonthAbbreviations", "getShortMonths", "DayNames", "getWeekdays", "DayAbbreviations", "getShortWeekdays", "AmPmMarkers", "getAmPmStrings", "Eras", "getEras", "DateTimePatterns", null, "DateTimeElements", null, "NumberElements", null};
    private static final String[] DATE_FORMAT_ZONE_GET_KEYS = new String[0];
    private static String _RESOURCES_PACKAGE = "sun.text.resources";
    private static final String _DATE_FORMAT_ZONE_PATH = _RESOURCES_PACKAGE + ".DateFormatZoneData";
    private static final String _LOCALE_ELEMENTS_PATH = _RESOURCES_PACKAGE + ".LocaleElements";
    private static final String _DEFAULT_LOCATION_PATH = "org\\apache\\myfaces\\trinidadinternal\\ui\\jsLibs\\resources\\".replace('\\', File.separatorChar);
    private static final String _TRINIDAD_LOCALE_ELEMENTS_PACKAGE = "org.apache.myfaces.trinidad.resource";
    public static final String _DEFAULT_BUNDLE_LOCATION_PATH = "org.apache.myfaces.trinidad.resource".replace('.', File.separatorChar) + File.separatorChar;
    private static final String _TRINIDAD_LOCALE_ELEMENTS_PATH = "org.apache.myfaces.trinidad.resource.LocaleElements";
    private static final int _DEFAULT_BUFFER_SIZE = 16384;
    private static final String _LOCALE_LIST_PATH = "org\\apache\\myfaces\\trinidadinternal\\ui\\laf\\base\\xhtml\\LocaleList.java".replace('\\', File.separatorChar);
    private static final String[] _EMPTY_VALUES = new String[]{""};
    private static final String _LOCALE_LIST_CODE_START = "/*\n**\n**34567890123456789012345678901234567890123456789012345678901234567890123456789\n*/\npackage org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml;\n\nimport java.util.Locale;\n\nimport java.util.HashMap;\n\n/*\n * List of supported locales.  Automatically generated - do not modify!\n */\npublic class LocaleList\n{\n  /*\n   * Returns the list of supported locales.\n   */\n  static public HashMap<Locale, Locale> getSupportedLocales()\n  {\n    return _sLocaleMapper;\n  }\n  \n  private LocaleList()\n  {\n  }\n\n  static private final Locale[] _sLocales = new Locale[]\n  {\n";
    private static final String _LOCALE_LIST_CODE_END = "  };\n\n  static private HashMap<Locale, Locale> _sLocaleMapper;\n\n  static\n  {\n    _sLocaleMapper = new HashMap<Locale, Locale>();\n    for(Locale locale : _sLocales)\n    {\n      _sLocaleMapper.put(locale, locale);\n    }\n  }\n}\n";
    private static final String _LOCALE_JAVA_CODE_START = "// Do not edit this file!\n// This file has been automatically generated.\n// Edit JSLocaleElementsGenerator instead.\n//\npackage org.apache.myfaces.trinidad.resource;\n\nimport java.util.ListResourceBundle;\n";
    private static final String _JAVASCRIPT_EXTENSION = ".js";
    private static final String _JAVA_EXTENSION = ".java";

    public static void main(String[] args) {
        String bundleOutDir;
        String sourceDir;
        if (args.length == 1 && "?".equals(args[0])) {
            System.out.println("Generates JavaScript Locale information files");
            System.out.println("for the Locales available in the JVM.");
            System.out.println("These files are used by the Cabo HTML client");
            System.out.println("logic to handle date formatting and validation.");
            System.out.println();
            System.out.println("Parameters:");
            System.out.println("\tprettyPrint=false\tTurns off pretty printed output");
            System.out.println("\toutDir=[path]\t\tDirectory path to write JavaScript files to");
            System.out.println("\tsourceDir=[path]\t\tRoot directory path to write Java source to");
            System.out.println("\tbundleOutDir=[path]\t\tRoot directory path to write Java ResourceBundles to (defaults to sourceDir).");
            System.out.println("\tvariant=[variant name]\t\tIf supplied utility will generate ResourceBundles for this variant, and nothing else.");
            System.out.println("\tverbose=true\t\tTurns on verbose output");
            System.out.println("\tgenerateBundleBaseOnly=true\t\tGenerates the base LocaleElement.java file only");
            System.exit(0);
        }
        boolean prettyPrint = JSLocaleElementsGenerator.getArgBooleanValue(args, "prettyPrint", true);
        boolean verbose = JSLocaleElementsGenerator.getArgBooleanValue(args, "verbose", false);
        boolean writeSource = JSLocaleElementsGenerator.getArgBooleanValue(args, "writeSource", true);
        boolean writeJavascript = JSLocaleElementsGenerator.getArgBooleanValue(args, "writeJavascript", true);
        boolean generateBundleBaseOnly = JSLocaleElementsGenerator.getArgBooleanValue(args, "generateBundleBaseOnly", false);
        String outDir = JSLocaleElementsGenerator.getArgStringValue(args, "outDir", null);
        if (outDir == null) {
            outDir = System.getProperty("user.dir") + File.separator + _DEFAULT_LOCATION_PATH;
        }
        if (!outDir.endsWith(File.separator)) {
            outDir = outDir + File.separator;
        }
        String variant = JSLocaleElementsGenerator.getArgStringValue(args, "variant", null);
        boolean writeAll = true;
        if (variant != null) {
            writeAll = false;
            variant = variant.toUpperCase();
        }
        if ((sourceDir = JSLocaleElementsGenerator.getArgStringValue(args, "sourceDir", null)) == null) {
            sourceDir = System.getProperty("user.dir");
        }
        if ((bundleOutDir = JSLocaleElementsGenerator.getArgStringValue(args, "bundleOutDir", null)) == null) {
            bundleOutDir = sourceDir;
        }
        String fullBundleOutDir = bundleOutDir + (bundleOutDir.endsWith(File.separator) ? "" : File.separator) + _DEFAULT_BUNDLE_LOCATION_PATH;
        String version = JSLocaleElementsGenerator.getArgStringValue(args, "version", null);
        version = VersionUtils.normalizeVersionSuffix(version);
        if (verbose) {
            System.out.println("Writing files to: " + outDir);
            if (writeAll) {
                System.out.println("Writing source to: " + sourceDir);
            }
            System.out.println("Writing bundles to: " + fullBundleOutDir);
        }
        try {
            File localeListFile = null;
            if (writeSource) {
                new File(fullBundleOutDir).mkdirs();
            }
            if (writeJavascript) {
                new File(outDir).mkdirs();
            }
            if (writeAll && writeSource && !generateBundleBaseOnly) {
                localeListFile = new File(sourceDir, _LOCALE_LIST_PATH);
                localeListFile.getParentFile().mkdirs();
                localeListFile.createNewFile();
            }
            Locale[] locales = null;
            locales = generateBundleBaseOnly ? new Locale[]{Locale.US} : Locale.getAvailableLocales();
            for (int i = 0; i < locales.length; ++i) {
                JSLocaleElementsGenerator._generateJSLocaleElements(outDir, fullBundleOutDir, locales[i], variant, prettyPrint, verbose, writeJavascript, writeSource, generateBundleBaseOnly, version);
            }
            if (writeAll && writeSource && !generateBundleBaseOnly) {
                FileWriter sourceWriter = new FileWriter(localeListFile);
                sourceWriter.write(_LOCALE_LIST_CODE_START);
                for (int i = 0; i < locales.length; ++i) {
                    sourceWriter.write("    new Locale(\"");
                    sourceWriter.write(locales[i].getLanguage());
                    sourceWriter.write("\",\"");
                    sourceWriter.write(locales[i].getCountry());
                    sourceWriter.write("\",\"");
                    sourceWriter.write(locales[i].getVariant());
                    sourceWriter.write("\"),\n");
                }
                sourceWriter.write(_LOCALE_LIST_CODE_END);
                ((Writer)sourceWriter).close();
            }
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        if (verbose) {
            System.out.println("Done writing files");
        }
    }

    private static String getArgStringValue(String[] args, String argName, String defaultValue) {
        int argLength = argName.length();
        for (int i = 0; i < args.length; ++i) {
            String currArg = args[i];
            if (!currArg.startsWith(argName) || currArg.equals(argName) || '=' != currArg.charAt(argLength)) continue;
            return currArg.substring(argLength + 1);
        }
        return defaultValue;
    }

    private static boolean getArgBooleanValue(String[] args, String argName, boolean defaultValue) {
        String argValue = JSLocaleElementsGenerator.getArgStringValue(args, argName, null);
        if (argValue != null) {
            if (argName.equals(argValue)) {
                return true;
            }
            return Boolean.valueOf(argValue);
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(argName)) continue;
            return true;
        }
        String notName = "-" + argName;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(notName)) continue;
            return false;
        }
        return defaultValue;
    }

    private static void _generateJSLocaleElements(String outDir, String bundleOutDir, Locale targetLocale, String variant, boolean prettyPrint, boolean verbose, boolean writeJavascript, boolean writeSource, boolean generateBundleBaseOnly, String version) throws IOException {
        if (variant == null && writeJavascript) {
            String fileName = JSLocaleElementsGenerator._getFileName(targetLocale, version, generateBundleBaseOnly) + _JAVASCRIPT_EXTENSION;
            if (verbose) {
                System.out.println("Writing " + fileName);
            }
            PrintWriter localeWriter = new PrintWriter(new BufferedWriter(new FileWriter(outDir + fileName), 16384));
            JSLocaleElementsGenerator._writeLocale(localeWriter, targetLocale, prettyPrint);
            localeWriter.close();
        }
    }

    private static void _writeJavaBundle(Writer output, Locale targetLocale, String fileName) throws IOException {
        output.write(_LOCALE_JAVA_CODE_START);
        output.write("public class " + fileName + " extends ListResourceBundle\n{\n" + "  public Object[][] getContents()\n  {\n" + "    return contents;\n  }\n\n");
        try {
            String currKey;
            int i;
            ResourceBundle elementsData = ResourceBundle.getBundle(_LOCALE_ELEMENTS_PATH, targetLocale);
            boolean doneOne = false;
            for (i = 0; i < LOCALE_ELEMENTS_GET_KEYS.length; ++i) {
                currKey = LOCALE_ELEMENTS_GET_KEYS[i];
                Object data = JSLocaleElementsGenerator._getElementData(currKey, elementsData, targetLocale);
                JSLocaleElementsGenerator._writeJavaBundleElement(output, currKey, data, doneOne);
                doneOne = true;
            }
            doneOne = false;
            output.write("  static final Object[][] contents = \n  {\n");
            for (i = 0; i < LOCALE_ELEMENTS_GET_KEYS.length; ++i) {
                currKey = LOCALE_ELEMENTS_GET_KEYS[i];
                output.write((doneOne ? ",\n" : "") + "    { \"" + currKey + "\", " + JSLocaleElementsGenerator._getKeyArrayName(currKey) + "}");
                doneOne = true;
            }
            output.write("\n  };");
        }
        catch (MissingResourceException e) {
            output.write("  // Bundle generation error:\n  // " + e);
            output.write("\n  static final Object[][] contents = null;");
            System.err.println(e);
        }
        output.write("\n}\n");
    }

    private static void _writeLocale(Writer output, Locale targetLocale, boolean prettyPrint) throws IOException {
        output.write("var LocaleSymbols_");
        output.write(targetLocale.toString());
        output.write(" = new LocaleSymbols({");
        if (prettyPrint) {
            output.write(10);
        }
        JSLocaleElementsGenerator._writeResourceContents(output, _LOCALE_ELEMENTS_PATH, new ArrayEnumeration(LOCALE_ELEMENTS_GET_KEYS), targetLocale, prettyPrint);
        output.write("});");
        if (prettyPrint) {
            output.write(10);
        }
    }

    private static void _writeResourceContents(Writer output, String baseName, Enumeration keys, Locale targetLocale, boolean prettyPrint) throws IOException {
        try {
            while (keys.hasMoreElements()) {
                String currKey = (String)keys.nextElement();
                Object data = null;
                data = "CurrencyElements".equals(currKey) ? JSLocaleElementsGenerator._getCurrencyData(targetLocale) : ("PercentElements".equals(currKey) ? JSLocaleElementsGenerator._getPercentData(targetLocale) : LocaleDataResolver.getElementData(currKey, targetLocale));
                boolean wroteElement = JSLocaleElementsGenerator._writeResourceElement(output, currKey, data, keys.hasMoreElements(), prettyPrint);
                if (!wroteElement || !prettyPrint) continue;
                output.write(10);
            }
        }
        catch (MissingResourceException e) {
            System.err.println(e);
        }
    }

    private static Object _getCurrencyData(Locale targetLocale) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance(targetLocale);
        DecimalFormatSymbols decimalFormatSymbols = df.getDecimalFormatSymbols();
        Object[] currencyData = new Object[]{decimalFormatSymbols.getCurrencySymbol(), decimalFormatSymbols.getCurrency().getCurrencyCode(), df.getPositivePrefix(), df.getPositiveSuffix(), df.getNegativePrefix(), df.getNegativeSuffix()};
        return currencyData;
    }

    private static Object _getPercentData(Locale targetLocale) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getPercentInstance(targetLocale);
        Object[] percentData = new Object[]{df.getPositiveSuffix(), df.getNegativeSuffix()};
        return percentData;
    }

    private static Object _getElementData(String currKey, ResourceBundle elementsData, Locale targetLocale) {
        return elementsData.getObject(currKey);
    }

    private static boolean _writeResourceElement(Writer output, String key, Object value, boolean notLast, boolean prettyPrint) throws IOException {
        if (key != null) {
            output.write(key);
            output.write(58);
        }
        Object[] values = null;
        int valueCount = 0;
        if (value instanceof Object[] && (valueCount = (values = (Object[])value).length) == 0) {
            value = "";
        }
        if (valueCount != 0) {
            output.write(91);
            for (int i = 0; i < valueCount; ++i) {
                JSLocaleElementsGenerator._writeResourceElement(output, null, values[i], i < valueCount - 1, prettyPrint);
            }
            output.write(93);
        } else {
            output.write(34);
            JSLocaleElementsGenerator._writeEscapedString(output, value.toString(), false);
            output.write(34);
        }
        if (notLast) {
            output.write(44);
            if (prettyPrint) {
                output.write(32);
            }
        }
        return true;
    }

    private static void _writeJavaBundleElement(Writer output, String key, Object value, boolean wasPrevious) throws IOException {
        output.write("  private static final String " + JSLocaleElementsGenerator._getKeyArrayName(key) + "[]");
        Object[] values = null;
        int valueCount = 0;
        boolean doneOne = false;
        if (value instanceof Object[] && (valueCount = (values = (Object[])value).length) <= 0) {
            values = _EMPTY_VALUES;
            valueCount = 1;
        }
        if (valueCount > 0) {
            output.write(" = \n  {\n");
            for (int i = 0; i < valueCount; ++i) {
                output.write((doneOne ? ", \n" : "") + "    \"");
                JSLocaleElementsGenerator._writeEscapedString(output, values[i].toString(), true);
                output.write("\"");
                doneOne = true;
            }
            output.write("\n  };\n\n");
        } else {
            output.write(" = null");
        }
    }

    private static void _writeEscapedString(Writer output, String value, boolean isJava) throws IOException {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char currChar = value.charAt(i);
            if (currChar > '\u00ff') {
                output.write("\\u");
                output.write(JSLocaleElementsGenerator._getHexString(currChar, 4));
                continue;
            }
            if (isJava) {
                if (currChar > '\u001f' && currChar < '\u0080') {
                    if (currChar == '\"') {
                        output.write("\\\"");
                        continue;
                    }
                    output.write(currChar);
                    continue;
                }
                output.write("\\u");
                output.write(JSLocaleElementsGenerator._getHexString(currChar, 4));
                continue;
            }
            if (currChar > '\u001f' && currChar < '\u0080' && currChar != '\"' && currChar != '\'') {
                output.write(currChar);
                continue;
            }
            output.write("\\x");
            output.write(JSLocaleElementsGenerator._getHexString(currChar, 2));
        }
    }

    private static String _getHexString(int number, int minDigits) {
        String hexString = Integer.toHexString(number);
        int hexLength = hexString.length();
        int zeroPadding = minDigits - hexLength;
        if (zeroPadding > 0) {
            String paddedString = "0";
            while (zeroPadding > 1) {
                paddedString = paddedString + "0";
                --zeroPadding;
            }
            hexString = paddedString + hexString;
        } else if (zeroPadding < 0) {
            throw new IllegalArgumentException();
        }
        return hexString;
    }

    private static String _getKeyArrayName(String key) {
        return "_array" + key;
    }

    private static String _getFileName(Locale locale, String version, boolean generateBundleBaseOnly) {
        if (generateBundleBaseOnly) {
            return "LocaleElements";
        }
        if (version == null) {
            return "LocaleElements_" + locale;
        }
        return "LocaleElements_" + locale + version;
    }

    private static String _getLocaleSuffix(Locale locale) {
        String localeString = locale.toString();
        return localeString.substring(localeString.indexOf(95));
    }

    private static class ArrayEnumeration
    implements Enumeration {
        private Object[] _objects;
        private int _currentIndex;
        private static final Object[] _EMPTY_ARRAY = new Object[0];

        public ArrayEnumeration(Object[] array) {
            this._objects = array == null ? _EMPTY_ARRAY : array;
        }

        public boolean hasMoreElements() {
            return this._currentIndex < this._objects.length;
        }

        public Object nextElement() {
            return this._objects[this._currentIndex++];
        }
    }
}

