/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.i18n.uixtools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class LocaleDataResolver {
    private static final String LOCAL_ELEMENTS_RESOURCE_BUNDLE_JAVA_5 = "sun.text.resources.LocaleElements";
    private static final String LOCAL_DATA_CLASS_JAVA_4 = "sun.text.resources.LocaleData";
    private static final String LOCAL_DATA_CLASS_JAVA_6 = "sun.util.resources.LocaleData";
    private static final String[] LOCAL_DATA_METHODS_JAVA_6 = new String[]{"getCalendarData", "getCollationData", "getCurrencyNames", "getDateFormatData", "getLocaleNames", "getNumberFormatData", "getTimeZoneNames"};
    private static final String DATE_TIME_ELEMENTS = "DateTimeElements";
    private static final String MINIMAL_DAYS_IN_FIRST_WEEK = "minimalDaysInFirstWeek";
    private static final String FIRST_DAY_OF_WEEK = "firstDayOfWeek";

    LocaleDataResolver() {
    }

    public static Object getElementData(String key, Locale locale) {
        try {
            Class.forName(LOCAL_DATA_CLASS_JAVA_4);
            return LocaleDataResolver._getElementDataJava5(key, locale);
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName(LOCAL_DATA_CLASS_JAVA_6);
                return LocaleDataResolver._getElementDataJava6(key, locale);
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalStateException("could not access the java resource bundles");
            }
        }
    }

    private static Object _getElementDataJava5(String key, Locale locale) {
        ResourceBundle elementsData = ResourceBundle.getBundle(LOCAL_ELEMENTS_RESOURCE_BUNDLE_JAVA_5, locale);
        return elementsData.getObject(key);
    }

    private static Object _getElementDataJava6(String key, Locale locale) {
        if (DATE_TIME_ELEMENTS.equals(key)) {
            return new Object[]{LocaleDataResolver._getElementDataJava6(FIRST_DAY_OF_WEEK, locale), LocaleDataResolver._getElementDataJava6(MINIMAL_DAYS_IN_FIRST_WEEK, locale)};
        }
        for (int i = 0; i < LOCAL_DATA_METHODS_JAVA_6.length; ++i) {
            ResourceBundle bundle = LocaleDataResolver._getLocaleDataResourceBundleJava6(LOCAL_DATA_METHODS_JAVA_6[i], locale);
            if (!LocaleDataResolver._containsKey(bundle, key)) continue;
            return bundle.getObject(key);
        }
        throw new MissingResourceException("no element found in the java resource bundles for the given key", null, key);
    }

    private static boolean _containsKey(ResourceBundle bundle, String key) {
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(key)) continue;
            return true;
        }
        return false;
    }

    private static ResourceBundle _getLocaleDataResourceBundleJava6(String name, Locale locale) {
        try {
            Class<?> localDataClass = Class.forName(LOCAL_DATA_CLASS_JAVA_6);
            Method method = localDataClass.getMethod(name, Locale.class);
            Object bundle = method.invoke(null, locale);
            return (ResourceBundle)bundle;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException();
        }
        catch (SecurityException e) {
            throw new IllegalStateException();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException();
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException();
        }
    }
}

