/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools;

import java.io.BufferedReader;
import java.io.IOException;
import org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools.Token;
import org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools.TokenBuffer;
import org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools.TokenReader;

public class Tokenizer
implements TokenReader {
    private int _status = 0;
    private int _prev = 0;
    private int _next = 0;
    private int _len = 0;
    private int _lineNumber = 0;
    private int _offset = 0;
    private final StringBuffer _buffer = new StringBuffer();
    private final StringBuffer _wordBuffer = new StringBuffer();
    private final StringBuffer _str = new StringBuffer();
    private final BufferedReader _in;
    private final TokenBuffer _out = new TokenBuffer();
    private static final String[] reservedWords = new String[]{"function", "var"};
    private final Token NEWLINE = new Token(10, 0);
    private final Token WHITESPACE = new Token(11, 0);
    private final Token PERIOD = new Token(12, 0);
    private final Token SEMICOLON = new Token(13, 0);
    private static final int ROOT_MODE = 0;
    private static final int READ_WORD_MODE = 10;
    private static final int DIVISION_MODE = 15;
    private static final int QUOTE1_MODE = 20;
    private static final int QUOTE2_MODE = 30;
    private static final int ESCAPED_CHAR_MODE = 40;
    private static final int POSSIBLE_COMMENT_MODE = 50;
    private static final int COMMENT1_MODE = 60;
    private static final int COMMENT2_MODE = 70;
    private static final int END_COMMENT_MODE = 80;
    private static final int REGULAR_EXP_MODE = 90;
    private static final int END_REGULAR_EXP_MODE = 95;

    public Tokenizer(BufferedReader in) {
        this._in = in;
        Runnable runner = new Runnable(){

            public void run() {
                Tokenizer.this._run();
            }
        };
        new Thread(runner).start();
    }

    public Token read() throws IOException, InterruptedException {
        return this._out.read();
    }

    private void _run() {
        try {
            this._run2();
        }
        catch (Exception e) {
            System.out.println("Exception parsing line:" + this._lineNumber);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _run2() throws InterruptedException {
        try {
            while (this._fillBuffer()) {
                this._processBuffer();
            }
            this._out.write(new Token(0, this._lineNumber));
        }
        catch (IOException e) {
            System.out.println("Exception parsing line:" + this._lineNumber);
            this._out.write(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            this._out.write(new IOException("Exception parsing line:" + this._lineNumber));
        }
        finally {
            this._out.close();
        }
    }

    private void _processBuffer() throws InterruptedException {
        this._offset = 0;
        while (this._offset < this._len) {
            char ch = this._buffer.charAt(this._offset++);
            switch (this._status) {
                case 0: 
                case 15: {
                    this._next = this._rootMode(ch, this._status);
                    break;
                }
                case 10: {
                    this._next = this._readWordMode(ch, this._status, this._str);
                    break;
                }
                case 20: 
                case 30: {
                    this._next = this._quoteMode(ch, this._status, this._prev, this._str);
                    break;
                }
                case 40: {
                    this._str.append('\\');
                    this._str.append(ch);
                    this._next = this._prev;
                    break;
                }
                case 50: {
                    if (ch == '/') {
                        this._next = 60;
                        break;
                    }
                    if (ch == '*') {
                        this._next = 70;
                        break;
                    }
                    --this._offset;
                    if (this._prev == 15) {
                        this._writeControl('/');
                        this._next = 0;
                        break;
                    }
                    this._next = 90;
                    break;
                }
                case 60: 
                case 70: 
                case 80: {
                    this._next = this._commentMode(ch, this._status, this._str);
                    break;
                }
                case 90: {
                    this._next = this._regularExpMode(ch, this._str);
                    break;
                }
                case 95: {
                    if (ch == 'g' || ch == 'i') {
                        this._out.write(new Token(65, this._lineNumber, ch));
                        this._next = 95;
                        break;
                    }
                    --this._offset;
                    this._next = 0;
                }
            }
            this._prev = this._status;
            this._status = this._next;
        }
    }

    private int _rootMode(char ch, int status) throws InterruptedException {
        switch (ch) {
            case '\'': {
                return 20;
            }
            case '\"': {
                return 30;
            }
            case '\t': 
            case ' ': {
                this._out.write(this.WHITESPACE);
                return status;
            }
            case '\n': {
                this._out.write(this.NEWLINE);
                return 0;
            }
            case '.': {
                this._out.write(this.PERIOD);
                return status;
            }
            case ';': {
                this._out.write(this.SEMICOLON);
                return 0;
            }
            case '(': 
            case '[': 
            case '{': {
                this._out.write(new Token(110, this._lineNumber, ch));
                return 0;
            }
            case ')': {
                this._out.write(new Token(120, this._lineNumber, ch));
                return 15;
            }
            case ']': 
            case '}': {
                this._out.write(new Token(120, this._lineNumber, ch));
                return 0;
            }
            case '/': {
                return 50;
            }
        }
        if (this._isAlphaNumeric(ch)) {
            --this._offset;
            return 10;
        }
        this._writeControl(ch);
        return 0;
    }

    private int _regularExpMode(char ch, StringBuffer regExp) throws InterruptedException {
        switch (ch) {
            case '\\': {
                return 40;
            }
            case '/': {
                this._out.write(new Token(60, this._lineNumber, regExp.toString()));
                regExp.setLength(0);
                return 95;
            }
        }
        regExp.append(ch);
        return 90;
    }

    private int _quoteMode(char ch, int status, int prev, StringBuffer quoteString) throws InterruptedException {
        if (ch == '\'' && status == 20 || ch == '\"' && status == 30) {
            this._out.write(new Token(20, this._lineNumber, ch, quoteString.toString()));
            quoteString.setLength(0);
            return 0;
        }
        if (ch == '\\') {
            return 40;
        }
        quoteString.append(ch);
        return status;
    }

    private int _commentMode(char ch, int status, StringBuffer commentString) throws InterruptedException {
        if (status == 80) {
            if (ch == '/') {
                this._writeComment(commentString);
                return 0;
            }
            commentString.append('*');
            --this._offset;
            return 70;
        }
        if (status == 70 && ch == '*') {
            return 80;
        }
        if (status == 60 && ch == '\n') {
            this._writeComment(commentString);
            this._out.write(this.NEWLINE);
            return 0;
        }
        commentString.append(ch);
        return status;
    }

    private int _readWordMode(char ch, int status, StringBuffer wordBuffer) throws InterruptedException {
        if (this._isAlphaNumeric(ch)) {
            wordBuffer.append(ch);
            return status;
        }
        this._writeAlphaNumeric(wordBuffer.toString());
        wordBuffer.setLength(0);
        --this._offset;
        return 15;
    }

    private void _writeComment(StringBuffer s) throws InterruptedException {
        this._out.write(new Token(50, this._lineNumber, s.toString()));
        s.setLength(0);
    }

    private void _writeControl(char ch) throws InterruptedException {
        this._out.write(new Token(100, this._lineNumber, ch));
    }

    private void _writeAlphaNumeric(String s) throws InterruptedException {
        if (Character.isDigit(s.charAt(0))) {
            this._out.write(new Token(40, this._lineNumber, s));
        } else if (this._isReservedKeyword(s)) {
            this._out.write(new Token(200, this._lineNumber, s));
        } else {
            this._out.write(new Token(30, this._lineNumber, s));
        }
    }

    private boolean _isReservedKeyword(String s) {
        for (int i = 0; i < reservedWords.length; ++i) {
            if (!s.equals(reservedWords[i])) continue;
            return true;
        }
        return false;
    }

    private boolean _isAlphaNumeric(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_';
    }

    private boolean _fillBuffer() throws IOException {
        this._buffer.setLength(0);
        String s = this._in.readLine();
        if (s == null) {
            this._len = 0;
            return false;
        }
        this._buffer.append(s).append('\n');
        this._len = this._buffer.length();
        ++this._lineNumber;
        return true;
    }

    private void _reset() {
        this._next = 0;
        this._prev = 0;
        this._status = 0;
        this._buffer.setLength(0);
        this._offset = 0;
        this._lineNumber = 0;
        this._len = 0;
        this._wordBuffer.setLength(0);
        this._str.setLength(0);
    }
}

