/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.jdeveloper;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TldContentHandler {
    private String _version = null;
    private String _name = null;
    private String _prefix = null;
    private String _jspVersion = null;
    private String _uri = null;
    private static final String _TLIB_VERSION = "tlib-version";
    private static final String _DISPLAY_NAME = "display-name";
    private static final String _SHORT_NAME = "short-name";
    private static final String _JSP_VERSION = "jsp-version";
    private static final String _URI = "uri";

    public void parseTld(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        PluginEntityResolver entityResolver = new PluginEntityResolver();
        docBuilder.setEntityResolver(entityResolver);
        Document document = docBuilder.parse(file);
        this._processTldNodes(document);
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public void setURI(String uri) {
        this._uri = uri;
    }

    public void setJspVersion(String jspVersion) {
        this._jspVersion = jspVersion;
    }

    public String getVersion() {
        return this._version == null ? "" : this._version;
    }

    public String getName() {
        return this._name == null ? "" : this._name;
    }

    public String getPrefix() {
        return this._prefix == null ? "" : this._prefix;
    }

    public String getURI() {
        return this._uri == null ? "" : this._uri;
    }

    public String getJspVersion() {
        return this._jspVersion == null ? "" : this._jspVersion;
    }

    private void _processTldNodes(Document document) {
        Node node = null;
        NodeList nodeList = document.getElementsByTagName(_TLIB_VERSION);
        if (nodeList != null && nodeList.getLength() != 0) {
            node = nodeList.item(0);
            this.setVersion(node.getFirstChild().getNodeValue());
        }
        if ((nodeList = document.getElementsByTagName(_JSP_VERSION)) != null && nodeList.getLength() != 0) {
            node = nodeList.item(0);
            this.setJspVersion(node.getFirstChild().getNodeValue());
        }
        if ((nodeList = document.getElementsByTagName(_SHORT_NAME)) != null && nodeList.getLength() != 0) {
            node = nodeList.item(0);
            this.setPrefix(node.getFirstChild().getNodeValue());
        }
        if ((nodeList = document.getElementsByTagName(_DISPLAY_NAME)) != null && nodeList.getLength() != 0) {
            node = nodeList.item(0);
            this.setName(node.getFirstChild().getNodeValue());
        } else {
            this.setName(this.getPrefix());
        }
        nodeList = document.getElementsByTagName(_URI);
        if (nodeList != null && nodeList.getLength() != 0) {
            node = nodeList.item(0);
            this.setURI(node.getFirstChild().getNodeValue());
        }
    }

    private class PluginEntityResolver
    implements EntityResolver {
        private PluginEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if ("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN".equals(publicId)) {
                String xmlStr = "<?xml version='1.0' encoding='UTF-8'?>";
                byte[] buf = xmlStr.getBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                return new InputSource(bais);
            }
            return null;
        }
    }
}

