/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.xrts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.myfaces.trinidadbuild.plugin.xrts.ListRTSWriter;
import org.apache.myfaces.trinidadbuild.plugin.xrts.RTSWriter;
import org.apache.myfaces.trinidadbuild.plugin.xrts.XRTSGenerator;
import org.codehaus.plexus.util.DirectoryScanner;
import org.xml.sax.InputSource;

public abstract class AbstractGenerateSourcesMojo
extends AbstractMojo {
    public void execute() throws MojoExecutionException {
        try {
            this.generateBundles();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected abstract String getTargetType();

    protected abstract String[] getDefaultLocales();

    protected abstract String[] getExcludes();

    protected abstract File getSourceDirectory();

    protected abstract File getTargetDirectory();

    protected abstract void addCompileSourceRoot() throws IOException;

    private void generateBundles() throws IOException, MojoExecutionException {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory.exists()) {
            this.addCompileSourceRoot();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(sourceDirectory);
            scanner.addDefaultExcludes();
            String[] excludes = this.getExcludes();
            scanner.setExcludes(excludes);
            scanner.setIncludes(new String[]{"**/*.xrts"});
            scanner.scan();
            String[] xrtsFiles = scanner.getIncludedFiles();
            if (xrtsFiles.length > 0) {
                RTSWriter writer = this.getRTSWriter();
                HashMap<String, Object> params = new HashMap<String, Object>();
                LinkedList<String> dirtyXRTS = new LinkedList<String>(Arrays.asList(xrtsFiles));
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                Iterator i = dirtyXRTS.iterator();
                while (i.hasNext()) {
                    String xrtsFile = (String)i.next();
                    File targetFile = this.getTargetFile(xrtsFile);
                    if (!targetFile.exists()) continue;
                    File sourceFile = this.getSourceFile(xrtsFile);
                    if (targetFile.lastModified() < sourceFile.lastModified()) continue;
                    i.remove();
                }
                if (dirtyXRTS.isEmpty()) {
                    this.getLog().info((CharSequence)"Nothing to generate - all XRTS bundles are up to date");
                } else {
                    this.getLog().info((CharSequence)("Generating " + dirtyXRTS.size() + " XRTS bundles to " + this.getTargetDirectory()));
                    for (String xrtsFile : dirtyXRTS) {
                        File sourceFile = this.getSourceFile(xrtsFile);
                        File targetFile = this.getTargetFile(xrtsFile);
                        String baseName = this.getBasename(xrtsFile);
                        params.put("outFile", targetFile);
                        params.put("outName", baseName);
                        params.put("srcName", baseName);
                        params.put("quietMode", Boolean.TRUE);
                        params.put("defaultLocales", this.getDefaultLocales());
                        InputSource source = new InputSource(new FileInputStream(sourceFile));
                        source.setSystemId(sourceFile.getParentFile().toURL().toString());
                        try {
                            if (targetFile.exists()) {
                                targetFile.delete();
                            }
                            SAXParser parser = factory.newSAXParser();
                            targetFile.getParentFile().mkdirs();
                            XRTSGenerator.generate(parser, source, writer, params);
                            targetFile.setReadOnly();
                        }
                        catch (Throwable t) {
                            throw new MojoExecutionException(t.getMessage());
                        }
                    }
                }
            }
        }
    }

    private RTSWriter getRTSWriter() throws IOException, MojoExecutionException {
        String targetType = this.getTargetType();
        if (!targetType.startsWith("class:")) {
            if ("list".equals(targetType)) {
                return new ListRTSWriter();
            }
            throw new MojoExecutionException("Unknown bundle type: " + targetType);
        }
        String implClassName = targetType.substring("class:".length());
        try {
            Class<?> implClass = Class.forName(implClassName);
            return (RTSWriter)implClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private File getSourceFile(String xrtsFilename) {
        return new File(this.getSourceDirectory(), xrtsFilename);
    }

    private String getBasename(String sourcePath) {
        int start = sourcePath.lastIndexOf(File.separatorChar) + 1;
        return sourcePath.substring(start, sourcePath.length() - ".xrts".length());
    }

    private File getTargetFile(String sourcePath) {
        String basename = sourcePath.substring(0, sourcePath.length() - ".xrts".length());
        String targetPath = basename + ".java";
        return new File(this.getTargetDirectory(), targetPath);
    }
}

