/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.xrts;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.myfaces.trinidadbuild.plugin.xrts.RTSWriter;
import org.apache.myfaces.trinidadbuild.plugin.xrts.UnicodeEscapes;

public class ListRTSWriter
implements RTSWriter {
    private PrintWriter _pw;

    public void startBundle(Map parms, Map meta) throws Throwable {
        File outFile = (File)parms.get("outFile");
        String outName = (String)parms.get("outName");
        String srcName = (String)parms.get("srcName");
        Boolean b = (Boolean)parms.get("quietMode");
        boolean quietMode = b;
        if (!quietMode) {
            System.out.println("  " + outFile);
        }
        this._pw = new PrintWriter(new BufferedWriter(new FileWriter(outFile)));
        this._pw.println("// Do not edit this file!");
        this._pw.println("// This file has been automatically generated.");
        String rtsFileType = "xrts";
        if (meta != null) {
            rtsFileType = (String)meta.get("fileType");
        }
        this._pw.println("// Edit " + srcName + "." + rtsFileType + " and run the " + rtsFileType.toUpperCase() + "MakeBundle tool instead.");
        this._pw.println("// ");
        String packageName = (String)parms.get("pkgName");
        boolean validPackage = false;
        if (packageName == null && meta != null && meta.get("package") != null) {
            packageName = (String)meta.get("package");
        }
        if (!(packageName == null || packageName.equals("") && packageName.trim().equals(""))) {
            this._pw.println("package " + packageName + ";");
            this._pw.println("");
            validPackage = true;
        }
        this._pw.println("import java.util.ListResourceBundle;");
        this.writeImports(parms, meta);
        this._pw.println("");
        this._pw.println("public class " + outName + " extends ListResourceBundle {");
        this._pw.println("  @Override");
        this._pw.println("  public Object[][] getContents() {");
        this._pw.println("    return new Object[][] {");
        if (outName.indexOf(95) < 0) {
            String[] locales = (String[])parms.get("defaultLocales");
            File targDir = outFile.getParentFile();
            if (locales != null && targDir != null) {
                for (int l = 0; l < locales.length; ++l) {
                    String cName = outName + '_' + locales[l];
                    File locF = new File(targDir, cName + ".java");
                    PrintWriter locWri = new PrintWriter(new BufferedWriter(new FileWriter(locF)));
                    locWri.println("// Do not edit this file!");
                    locWri.println("// This file has been automatically generated.");
                    if (validPackage) {
                        locWri.println("package " + packageName + ";");
                        locWri.println("");
                    }
                    locWri.println("public class " + cName + " extends " + outName);
                    locWri.println("{");
                    locWri.println("}");
                    locWri.close();
                }
            }
        }
    }

    protected void writeImports(Map parms, Map meta) throws Throwable {
    }

    public void writeString(Map parms, Map meta, String key, String value) throws Throwable {
        this._pw.println("    {\"" + UnicodeEscapes.convert(key) + "\", \"" + UnicodeEscapes.convert(value) + "\"},");
    }

    public void endBundle(Map parms, Map meta) throws Throwable {
        this._pw.println("    };");
        this._pw.println("  }");
        this._pw.println("}");
        this._pw.close();
    }

    protected PrintWriter getOut() {
        return this._pw;
    }
}

