/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.xrts;

public final class UnicodeEscapes {
    private static final String[] _hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private UnicodeEscapes() {
    }

    public static String convert(String s) {
        StringBuffer buffer = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                switch (c) {
                    case '\b': {
                        buffer.append("\\b");
                        break;
                    }
                    case '\t': {
                        buffer.append("\\t");
                        break;
                    }
                    case '\n': {
                        buffer.append("\\n");
                        break;
                    }
                    case '\f': {
                        buffer.append("\\f");
                        break;
                    }
                    case '\r': {
                        buffer.append("\\r");
                        break;
                    }
                    case '\"': {
                        buffer.append("\\\"");
                        break;
                    }
                    case '\'': {
                        buffer.append("\\'");
                        break;
                    }
                    case '\\': {
                        buffer.append("\\\\");
                        break;
                    }
                    default: {
                        buffer.append(c);
                        break;
                    }
                }
                continue;
            }
            buffer.append("\\u");
            buffer.append(_hex[c >> 12 & 0xF]);
            buffer.append(_hex[c >> 8 & 0xF]);
            buffer.append(_hex[c >> 4 & 0xF]);
            buffer.append(_hex[c & 0xF]);
        }
        return buffer.toString();
    }
}

