/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.xrts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.trinidadbuild.plugin.xrts.RTSWriter;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

final class XRTSParser
extends HandlerBase {
    private Locator _locator;
    private String _currentResourceKey;
    private StringBuilder _currentResourceValue;
    private Map<String, Object> _metaHt = new HashMap<String, Object>();
    private Set<String> _uniqKeys = new HashSet<String>();
    private RTSWriter _bundleWriter;
    private Map _parms;
    private int _nestingLevel = 0;
    private boolean _startDoc = false;

    public XRTSParser() {
    }

    public XRTSParser(RTSWriter bw, Map parms) {
        this._bundleWriter = bw;
        this._parms = parms;
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void startDocument() throws SAXException {
        this._metaHt.put("fileType", "xrts");
        this._startDoc = true;
    }

    public void endDocument() throws SAXException {
        try {
            this._bundleWriter.endBundle(this._parms, this._metaHt);
        }
        catch (Throwable th) {
            throw new SAXException("endBundle Exception: " + th.getMessage());
        }
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        ++this._nestingLevel;
        if (this._nestingLevel == 2 && name.equals("resource")) {
            if (this._startDoc) {
                try {
                    this._bundleWriter.startBundle(this._parms, this._metaHt);
                    this._startDoc = false;
                }
                catch (Throwable th) {
                    throw new SAXException("startBundle Exception: " + th.getMessage());
                }
            }
            this._currentResourceKey = atts.getValue("key");
            if (this._uniqKeys.contains(this._currentResourceKey)) {
                System.err.println("Duplicate id \"" + this._currentResourceKey + "\"");
            }
            this._uniqKeys.add(this._currentResourceKey);
            this._currentResourceValue = new StringBuilder();
        } else if (this._nestingLevel == 1 && name.equals("resources")) {
            this._metaHt.put("package", atts.getValue("package"));
            if (atts.getValue("version") != null) {
                this._metaHt.put("version", atts.getValue("version"));
            }
            if (atts.getValue("baseversion") != null) {
                this._metaHt.put("baseVersion", atts.getValue("baseversion"));
            }
        }
    }

    public void endElement(String name) throws SAXException {
        if (this._nestingLevel == 2 && name.equals("resource")) {
            String value = this._currentResourceValue.toString().trim();
            try {
                this._bundleWriter.writeString(this._parms, this._metaHt, this._currentResourceKey, value);
            }
            catch (Throwable t) {
                throw new SAXException(t.getMessage());
            }
        }
        --this._nestingLevel;
    }

    public void ignorableWhitespace(char[] cbuf, int start, int len) throws SAXException {
    }

    public void characters(char[] cbuf, int start, int len) throws SAXException {
        if (this._nestingLevel == 2) {
            this._currentResourceValue.append(cbuf, start, len);
        }
    }
}

