/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.amqp.processors;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import org.apache.nifi.amqp.processors.AMQPWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AMQPConsumer
extends AMQPWorker {
    private static final Logger logger = LoggerFactory.getLogger(AMQPConsumer.class);
    private final String queueName;
    private final BlockingQueue<GetResponse> responseQueue;
    private final boolean autoAcknowledge;
    private final Consumer consumer;
    private volatile boolean closed = false;

    AMQPConsumer(Connection connection, String queueName, final boolean autoAcknowledge) throws IOException {
        super(connection);
        this.validateStringProperty("queueName", queueName);
        this.queueName = queueName;
        this.autoAcknowledge = autoAcknowledge;
        this.responseQueue = new LinkedBlockingQueue<GetResponse>(10);
        logger.info("Successfully connected AMQPConsumer to " + connection.toString() + " and '" + queueName + "' queue");
        final Channel channel = this.getChannel();
        this.consumer = new DefaultConsumer(channel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                if (!autoAcknowledge && AMQPConsumer.this.closed) {
                    channel.basicReject(envelope.getDeliveryTag(), true);
                    return;
                }
                try {
                    AMQPConsumer.this.responseQueue.put(new GetResponse(envelope, properties, body, Integer.MAX_VALUE));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        channel.basicConsume(queueName, autoAcknowledge, this.consumer);
    }

    protected Consumer getConsumer() {
        return this.consumer;
    }

    public GetResponse consume() {
        return (GetResponse)this.responseQueue.poll();
    }

    public void acknowledge(GetResponse response) throws IOException {
        if (this.autoAcknowledge) {
            return;
        }
        this.getChannel().basicAck(response.getEnvelope().getDeliveryTag(), true);
    }

    @Override
    public void close() throws TimeoutException, IOException {
        GetResponse response;
        this.closed = true;
        GetResponse lastMessage = null;
        while ((response = (GetResponse)this.responseQueue.poll()) != null) {
            lastMessage = response;
        }
        if (lastMessage != null) {
            this.getChannel().basicNack(lastMessage.getEnvelope().getDeliveryTag(), true, true);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", QUEUE:" + this.queueName;
    }
}

