/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.amqp.processors;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ReturnListener;
import java.io.IOException;
import org.apache.nifi.amqp.processors.AMQPWorker;
import org.apache.nifi.logging.ComponentLog;

final class AMQPPublisher
extends AMQPWorker {
    private final ComponentLog processLog;
    private final String connectionString;

    AMQPPublisher(Connection connection, ComponentLog processLog) {
        super(connection);
        this.processLog = processLog;
        this.getChannel().addReturnListener((ReturnListener)new UndeliverableMessageLogger());
        this.connectionString = connection.toString();
    }

    void publish(byte[] bytes, AMQP.BasicProperties properties, String routingKey, String exchange) {
        this.validateStringProperty("routingKey", routingKey);
        String string = exchange = exchange == null ? "" : exchange.trim();
        if (exchange.length() == 0) {
            this.processLog.info("The 'exchangeName' is not specified. Messages will be sent to default exchange");
        }
        this.processLog.info("Successfully connected AMQPPublisher to " + this.connectionString + " and '" + exchange + "' exchange with '" + routingKey + "' as a routing key.");
        Channel channel = this.getChannel();
        if (channel.isOpen()) {
            try {
                channel.basicPublish(exchange, routingKey, true, properties, bytes);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to publish to Exchange '" + exchange + "' with Routing Key '" + routingKey + "'.", e);
            }
        } else {
            throw new IllegalStateException("This instance of AMQPPublisher is invalid since its publishingChannel is closed");
        }
    }

    @Override
    public String toString() {
        return this.connectionString;
    }

    private final class UndeliverableMessageLogger
    implements ReturnListener {
        private UndeliverableMessageLogger() {
        }

        public void handleReturn(int replyCode, String replyText, String exchangeName, String routingKey, AMQP.BasicProperties properties, byte[] message) throws IOException {
            String logMessage = "Message destined for '" + exchangeName + "' exchange with '" + routingKey + "' as routing key came back with replyCode=" + replyCode + " and replyText=" + replyText + ".";
            AMQPPublisher.this.processLog.warn(logMessage);
            AMQPPublisher.this.processLog.warn(logMessage);
        }
    }
}

