/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.amqp.processors;

import com.rabbitmq.client.Connection;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.nifi.amqp.processors.AMQPWorker;

public class AMQPResource<T extends AMQPWorker>
implements Closeable {
    private final Connection connection;
    private final T worker;

    public AMQPResource(Connection connection, T worker) {
        this.connection = connection;
        this.worker = worker;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public T getWorker() {
        return this.worker;
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        try {
            ((AMQPWorker)this.worker).close();
        }
        catch (IOException e) {
            ioe = e;
        }
        catch (TimeoutException e) {
            ioe = new IOException(e);
        }
        try {
            this.connection.close();
        }
        catch (IOException e) {
            if (ioe == null) {
                ioe = e;
            }
            ioe.addSuppressed(e);
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

