/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.amqp.processors;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AMQPWorker
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AMQPWorker.class);
    private final Channel channel;
    private boolean closed = false;

    public AMQPWorker(Connection connection) {
        this.validateConnection(connection);
        try {
            this.channel = connection.createChannel();
        }
        catch (IOException e) {
            logger.error("Failed to create Channel for " + connection, (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    protected Channel getChannel() {
        return this.channel;
    }

    @Override
    public void close() throws TimeoutException, IOException {
        if (this.closed) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Closing AMQP channel for " + this.channel.getConnection().toString());
        }
        this.channel.close();
        this.closed = true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.channel.getConnection().toString();
    }

    void validateStringProperty(String propertyName, String value) {
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException("'" + propertyName + "' must not be null or empty");
        }
    }

    private void validateConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("'connection' must not be null!");
        }
        if (!connection.isOpen()) {
            throw new IllegalStateException("'connection' must be open!");
        }
    }
}

