/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.amqp.processors;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.amqp.processors.AMQPConsumer;
import org.apache.nifi.amqp.processors.AbstractAMQPProcessor;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"amqp", "rabbit", "get", "message", "receive", "consume"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Consumes AMQP Messages from an AMQP Broker using the AMQP 0.9.1 protocol. Each message that is received from the AMQP Broker will be emitted as its own FlowFile to the 'success' relationship.")
@WritesAttributes(value={@WritesAttribute(attribute="amqp$appId", description="The App ID field from the AMQP Message"), @WritesAttribute(attribute="amqp$contentEncoding", description="The Content Encoding reported by the AMQP Message"), @WritesAttribute(attribute="amqp$contentType", description="The Content Type reported by the AMQP Message"), @WritesAttribute(attribute="amqp$headers", description="The headers present on the AMQP Message"), @WritesAttribute(attribute="amqp$deliveryMode", description="The numeric indicator for the Message's Delivery Mode"), @WritesAttribute(attribute="amqp$priority", description="The Message priority"), @WritesAttribute(attribute="amqp$correlationId", description="The Message's Correlation ID"), @WritesAttribute(attribute="amqp$replyTo", description="The value of the Message's Reply-To field"), @WritesAttribute(attribute="amqp$expiration", description="The Message Expiration"), @WritesAttribute(attribute="amqp$messageId", description="The unique ID of the Message"), @WritesAttribute(attribute="amqp$timestamp", description="The timestamp of the Message, as the number of milliseconds since epoch"), @WritesAttribute(attribute="amqp$type", description="The type of message"), @WritesAttribute(attribute="amqp$userId", description="The ID of the user"), @WritesAttribute(attribute="amqp$clusterId", description="The ID of the AMQP Cluster")})
public class ConsumeAMQP
extends AbstractAMQPProcessor<AMQPConsumer> {
    private static final String ATTRIBUTES_PREFIX = "amqp$";
    public static final PropertyDescriptor QUEUE = new PropertyDescriptor.Builder().name("Queue").description("The name of the existing AMQP Queue from which messages will be consumed. Usually pre-defined by AMQP administrator. ").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor AUTO_ACKNOWLEDGE = new PropertyDescriptor.Builder().name("auto.acknowledge").displayName("Auto-Acknowledge messages").description("If true, messages that are received will be auto-acknowledged by the AMQP Broker. This generally will provide better throughput but could result in messages being lost upon restart of NiFi").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("batch.size").displayName("Batch Size").description("The maximum number of messages that should be pulled in a single session. Once this many messages have been received (or once no more messages are readily available), the messages received will be transferred to the 'success' relationship and the messages will be acknowledged with the AMQP Broker. Setting this value to a larger number could result in better performance, particularly for very small messages, but can also result in more messages being duplicated upon sudden restart of NiFi.").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).defaultValue("10").required(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are received from the AMQP queue are routed to this relationship").build();
    private static final List<PropertyDescriptor> propertyDescriptors;
    private static final Set<Relationship> relationships;

    @Override
    protected void processResource(Connection connection, AMQPConsumer consumer, ProcessContext context, ProcessSession session) {
        GetResponse lastReceived = null;
        for (int i = 0; i < context.getProperty(BATCH_SIZE).asInteger(); ++i) {
            GetResponse response = consumer.consume();
            if (response == null) {
                if (lastReceived != null) break;
                context.yield();
                break;
            }
            FlowFile flowFile = session.create();
            flowFile = session.write(flowFile, out -> out.write(response.getBody()));
            AMQP.BasicProperties amqpProperties = response.getProps();
            Map<String, String> attributes = this.buildAttributes(amqpProperties);
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.getProvenanceReporter().receive(flowFile, connection.toString() + "/" + context.getProperty(QUEUE).getValue());
            session.transfer(flowFile, REL_SUCCESS);
            lastReceived = response;
        }
        session.commit();
        if (lastReceived != null) {
            try {
                consumer.acknowledge(lastReceived);
            }
            catch (IOException e) {
                throw new ProcessException("Failed to acknowledge message", (Throwable)e);
            }
        }
    }

    private Map<String, String> buildAttributes(AMQP.BasicProperties properties) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.addAttribute(attributes, "amqp$appId", properties.getAppId());
        this.addAttribute(attributes, "amqp$contentEncoding", properties.getContentEncoding());
        this.addAttribute(attributes, "amqp$contentType", properties.getContentType());
        this.addAttribute(attributes, "amqp$headers", properties.getHeaders());
        this.addAttribute(attributes, "amqp$deliveryMode", properties.getDeliveryMode());
        this.addAttribute(attributes, "amqp$priority", properties.getPriority());
        this.addAttribute(attributes, "amqp$correlationId", properties.getCorrelationId());
        this.addAttribute(attributes, "amqp$replyTo", properties.getReplyTo());
        this.addAttribute(attributes, "amqp$expiration", properties.getExpiration());
        this.addAttribute(attributes, "amqp$messageId", properties.getMessageId());
        this.addAttribute(attributes, "amqp$timestamp", properties.getTimestamp() == null ? null : Long.valueOf(properties.getTimestamp().getTime()));
        this.addAttribute(attributes, "amqp$type", properties.getType());
        this.addAttribute(attributes, "amqp$userId", properties.getUserId());
        this.addAttribute(attributes, "amqp$clusterId", properties.getClusterId());
        return attributes;
    }

    private void addAttribute(Map<String, String> attributes, String attributeName, Object value) {
        if (value == null) {
            return;
        }
        attributes.put(attributeName, value.toString());
    }

    @Override
    protected synchronized AMQPConsumer createAMQPWorker(ProcessContext context, Connection connection) {
        try {
            String queueName = context.getProperty(QUEUE).getValue();
            boolean autoAcknowledge = context.getProperty(AUTO_ACKNOWLEDGE).asBoolean();
            AMQPConsumer amqpConsumer = new AMQPConsumer(connection, queueName, autoAcknowledge);
            return amqpConsumer;
        }
        catch (IOException ioe) {
            throw new ProcessException("Failed to connect to AMQP Broker", (Throwable)ioe);
        }
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    static {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(QUEUE);
        properties.add(AUTO_ACKNOWLEDGE);
        properties.add(BATCH_SIZE);
        properties.addAll(ConsumeAMQP.getCommonPropertyDescriptors());
        propertyDescriptors = Collections.unmodifiableList(properties);
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_SUCCESS);
        relationships = Collections.unmodifiableSet(rels);
    }
}

