/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.NiFiFlowPath;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiFlow {
    private static final Logger logger = LoggerFactory.getLogger(NiFiFlow.class);
    private final String rootProcessGroupId;
    private String flowName;
    private String clusterName;
    private String url;
    private String atlasGuid;
    private AtlasEntity exEntity;
    private AtlasObjectId atlasObjectId;
    private String description;
    private AtomicBoolean metadataUpdated = new AtomicBoolean(false);
    private List<String> updateAudit = new ArrayList<String>();
    private Set<String> updatedEntityGuids = new LinkedHashSet<String>();
    private Set<String> stillExistingEntityGuids = new LinkedHashSet<String>();
    private Set<String> traversedPathIds = new LinkedHashSet<String>();
    private boolean urlUpdated = false;
    private final Map<String, NiFiFlowPath> flowPaths = new HashMap<String, NiFiFlowPath>();
    private final Map<String, ProcessorStatus> processors = new HashMap<String, ProcessorStatus>();
    private final Map<String, RemoteProcessGroupStatus> remoteProcessGroups = new HashMap<String, RemoteProcessGroupStatus>();
    private final Map<String, List<ConnectionStatus>> incomingConnections = new HashMap<String, List<ConnectionStatus>>();
    private final Map<String, List<ConnectionStatus>> outGoingConnections = new HashMap<String, List<ConnectionStatus>>();
    private final Map<AtlasObjectId, AtlasEntity> queues = new HashMap<AtlasObjectId, AtlasEntity>();
    private final Map<String, PortStatus> inputPorts = new HashMap<String, PortStatus>();
    private final Map<String, PortStatus> outputPorts = new HashMap<String, PortStatus>();
    private final Map<String, PortStatus> rootInputPorts = new HashMap<String, PortStatus>();
    private final Map<String, PortStatus> rootOutputPorts = new HashMap<String, PortStatus>();
    private final Map<AtlasObjectId, AtlasEntity> rootInputPortEntities = new HashMap<AtlasObjectId, AtlasEntity>();
    private final Map<AtlasObjectId, AtlasEntity> rootOutputPortEntities = new HashMap<AtlasObjectId, AtlasEntity>();

    public NiFiFlow(String rootProcessGroupId) {
        this.rootProcessGroupId = rootProcessGroupId;
    }

    public AtlasObjectId getAtlasObjectId() {
        return this.atlasObjectId;
    }

    public String getRootProcessGroupId() {
        return this.rootProcessGroupId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        AtlasUtils.updateMetadata(this.metadataUpdated, this.updateAudit, "clusterName", this.clusterName, clusterName);
        this.clusterName = clusterName;
        this.atlasObjectId = this.createAtlasObjectId();
    }

    private AtlasObjectId createAtlasObjectId() {
        return new AtlasObjectId(this.atlasGuid, "nifi_flow", Collections.singletonMap("qualifiedName", this.getQualifiedName()));
    }

    public AtlasEntity getExEntity() {
        return this.exEntity;
    }

    public void setExEntity(AtlasEntity exEntity) {
        this.exEntity = exEntity;
        this.setAtlasGuid(exEntity.getGuid());
    }

    public String getAtlasGuid() {
        return this.atlasGuid;
    }

    public void setAtlasGuid(String atlasGuid) {
        this.atlasGuid = atlasGuid;
        this.atlasObjectId = this.createAtlasObjectId();
    }

    public String getQualifiedName() {
        return this.toQualifiedName(this.rootProcessGroupId);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        AtlasUtils.updateMetadata(this.metadataUpdated, this.updateAudit, "description", this.description, description);
        this.description = description;
    }

    public void addConnection(ConnectionStatus c) {
        this.outGoingConnections.computeIfAbsent(c.getSourceId(), k -> new ArrayList()).add(c);
        this.incomingConnections.computeIfAbsent(c.getDestinationId(), k -> new ArrayList()).add(c);
    }

    public void addProcessor(ProcessorStatus p) {
        this.processors.put(p.getId(), p);
    }

    public Map<String, ProcessorStatus> getProcessors() {
        return this.processors;
    }

    public void addRemoteProcessGroup(RemoteProcessGroupStatus r) {
        this.remoteProcessGroups.put(r.getId(), r);
    }

    public void setFlowName(String flowName) {
        AtlasUtils.updateMetadata(this.metadataUpdated, this.updateAudit, "name", this.flowName, flowName);
        this.flowName = flowName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setUrl(String url) {
        AtlasUtils.updateMetadata(this.metadataUpdated, this.updateAudit, "url", this.url, url);
        if (AtlasUtils.isUpdated(this.url, url)) {
            this.urlUpdated = true;
        }
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public List<ConnectionStatus> getIncomingConnections(String componentId) {
        return this.incomingConnections.get(componentId);
    }

    public List<ConnectionStatus> getOutgoingConnections(String componentId) {
        return this.outGoingConnections.get(componentId);
    }

    public void addInputPort(PortStatus port) {
        this.inputPorts.put(port.getId(), port);
    }

    public Map<String, PortStatus> getInputPorts() {
        return this.inputPorts;
    }

    public void addOutputPort(PortStatus port) {
        this.outputPorts.put(port.getId(), port);
    }

    public Map<String, PortStatus> getOutputPorts() {
        return this.outputPorts;
    }

    public void addRootInputPort(PortStatus port) {
        this.rootInputPorts.put(port.getId(), port);
        this.createOrUpdateRootGroupPortEntity(true, this.toQualifiedName(port.getId()), port.getName());
    }

    public Map<String, PortStatus> getRootInputPorts() {
        return this.rootInputPorts;
    }

    public void addRootOutputPort(PortStatus port) {
        this.rootOutputPorts.put(port.getId(), port);
        this.createOrUpdateRootGroupPortEntity(false, this.toQualifiedName(port.getId()), port.getName());
    }

    public Map<String, PortStatus> getRootOutputPorts() {
        return this.rootOutputPorts;
    }

    public Map<AtlasObjectId, AtlasEntity> getRootInputPortEntities() {
        return this.rootInputPortEntities;
    }

    private AtlasEntity createOrUpdateRootGroupPortEntity(boolean isInput, String qualifiedName, String portName) {
        String typeName;
        Map<AtlasObjectId, AtlasEntity> ports = isInput ? this.rootInputPortEntities : this.rootOutputPortEntities;
        Optional<AtlasObjectId> existingPortId = AtlasUtils.findIdByQualifiedName(ports.keySet(), qualifiedName);
        String string = typeName = isInput ? "nifi_input_port" : "nifi_output_port";
        if (existingPortId.isPresent()) {
            AtlasEntity entity = ports.get(existingPortId.get());
            String portGuid = entity.getGuid();
            this.stillExistingEntityGuids.add(portGuid);
            Object currentName = entity.getAttribute("name");
            if (AtlasUtils.isUpdated(currentName, portName)) {
                entity.setAttribute("name", (Object)portName);
                this.updatedEntityGuids.add(portGuid);
                this.updateAudit.add(String.format("Name of %s %s changed from %s to %s", entity.getTypeName(), portGuid, currentName, portName));
            }
            return entity;
        }
        AtlasEntity entity = new AtlasEntity(typeName);
        entity.setAttribute("nifiFlow", (Object)this.getAtlasObjectId());
        entity.setAttribute("name", (Object)portName);
        entity.setAttribute("qualifiedName", (Object)qualifiedName);
        AtlasObjectId portId = new AtlasObjectId(typeName, "qualifiedName", (Object)qualifiedName);
        ports.put(portId, entity);
        return entity;
    }

    public Map<AtlasObjectId, AtlasEntity> getRootOutputPortEntities() {
        return this.rootOutputPortEntities;
    }

    public Tuple<AtlasObjectId, AtlasEntity> getOrCreateQueue(String destinationComponentId) {
        String qualifiedName = this.toQualifiedName(destinationComponentId);
        Optional<AtlasObjectId> existingQueueId = AtlasUtils.findIdByQualifiedName(this.queues.keySet(), qualifiedName);
        if (existingQueueId.isPresent()) {
            AtlasEntity entity = this.queues.get(existingQueueId.get());
            this.stillExistingEntityGuids.add(entity.getGuid());
            return new Tuple((Object)existingQueueId.get(), (Object)entity);
        }
        AtlasObjectId queueId = new AtlasObjectId("nifi_queue", "qualifiedName", (Object)qualifiedName);
        AtlasEntity queue = new AtlasEntity("nifi_queue");
        queue.setAttribute("nifiFlow", (Object)this.getAtlasObjectId());
        queue.setAttribute("qualifiedName", (Object)qualifiedName);
        queue.setAttribute("name", (Object)"queue");
        queue.setAttribute("description", (Object)("Input queue for " + destinationComponentId));
        this.queues.put(queueId, queue);
        return new Tuple((Object)queueId, (Object)queue);
    }

    public Map<AtlasObjectId, AtlasEntity> getQueues() {
        return this.queues;
    }

    public Map<String, NiFiFlowPath> getFlowPaths() {
        return this.flowPaths;
    }

    public NiFiFlowPath findPath(String componentId) {
        for (NiFiFlowPath path : this.flowPaths.values()) {
            if (!path.getProcessComponentIds().contains(componentId)) continue;
            return path;
        }
        return null;
    }

    public boolean isProcessComponent(String componentId) {
        return this.isProcessor(componentId) || this.isRootInputPort(componentId) || this.isRootOutputPort(componentId);
    }

    public boolean isProcessor(String componentId) {
        return this.processors.containsKey(componentId);
    }

    public boolean isInputPort(String componentId) {
        return this.inputPorts.containsKey(componentId);
    }

    public boolean isOutputPort(String componentId) {
        return this.outputPorts.containsKey(componentId);
    }

    public boolean isRootInputPort(String componentId) {
        return this.rootInputPorts.containsKey(componentId);
    }

    public boolean isRootOutputPort(String componentId) {
        return this.rootOutputPorts.containsKey(componentId);
    }

    public String getProcessComponentName(String componentId) {
        return this.getProcessComponentName(componentId, () -> "unknown");
    }

    public String getProcessComponentName(String componentId, Supplier<String> unknown) {
        return this.isProcessor(componentId) ? this.getProcessors().get(componentId).getName() : (this.isRootInputPort(componentId) ? this.getRootInputPorts().get(componentId).getName() : (this.isRootOutputPort(componentId) ? this.getRootOutputPorts().get(componentId).getName() : unknown.get()));
    }

    public void startTrackingChanges() {
        this.metadataUpdated.set(false);
        this.updateAudit.clear();
        this.updatedEntityGuids.clear();
        this.stillExistingEntityGuids.clear();
        this.urlUpdated = false;
    }

    public boolean isMetadataUpdated() {
        return this.metadataUpdated.get();
    }

    public String toQualifiedName(String componentId) {
        return AtlasUtils.toQualifiedName(this.clusterName, componentId);
    }

    private EntityChangeType getEntityChangeType(String guid) {
        if (!AtlasUtils.isGuidAssigned(guid)) {
            return EntityChangeType.CREATED;
        }
        if (this.updatedEntityGuids.contains(guid)) {
            return EntityChangeType.UPDATED;
        }
        if (!this.stillExistingEntityGuids.contains(guid)) {
            return EntityChangeType.DELETED;
        }
        return EntityChangeType.AS_IS;
    }

    public Map<EntityChangeType, List<AtlasEntity>> getChangedDataSetEntities() {
        Map<EntityChangeType, List<AtlasEntity>> changedEntities = Stream.of(this.rootInputPortEntities.values().stream(), this.rootOutputPortEntities.values().stream(), this.queues.values().stream()).flatMap(Function.identity()).collect(Collectors.groupingBy(entity -> this.getEntityChangeType(entity.getGuid())));
        this.updateAudit.add("CREATED DataSet entities=" + changedEntities.get((Object)EntityChangeType.CREATED));
        this.updateAudit.add("UPDATED DataSet entities=" + changedEntities.get((Object)EntityChangeType.UPDATED));
        this.updateAudit.add("DELETED DataSet entities=" + changedEntities.get((Object)EntityChangeType.DELETED));
        return changedEntities;
    }

    public NiFiFlowPath getOrCreateFlowPath(String pathId) {
        this.traversedPathIds.add(pathId);
        return this.flowPaths.computeIfAbsent(pathId, k -> new NiFiFlowPath(pathId));
    }

    public boolean isTraversedPath(String pathId) {
        return this.traversedPathIds.contains(pathId);
    }

    private EntityChangeType getFlowPathChangeType(NiFiFlowPath path) {
        if (path.getExEntity() == null) {
            return EntityChangeType.CREATED;
        }
        if (path.isMetadataUpdated() || this.urlUpdated) {
            return EntityChangeType.UPDATED;
        }
        if (!this.traversedPathIds.contains(path.getId())) {
            return EntityChangeType.DELETED;
        }
        return EntityChangeType.AS_IS;
    }

    private EntityChangeType getFlowPathIOChangeType(AtlasObjectId id) {
        String guid = id.getGuid();
        if (!AtlasUtils.isGuidAssigned(guid)) {
            return EntityChangeType.CREATED;
        }
        if ("nifi_queue".equals(id.getTypeName()) && this.queues.containsKey(id)) {
            if (this.stillExistingEntityGuids.contains(guid)) {
                return EntityChangeType.AS_IS;
            }
            return EntityChangeType.DELETED;
        }
        return EntityChangeType.AS_IS;
    }

    private Tuple<EntityChangeType, AtlasEntity> toAtlasEntity(EntityChangeType changeType, NiFiFlowPath path) {
        AtlasEntity entity = EntityChangeType.CREATED.equals((Object)changeType) ? new AtlasEntity() : new AtlasEntity(path.getExEntity());
        entity.setTypeName("nifi_flow_path");
        entity.setVersion(Long.valueOf(1L));
        entity.setAttribute("nifiFlow", (Object)this.getAtlasObjectId());
        StringBuilder name = new StringBuilder();
        StringBuilder description = new StringBuilder();
        path.getProcessComponentIds().forEach(pid -> {
            String componentName = this.getProcessComponentName((String)pid);
            if (name.length() > 0) {
                name.append(", ");
                description.append(", ");
            }
            name.append(componentName);
            description.append(String.format("%s::%s", componentName, pid));
        });
        path.setName(name.toString());
        entity.setAttribute("name", (Object)name.toString());
        entity.setAttribute("description", (Object)description.toString());
        entity.setAttribute("qualifiedName", (Object)this.toQualifiedName(path.getId()));
        entity.setAttribute("url", (Object)path.createDeepLinkURL(this.getUrl()));
        boolean inputsChanged = this.setChangedIOIds(path, entity, true);
        boolean outputsChanged = this.setChangedIOIds(path, entity, false);
        EntityChangeType finalChangeType = EntityChangeType.AS_IS.equals((Object)changeType) ? (path.isMetadataUpdated() || inputsChanged || outputsChanged ? EntityChangeType.UPDATED : EntityChangeType.AS_IS) : changeType;
        return new Tuple((Object)finalChangeType, (Object)entity);
    }

    private boolean setChangedIOIds(NiFiFlowPath path, AtlasEntity pathEntity, boolean isInput) {
        Set<AtlasObjectId> ids = isInput ? path.getInputs() : path.getOutputs();
        String targetAttribute = isInput ? "inputs" : "outputs";
        Map<EntityChangeType, List<AtlasObjectId>> changedIOIds = ids.stream().collect(Collectors.groupingBy(this::getFlowPathIOChangeType));
        Set<AtlasObjectId> remainingFlowPathIOIds = this.toRemainingFlowPathIOIds(changedIOIds);
        if (path.isDataSetReferenceChanged(remainingFlowPathIOIds, isInput)) {
            pathEntity.setAttribute(targetAttribute, remainingFlowPathIOIds);
            return true;
        }
        return false;
    }

    private Set<AtlasObjectId> toRemainingFlowPathIOIds(Map<EntityChangeType, List<AtlasObjectId>> ids) {
        return ids.entrySet().stream().filter(entry -> !EntityChangeType.DELETED.equals(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    public Map<EntityChangeType, List<AtlasEntity>> getChangedFlowPathEntities() {
        HashMap changedPaths = this.flowPaths.values().stream().map(path -> {
            EntityChangeType changeType = this.getFlowPathChangeType((NiFiFlowPath)path);
            switch (changeType) {
                case CREATED: 
                case UPDATED: 
                case AS_IS: {
                    return this.toAtlasEntity(changeType, (NiFiFlowPath)path);
                }
            }
            return new Tuple((Object)changeType, (Object)path.getExEntity());
        }).collect(Collectors.groupingBy(Tuple::getKey, HashMap::new, Collectors.mapping(Tuple::getValue, Collectors.toList())));
        this.updateAudit.add("CREATED NiFiFlowPath=" + changedPaths.get((Object)EntityChangeType.CREATED));
        this.updateAudit.add("UPDATED NiFiFlowPath=" + changedPaths.get((Object)EntityChangeType.UPDATED));
        this.updateAudit.add("DELETED NiFiFlowPath=" + changedPaths.get((Object)EntityChangeType.DELETED));
        return changedPaths;
    }

    public List<String> getUpdateAudit() {
        return this.updateAudit;
    }

    public static enum EntityChangeType {
        AS_IS,
        CREATED,
        UPDATED,
        DELETED;


        public static boolean containsChange(Collection<EntityChangeType> types) {
            return types.contains((Object)CREATED) || types.contains((Object)UPDATED) || types.contains((Object)DELETED);
        }
    }
}

