/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.nifi.atlas.NiFiFlow;
import org.apache.nifi.atlas.NiFiFlowPath;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiFlowAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(NiFiFlowAnalyzer.class);

    public void analyzeProcessGroup(NiFiFlow nifiFlow, ProcessGroupStatus rootProcessGroup) {
        this.analyzeProcessGroup(rootProcessGroup, nifiFlow);
        this.analyzeRootGroupPorts(nifiFlow, rootProcessGroup);
    }

    private void analyzeRootGroupPorts(NiFiFlow nifiFlow, ProcessGroupStatus rootProcessGroup) {
        rootProcessGroup.getInputPortStatus().forEach(port -> nifiFlow.addRootInputPort((PortStatus)port));
        rootProcessGroup.getOutputPortStatus().forEach(port -> nifiFlow.addRootOutputPort((PortStatus)port));
    }

    private void analyzeProcessGroup(ProcessGroupStatus processGroupStatus, NiFiFlow nifiFlow) {
        processGroupStatus.getConnectionStatus().forEach(c -> nifiFlow.addConnection((ConnectionStatus)c));
        processGroupStatus.getProcessorStatus().forEach(p -> nifiFlow.addProcessor((ProcessorStatus)p));
        processGroupStatus.getRemoteProcessGroupStatus().forEach(r -> nifiFlow.addRemoteProcessGroup((RemoteProcessGroupStatus)r));
        processGroupStatus.getInputPortStatus().forEach(p -> nifiFlow.addInputPort((PortStatus)p));
        processGroupStatus.getOutputPortStatus().forEach(p -> nifiFlow.addOutputPort((PortStatus)p));
        for (ProcessGroupStatus child : processGroupStatus.getProcessGroupStatus()) {
            this.analyzeProcessGroup(child, nifiFlow);
        }
    }

    private List<String> getIncomingProcessorsIds(NiFiFlow nifiFlow, List<ConnectionStatus> incomingConnections) {
        if (incomingConnections == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        incomingConnections.forEach(c -> {
            String sourceId = c.getSourceId();
            if (!sourceId.equals(c.getDestinationId())) {
                if (nifiFlow.isProcessor(sourceId)) {
                    ids.add(sourceId);
                } else {
                    ids.addAll(this.getIncomingProcessorsIds(nifiFlow, nifiFlow.getIncomingConnections(sourceId)));
                }
            }
        });
        return ids;
    }

    private List<String> getNextProcessComponent(NiFiFlow nifiFlow, NiFiFlowPath path, String componentId) {
        List<ConnectionStatus> outs = nifiFlow.getOutgoingConnections(componentId);
        if (outs == null || outs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> nextProcessComponent = new ArrayList<String>();
        for (ConnectionStatus out : outs) {
            String destinationId = out.getDestinationId();
            if (path.getProcessComponentIds().contains(destinationId)) continue;
            if (nifiFlow.isProcessComponent(destinationId)) {
                nextProcessComponent.add(destinationId);
                continue;
            }
            nextProcessComponent.addAll(this.getNextProcessComponent(nifiFlow, path, destinationId));
        }
        return nextProcessComponent;
    }

    private void traverse(NiFiFlow nifiFlow, NiFiFlowPath path, String componentId) {
        List<ConnectionStatus> outs;
        if (path.getProcessComponentIds().size() > 0 && nifiFlow.isRootInputPort(componentId)) {
            return;
        }
        if (nifiFlow.isProcessComponent(componentId)) {
            path.addProcessor(componentId);
        }
        if ((outs = nifiFlow.getOutgoingConnections(componentId)) == null || outs.isEmpty()) {
            return;
        }
        List<String> nextProcessComponents = this.getNextProcessComponent(nifiFlow, path, componentId);
        nextProcessComponents.forEach(destPid -> {
            boolean createJointPoint;
            if (path.getProcessComponentIds().contains(destPid)) {
                return;
            }
            boolean bl = createJointPoint = nextProcessComponents.size() > 1 || this.getIncomingProcessorsIds(nifiFlow, nifiFlow.getIncomingConnections((String)destPid)).size() > 1;
            if (createJointPoint) {
                boolean alreadyTraversed = nifiFlow.isTraversedPath((String)destPid);
                Tuple<AtlasObjectId, AtlasEntity> queueTuple = nifiFlow.getOrCreateQueue((String)destPid);
                AtlasObjectId queueId = (AtlasObjectId)queueTuple.getKey();
                path.getOutputs().add(queueId);
                if (alreadyTraversed) {
                    return;
                }
                NiFiFlowPath jointPoint = nifiFlow.getOrCreateFlowPath((String)destPid);
                jointPoint.getInputs().add(queueId);
                this.traverse(nifiFlow, jointPoint, (String)destPid);
            } else {
                this.traverse(nifiFlow, path, (String)destPid);
            }
        });
    }

    private boolean isHeadProcessor(NiFiFlow nifiFlow, List<ConnectionStatus> ins) {
        if (ins == null || ins.isEmpty()) {
            return true;
        }
        return ins.stream().allMatch(in -> {
            String sourceId = in.getSourceId();
            if (nifiFlow.isProcessComponent(sourceId)) {
                return false;
            }
            List<ConnectionStatus> incomingConnections = nifiFlow.getIncomingConnections(sourceId);
            return this.isHeadProcessor(nifiFlow, incomingConnections);
        });
    }

    public void analyzePaths(NiFiFlow nifiFlow) {
        String rootProcessGroupId = nifiFlow.getRootProcessGroupId();
        Map<String, ProcessorStatus> processors = nifiFlow.getProcessors();
        Set<String> headProcessComponents = processors.keySet().stream().filter(pid -> {
            List<ConnectionStatus> ins = nifiFlow.getIncomingConnections((String)pid);
            return this.isHeadProcessor(nifiFlow, ins);
        }).collect(Collectors.toSet());
        headProcessComponents.addAll(nifiFlow.getRootInputPorts().keySet());
        headProcessComponents.forEach(startPid -> {
            NiFiFlowPath path = nifiFlow.getOrCreateFlowPath((String)startPid);
            this.traverse(nifiFlow, path, (String)startPid);
        });
        nifiFlow.getFlowPaths().values().forEach(path -> {
            if (processors.containsKey(path.getId())) {
                ProcessorStatus processor = (ProcessorStatus)processors.get(path.getId());
                path.setGroupId(processor.getGroupId());
            } else {
                path.setGroupId(rootProcessGroupId);
            }
        });
    }
}

