/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;

public class NiFiTypes {
    public static final String TYPE_ASSET = "Asset";
    public static final String TYPE_REFERENCEABLE = "Referenceable";
    public static final String TYPE_PROCESS = "Process";
    public static final String TYPE_DATASET = "DataSet";
    public static final String TYPE_NIFI_COMPONENT = "nifi_component";
    public static final String TYPE_NIFI_FLOW = "nifi_flow";
    public static final String TYPE_NIFI_FLOW_PATH = "nifi_flow_path";
    public static final String TYPE_NIFI_DATA = "nifi_data";
    public static final String TYPE_NIFI_QUEUE = "nifi_queue";
    public static final String TYPE_NIFI_INPUT_PORT = "nifi_input_port";
    public static final String TYPE_NIFI_OUTPUT_PORT = "nifi_output_port";
    public static final String ATTR_GUID = "guid";
    public static final String ATTR_TYPENAME = "typeName";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CLUSTER_NAME = "clusterName";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_INPUTS = "inputs";
    public static final String ATTR_OUTPUTS = "outputs";
    public static final String ATTR_URL = "url";
    public static final String ATTR_URI = "uri";
    public static final String ATTR_PATH = "path";
    public static final String ATTR_QUALIFIED_NAME = "qualifiedName";
    public static final String ATTR_NIFI_FLOW = "nifiFlow";
    public static final String ATTR_FLOW_PATHS = "flowPaths";
    public static final String ATTR_QUEUES = "queues";
    public static final String ATTR_INPUT_PORTS = "inputPorts";
    public static final String ATTR_OUTPUT_PORTS = "outputPorts";
    private static EntityDefinition NIFI_FLOW = (entity, superTypes, attributes) -> {
        entity.setVersion(Long.valueOf(1L));
        superTypes.add(TYPE_REFERENCEABLE);
        superTypes.add(TYPE_ASSET);
        AtlasStructDef.AtlasAttributeDef url = new AtlasStructDef.AtlasAttributeDef(ATTR_URL, "string");
        AtlasStructDef.AtlasAttributeDef flowPaths = new AtlasStructDef.AtlasAttributeDef(ATTR_FLOW_PATHS, NiFiTypes.arrayOf(TYPE_NIFI_FLOW_PATH));
        flowPaths.setIsOptional(true);
        AtlasStructDef.AtlasConstraintDef ownedRef = new AtlasStructDef.AtlasConstraintDef("ownedRef");
        flowPaths.addConstraint(ownedRef);
        AtlasStructDef.AtlasAttributeDef queues = new AtlasStructDef.AtlasAttributeDef(ATTR_QUEUES, NiFiTypes.arrayOf(TYPE_NIFI_QUEUE));
        queues.setIsOptional(true);
        queues.addConstraint(ownedRef);
        AtlasStructDef.AtlasAttributeDef inputPorts = new AtlasStructDef.AtlasAttributeDef(ATTR_INPUT_PORTS, NiFiTypes.arrayOf(TYPE_NIFI_INPUT_PORT));
        inputPorts.setIsOptional(true);
        inputPorts.addConstraint(ownedRef);
        AtlasStructDef.AtlasAttributeDef outputPorts = new AtlasStructDef.AtlasAttributeDef(ATTR_OUTPUT_PORTS, NiFiTypes.arrayOf(TYPE_NIFI_OUTPUT_PORT));
        outputPorts.setIsOptional(true);
        outputPorts.addConstraint(ownedRef);
        attributes.add(url);
        attributes.add(flowPaths);
        attributes.add(queues);
        attributes.add(inputPorts);
        attributes.add(outputPorts);
    };
    private static EntityDefinition NIFI_COMPONENT = (entity, superTypes, attributes) -> {
        entity.setVersion(Long.valueOf(1L));
        AtlasStructDef.AtlasAttributeDef nifiFlow = new AtlasStructDef.AtlasAttributeDef(ATTR_NIFI_FLOW, TYPE_NIFI_FLOW);
        nifiFlow.setIsOptional(true);
        attributes.add(nifiFlow);
    };
    private static EntityDefinition NIFI_FLOW_PATH = (entity, superTypes, attributes) -> {
        entity.setVersion(Long.valueOf(1L));
        superTypes.add(TYPE_PROCESS);
        superTypes.add(TYPE_NIFI_COMPONENT);
        AtlasStructDef.AtlasAttributeDef url = new AtlasStructDef.AtlasAttributeDef(ATTR_URL, "string");
        attributes.add(url);
    };
    private static EntityDefinition NIFI_DATA = (entity, superTypes, attributes) -> {
        entity.setVersion(Long.valueOf(1L));
        superTypes.add(TYPE_DATASET);
        superTypes.add(TYPE_NIFI_COMPONENT);
    };
    private static EntityDefinition NIFI_QUEUE = (entity, superTypes, attributes) -> {
        entity.setVersion(Long.valueOf(1L));
        superTypes.add(TYPE_DATASET);
        superTypes.add(TYPE_NIFI_COMPONENT);
    };
    private static EntityDefinition NIFI_INPUT_PORT = (entity, superTypes, attributes) -> {
        entity.setVersion(Long.valueOf(1L));
        superTypes.add(TYPE_DATASET);
        superTypes.add(TYPE_NIFI_COMPONENT);
    };
    private static EntityDefinition NIFI_OUTPUT_PORT = (entity, superTypes, attributes) -> {
        entity.setVersion(Long.valueOf(1L));
        superTypes.add(TYPE_DATASET);
        superTypes.add(TYPE_NIFI_COMPONENT);
    };
    static Map<String, EntityDefinition> ENTITIES = new HashMap<String, EntityDefinition>();
    static final String[] NIFI_TYPES;

    private static String arrayOf(String typeName) {
        return "array<" + typeName + ">";
    }

    static {
        ENTITIES.put(TYPE_NIFI_COMPONENT, NIFI_COMPONENT);
        ENTITIES.put(TYPE_NIFI_DATA, NIFI_DATA);
        ENTITIES.put(TYPE_NIFI_QUEUE, NIFI_QUEUE);
        ENTITIES.put(TYPE_NIFI_INPUT_PORT, NIFI_INPUT_PORT);
        ENTITIES.put(TYPE_NIFI_OUTPUT_PORT, NIFI_OUTPUT_PORT);
        ENTITIES.put(TYPE_NIFI_FLOW_PATH, NIFI_FLOW_PATH);
        ENTITIES.put(TYPE_NIFI_FLOW, NIFI_FLOW);
        NIFI_TYPES = ENTITIES.keySet().toArray(new String[ENTITIES.size()]);
    }

    @FunctionalInterface
    static interface EntityDefinition {
        public void define(AtlasEntityDef var1, Set<String> var2, List<AtlasStructDef.AtlasAttributeDef> var3);
    }
}

