/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.atlas.typesystem.Referenceable;

public class DataSetRefs {
    private final Set<String> componentIds;
    private Set<Referenceable> inputs;
    private Set<Referenceable> outputs;
    private boolean referableFromRootPath;

    public DataSetRefs(String componentId) {
        this.componentIds = Collections.singleton(componentId);
    }

    public DataSetRefs(Set<String> componentIds) {
        this.componentIds = componentIds;
    }

    public Set<String> getComponentIds() {
        return this.componentIds;
    }

    public Set<Referenceable> getInputs() {
        return this.inputs != null ? this.inputs : Collections.emptySet();
    }

    public void addInput(Referenceable input) {
        if (this.inputs == null) {
            this.inputs = new LinkedHashSet<Referenceable>();
        }
        this.inputs.add(input);
    }

    public Set<Referenceable> getOutputs() {
        return this.outputs != null ? this.outputs : Collections.emptySet();
    }

    public void addOutput(Referenceable output) {
        if (this.outputs == null) {
            this.outputs = new LinkedHashSet<Referenceable>();
        }
        this.outputs.add(output);
    }

    public boolean isEmpty() {
        return !(this.inputs != null && !this.inputs.isEmpty() || this.outputs != null && !this.outputs.isEmpty());
    }
}

