/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.nifi.atlas.provenance.NiFiProvenanceEventAnalyzer;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiProvenanceEventAnalyzerFactory {
    public static NiFiProvenanceEventAnalyzer getAnalyzer(String typeName, String transitUri, ProvenanceEventType eventType) {
        for (Map.Entry entry : AnalyzerHolder.getAnalyzersForComponentType().entrySet()) {
            if (!((Pattern)entry.getKey()).matcher(typeName).matches()) continue;
            return (NiFiProvenanceEventAnalyzer)entry.getValue();
        }
        if (transitUri != null) {
            for (Map.Entry entry : AnalyzerHolder.getAnalyzersForTransitUri().entrySet()) {
                if (!((Pattern)entry.getKey()).matcher(transitUri).matches()) continue;
                return (NiFiProvenanceEventAnalyzer)entry.getValue();
            }
        }
        return (NiFiProvenanceEventAnalyzer)AnalyzerHolder.getAnalyzersForProvenanceEventType().get(eventType);
    }

    private static class AnalyzerHolder {
        private static final Logger logger = LoggerFactory.getLogger(AnalyzerHolder.class);
        private static final Map<Pattern, NiFiProvenanceEventAnalyzer> analyzersForComponentType = new ConcurrentHashMap<Pattern, NiFiProvenanceEventAnalyzer>();
        private static final Map<Pattern, NiFiProvenanceEventAnalyzer> analyzersForTransitUri = new ConcurrentHashMap<Pattern, NiFiProvenanceEventAnalyzer>();
        private static final Map<ProvenanceEventType, NiFiProvenanceEventAnalyzer> analyzersForProvenanceEventType = new ConcurrentHashMap<ProvenanceEventType, NiFiProvenanceEventAnalyzer>();

        private AnalyzerHolder() {
        }

        private static void addAnalyzer(String patternStr, Map<Pattern, NiFiProvenanceEventAnalyzer> toAdd, NiFiProvenanceEventAnalyzer analyzer) {
            if (patternStr != null && !patternStr.isEmpty()) {
                Pattern pattern = Pattern.compile(patternStr.trim());
                toAdd.put(pattern, analyzer);
            }
        }

        private static Map<Pattern, NiFiProvenanceEventAnalyzer> getAnalyzersForComponentType() {
            return analyzersForComponentType;
        }

        private static Map<Pattern, NiFiProvenanceEventAnalyzer> getAnalyzersForTransitUri() {
            return analyzersForTransitUri;
        }

        private static Map<ProvenanceEventType, NiFiProvenanceEventAnalyzer> getAnalyzersForProvenanceEventType() {
            return analyzersForProvenanceEventType;
        }

        static {
            logger.debug("Loading NiFiProvenanceEventAnalyzer ...");
            ServiceLoader<NiFiProvenanceEventAnalyzer> serviceLoader = ServiceLoader.load(NiFiProvenanceEventAnalyzer.class);
            serviceLoader.forEach(analyzer -> {
                AnalyzerHolder.addAnalyzer(analyzer.targetComponentTypePattern(), analyzersForComponentType, analyzer);
                AnalyzerHolder.addAnalyzer(analyzer.targetTransitUriPattern(), analyzersForTransitUri, analyzer);
                ProvenanceEventType eventType = analyzer.targetProvenanceEventType();
                if (eventType != null) {
                    if (analyzersForProvenanceEventType.containsKey(eventType)) {
                        logger.warn("Fo ProvenanceEventType {}, an Analyzer {} is already assigned. Only one analyzer for a type can be registered. Ignoring {}", new Object[]{eventType, analyzersForProvenanceEventType.get(eventType), analyzer});
                    }
                    analyzersForProvenanceEventType.put(eventType, (NiFiProvenanceEventAnalyzer)analyzer);
                }
            });
            logger.info("Loaded NiFiProvenanceEventAnalyzers: componentTypes={}, transitUris={}", analyzersForComponentType, analyzersForTransitUri);
        }
    }
}

