/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import org.apache.atlas.typesystem.Referenceable;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.provenance.AbstractNiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.provenance.analyzer.DatabaseAnalyzerUtil;
import org.apache.nifi.util.Tuple;

public abstract class AbstractHiveAnalyzer
extends AbstractNiFiProvenanceEventAnalyzer {
    static final String TYPE_DATABASE = "hive_db";
    static final String TYPE_TABLE = "hive_table";
    static final String ATTR_DB = "db";

    protected Referenceable createDatabaseRef(String clusterName, String databaseName) {
        Referenceable ref = new Referenceable(TYPE_DATABASE, new String[0]);
        ref.set("name", (Object)databaseName);
        ref.set("clusterName", (Object)clusterName);
        ref.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(clusterName, databaseName));
        return ref;
    }

    protected Referenceable createTableRef(String clusterName, Tuple<String, String> tableName) {
        Referenceable ref = new Referenceable(TYPE_TABLE, new String[0]);
        ref.set("name", tableName.getValue());
        ref.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(clusterName, DatabaseAnalyzerUtil.toTableNameStr(tableName)));
        ref.set(ATTR_DB, (Object)this.createDatabaseRef(clusterName, (String)tableName.getKey()));
        return ref;
    }
}

