/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.provenance.AbstractNiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePath
extends AbstractNiFiProvenanceEventAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(FilePath.class);
    private static final String TYPE = "fs_path";

    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        String clusterName;
        Referenceable ref = new Referenceable(TYPE, new String[0]);
        URI uri = this.parseUri(event.getTransitUri());
        try {
            String uriHost = uri.getHost();
            String hostname = StringUtils.isEmpty((String)uriHost) ? InetAddress.getLocalHost().getHostName() : uriHost;
            clusterName = context.getClusterResolver().fromHostNames(hostname);
        }
        catch (UnknownHostException e) {
            logger.warn("Failed to get localhost name due to " + e, (Throwable)e);
            return null;
        }
        String path = uri.getPath();
        ref.set("name", (Object)path);
        ref.set("path", (Object)path);
        ref.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(clusterName, path));
        return this.singleDataSetRef(event.getComponentId(), event.getEventType(), ref);
    }

    @Override
    public String targetTransitUriPattern() {
        return "^file:/.+$";
    }
}

