/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.provenance.AbstractNiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTable
extends AbstractNiFiProvenanceEventAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(HBaseTable.class);
    private static final String TYPE = "hbase_table";
    private static final Pattern URI_PATTERN = Pattern.compile("^hbase://([^/]+)/([^/]+)/?.*$");

    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        String transitUri = event.getTransitUri();
        Matcher uriMatcher = URI_PATTERN.matcher(transitUri);
        if (!uriMatcher.matches()) {
            logger.warn("Unexpected transit URI: {}", new Object[]{transitUri});
            return null;
        }
        Referenceable ref = new Referenceable(TYPE, new String[0]);
        String[] hostNames = this.splitHostNames(uriMatcher.group(1));
        String clusterName = context.getClusterResolver().fromHostNames(hostNames);
        String tableName = uriMatcher.group(2);
        ref.set("name", (Object)tableName);
        ref.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(clusterName, tableName));
        ref.set("uri", (Object)transitUri);
        return this.singleDataSetRef(event.getComponentId(), event.getEventType(), ref);
    }

    @Override
    public String targetTransitUriPattern() {
        return "^hbase://.+$";
    }
}

