/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.net.URI;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.provenance.AbstractNiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.provenance.ProvenanceEventRecord;

public class HDFSPath
extends AbstractNiFiProvenanceEventAnalyzer {
    private static final String TYPE = "hdfs_path";

    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        Referenceable ref = new Referenceable(TYPE, new String[0]);
        URI uri = this.parseUri(event.getTransitUri());
        String clusterName = context.getClusterResolver().fromHostNames(uri.getHost());
        String path = uri.getPath();
        ref.set("name", (Object)path);
        ref.set("path", (Object)path);
        ref.set("clusterName", (Object)clusterName);
        ref.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(clusterName, path));
        return this.singleDataSetRef(event.getComponentId(), event.getEventType(), ref);
    }

    @Override
    public String targetTransitUriPattern() {
        return "^hdfs://.+$";
    }
}

