/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.atlas.provenance.analyzer.AbstractHiveAnalyzer;
import org.apache.nifi.atlas.provenance.analyzer.DatabaseAnalyzerUtil;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive2JDBC
extends AbstractHiveAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(Hive2JDBC.class);
    private static final String URI_PATTERN_STR = "jdbc:hive2://([^/]+)/?(.*)$";
    private static final Pattern URI_PATTERN = Pattern.compile("jdbc:hive2://([^/]+)/?(.*)$");

    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        String transitUri = event.getTransitUri();
        if (transitUri == null) {
            return null;
        }
        Matcher uriMatcher = URI_PATTERN.matcher(transitUri);
        if (!uriMatcher.matches()) {
            logger.warn("Unexpected transit URI: {}", new Object[]{transitUri});
            return null;
        }
        String clusterName = context.getClusterResolver().fromHostNames(this.splitHostNames(uriMatcher.group(1)));
        String connectedDatabaseName = null;
        if (uriMatcher.groupCount() > 1) {
            String[] connectionParams = uriMatcher.group(2).split(";");
            connectedDatabaseName = connectionParams[0];
        }
        if (StringUtils.isEmpty(connectedDatabaseName)) {
            connectedDatabaseName = "default";
        }
        Set<Tuple<String, String>> inputTables = DatabaseAnalyzerUtil.parseTableNames(connectedDatabaseName, event.getAttribute(DatabaseAnalyzerUtil.ATTR_INPUT_TABLES));
        Set<Tuple<String, String>> outputTables = DatabaseAnalyzerUtil.parseTableNames(connectedDatabaseName, event.getAttribute(DatabaseAnalyzerUtil.ATTR_OUTPUT_TABLES));
        if (inputTables.isEmpty() && outputTables.isEmpty()) {
            return this.getDatabaseRef(event.getComponentId(), event.getEventType(), clusterName, connectedDatabaseName);
        }
        DataSetRefs refs = new DataSetRefs(event.getComponentId());
        this.addRefs(refs, true, clusterName, inputTables);
        this.addRefs(refs, false, clusterName, outputTables);
        return refs;
    }

    private DataSetRefs getDatabaseRef(String componentId, ProvenanceEventType eventType, String clusterName, String databaseName) {
        Referenceable ref = this.createDatabaseRef(clusterName, databaseName);
        return this.singleDataSetRef(componentId, eventType, ref);
    }

    private void addRefs(DataSetRefs refs, boolean isInput, String clusterName, Set<Tuple<String, String>> tableNames) {
        tableNames.forEach(tableName -> {
            Referenceable ref = this.createTableRef(clusterName, (Tuple<String, String>)tableName);
            if (isInput) {
                refs.addInput(ref);
            } else {
                refs.addOutput(ref);
            }
        });
    }

    @Override
    public String targetTransitUriPattern() {
        return URI_PATTERN_STR;
    }
}

