/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.atlas.provenance.AbstractNiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.resolver.ClusterResolver;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NiFiS2S
extends AbstractNiFiProvenanceEventAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(NiFiS2S.class);
    private static final Pattern RAW_URL_REGEX = Pattern.compile("nifi://([^:/]+):\\d+/([0-9a-zA-Z\\-]+)");
    private static final Pattern HTTP_URL_REGEX = Pattern.compile(".*/nifi-api/data-transfer/(in|out)put-ports/([[0-9a-zA-Z\\-]]+)/transactions/.*");

    protected S2SPort analyzeS2SPort(ProvenanceEventRecord event, ClusterResolver clusterResolver) {
        String targetPortId;
        String targetHostname;
        String protocol;
        String transitUri = event.getTransitUri();
        int protocolIndex = transitUri.indexOf(58);
        switch (protocol = transitUri.substring(0, protocolIndex).toLowerCase()) {
            case "http": 
            case "https": {
                Matcher uriMatcher = this.matchUrl(transitUri, HTTP_URL_REGEX);
                targetHostname = this.parseUri(transitUri).getHost();
                targetPortId = uriMatcher.group(2);
                break;
            }
            case "nifi": {
                Matcher uriMatcher = this.matchUrl(transitUri, RAW_URL_REGEX);
                targetHostname = uriMatcher.group(1);
                targetPortId = this.getRawProtocolPortId(event);
                break;
            }
            default: {
                throw new IllegalArgumentException("Protocol " + protocol + " is not supported as NiFi S2S transit URL.");
            }
        }
        String clusterName = clusterResolver.fromHostNames(targetHostname);
        return new S2SPort(clusterName, targetPortId);
    }

    protected abstract String getRawProtocolPortId(ProvenanceEventRecord var1);

    private Matcher matchUrl(String url, Pattern pattern) {
        Matcher uriMatcher = pattern.matcher(url);
        if (!uriMatcher.matches()) {
            throw new IllegalArgumentException("Unexpected transit URI: " + url);
        }
        return uriMatcher;
    }

    protected static class S2SPort {
        final String clusterName;
        final String targetPortId;

        public S2SPort(String clusterName, String targetPortId) {
            this.clusterName = clusterName;
            this.targetPortId = targetPortId;
        }
    }
}

