/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.lineage;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.NiFiFlow;
import org.apache.nifi.atlas.NiFiFlowPath;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.atlas.provenance.lineage.AbstractLineageStrategy;
import org.apache.nifi.atlas.provenance.lineage.LineagePath;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.lineage.ComputeLineageResult;
import org.apache.nifi.provenance.lineage.LineageNode;
import org.apache.nifi.provenance.lineage.LineageNodeType;
import org.apache.nifi.util.Tuple;

public class CompleteFlowPathLineage
extends AbstractLineageStrategy {
    @Override
    public ProvenanceEventType[] getTargetEventTypes() {
        return new ProvenanceEventType[]{ProvenanceEventType.DROP};
    }

    @Override
    public void processEvent(AnalysisContext analysisContext, NiFiFlow nifiFlow, ProvenanceEventRecord event) {
        if (!ProvenanceEventType.DROP.equals((Object)event.getEventType())) {
            return;
        }
        ComputeLineageResult lineage = analysisContext.queryLineage(event.getEventId());
        HashMap<String, List<LineageNode>> lineageTree = new HashMap<String, List<LineageNode>>();
        this.analyzeLineageTree(lineage, lineageTree);
        LineagePath lineagePath = new LineagePath();
        this.extractLineagePaths(analysisContext, lineageTree, lineagePath, event);
        this.analyzeLineagePath(analysisContext, lineagePath);
        ArrayList<Tuple<NiFiFlowPath, DataSetRefs>> createdFlowPaths = new ArrayList<Tuple<NiFiFlowPath, DataSetRefs>>();
        if (lineagePath.isComplete()) {
            this.createCompleteFlowPath(nifiFlow, lineagePath, createdFlowPaths);
            for (Tuple tuple : createdFlowPaths) {
                NiFiFlowPath flowPath = (NiFiFlowPath)tuple.getKey();
                Referenceable flowPathRef = this.toReferenceable(flowPath, nifiFlow);
                DataSetRefs dataSetRefs = (DataSetRefs)tuple.getValue();
                this.addDataSetRefs(dataSetRefs.getInputs(), flowPathRef, "inputs");
                this.addDataSetRefs(dataSetRefs.getOutputs(), flowPathRef, "outputs");
                this.createEntity(flowPathRef);
                this.addDataSetRefs(nifiFlow, Collections.singleton(flowPath), (DataSetRefs)tuple.getValue());
            }
            createdFlowPaths.clear();
        }
    }

    private List<LineageNode> findParentEvents(Map<String, List<LineageNode>> lineageTree, ProvenanceEventRecord event) {
        List<LineageNode> parentNodes = lineageTree.get(String.valueOf(event.getEventId()));
        return parentNodes == null || parentNodes.isEmpty() ? null : parentNodes.stream().flatMap(n -> !LineageNodeType.PROVENANCE_EVENT_NODE.equals((Object)n.getNodeType()) ? ((List)lineageTree.get(n.getIdentifier())).stream() : Stream.of(n)).collect(Collectors.toList());
    }

    private void extractLineagePaths(AnalysisContext context, Map<String, List<LineageNode>> lineageTree, LineagePath lineagePath, ProvenanceEventRecord lastEvent) {
        lineagePath.getEvents().add(lastEvent);
        List<LineageNode> parentEvents = this.findParentEvents(lineageTree, lastEvent);
        boolean createSeparateParentPath = lineagePath.shouldCreateSeparatePath(lastEvent.getEventType());
        if (createSeparateParentPath && (parentEvents == null || parentEvents.isEmpty())) {
            ComputeLineageResult joinedParents = context.findParents(lastEvent.getEventId());
            this.analyzeLineageTree(joinedParents, lineageTree);
            parentEvents = this.findParentEvents(lineageTree, lastEvent);
        }
        if (parentEvents == null || parentEvents.isEmpty()) {
            this.logger.debug("{} does not have any parent, stop extracting lineage path.", (Object)lastEvent);
            return;
        }
        if (createSeparateParentPath) {
            parentEvents.stream().map(parentEvent -> context.getProvenanceEvent(Long.parseLong(parentEvent.getIdentifier()))).filter(Objects::nonNull).forEach(parent -> {
                LineagePath parentPath = new LineagePath();
                lineagePath.getParents().add(parentPath);
                this.extractLineagePaths(context, lineageTree, parentPath, (ProvenanceEventRecord)parent);
            });
        } else {
            if (parentEvents.size() > 1) {
                throw new IllegalStateException(String.format("Having more than 1 parents for event type %s is not expected. Should ask NiFi developer for investigation. %s", lastEvent.getEventType(), lastEvent));
            }
            ProvenanceEventRecord parentEvent2 = context.getProvenanceEvent(Long.parseLong(parentEvents.get(0).getIdentifier()));
            if (parentEvent2 != null) {
                this.extractLineagePaths(context, lineageTree, lineagePath, parentEvent2);
            }
        }
    }

    private void analyzeLineagePath(AnalysisContext analysisContext, LineagePath lineagePath) {
        List<ProvenanceEventRecord> events = lineagePath.getEvents();
        DataSetRefs parentRefs = new DataSetRefs(events.get(0).getComponentId());
        events.forEach(event -> {
            DataSetRefs refs = this.executeAnalyzer(analysisContext, (ProvenanceEventRecord)event);
            if (refs == null || refs.isEmpty()) {
                return;
            }
            refs.getInputs().forEach(parentRefs::addInput);
            refs.getOutputs().forEach(parentRefs::addOutput);
        });
        lineagePath.setRefs(parentRefs);
        lineagePath.getParents().forEach(parent -> this.analyzeLineagePath(analysisContext, (LineagePath)parent));
    }

    private void analyzeLineageTree(ComputeLineageResult lineage, Map<String, List<LineageNode>> lineageTree) {
        lineage.getEdges().forEach(edge -> lineageTree.computeIfAbsent(edge.getDestination().getIdentifier(), k -> new ArrayList()).add(edge.getSource()));
    }

    private void createCompleteFlowPath(NiFiFlow nifiFlow, LineagePath lineagePath, List<Tuple<NiFiFlowPath, DataSetRefs>> createdFlowPaths) {
        List<ProvenanceEventRecord> events = lineagePath.getEvents();
        Collections.reverse(events);
        List componentIds = events.stream().map(ProvenanceEventRecord::getComponentId).collect(Collectors.toList());
        String firstComponentId = events.get(0).getComponentId();
        DataSetRefs dataSetRefs = lineagePath.getRefs();
        Referenceable queueBetweenParent = null;
        if (!lineagePath.getParents().isEmpty()) {
            queueBetweenParent = new Referenceable("nifi_queue", new String[0]);
            String firstEventType = events.get(0).getEventType().name();
            queueBetweenParent.set("name", (Object)firstEventType);
            dataSetRefs.addInput(queueBetweenParent);
            for (LineagePath parent : lineagePath.getParents()) {
                parent.getRefs().addOutput(queueBetweenParent);
                this.createCompleteFlowPath(nifiFlow, parent, createdFlowPaths);
            }
        }
        Stream<String> ioIds = Stream.concat(dataSetRefs.getInputs().stream(), dataSetRefs.getOutputs().stream()).map(ref -> AtlasUtils.toTypedQualifiedName(ref.getTypeName(), AtlasUtils.toStr(ref.get("qualifiedName"))));
        Stream<String> parentHashes = lineagePath.getParents().stream().map(p -> String.valueOf(p.getLineagePathHash()));
        CRC32 crc32 = new CRC32();
        crc32.update(Stream.of(componentIds.stream(), ioIds, parentHashes).reduce(Stream::concat).orElseGet(Stream::empty).sorted().distinct().collect(Collectors.joining(",")).getBytes(StandardCharsets.UTF_8));
        long hash = crc32.getValue();
        lineagePath.setLineagePathHash(hash);
        NiFiFlowPath flowPath = new NiFiFlowPath(firstComponentId, hash);
        if (queueBetweenParent != null) {
            queueBetweenParent.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(nifiFlow.getClusterName(), firstComponentId + "::" + hash));
        }
        String previousComponentId = null;
        ArrayList<ProvenanceEventRecord> uniqueEventsForName = new ArrayList<ProvenanceEventRecord>();
        for (ProvenanceEventRecord event2 : events) {
            if (!event2.getComponentId().equals(previousComponentId)) {
                uniqueEventsForName.add(event2);
            }
            previousComponentId = event2.getComponentId();
        }
        String pathName = uniqueEventsForName.stream().map(event -> nifiFlow.getProcessComponentName(event.getComponentId(), () -> ((ProvenanceEventRecord)event).getComponentType())).collect(Collectors.joining(", "));
        flowPath.setName(pathName);
        NiFiFlowPath staticFlowPath = nifiFlow.findPath(firstComponentId);
        flowPath.setGroupId(staticFlowPath != null ? staticFlowPath.getGroupId() : nifiFlow.getRootProcessGroupId());
        createdFlowPaths.add((Tuple<NiFiFlowPath, DataSetRefs>)new Tuple((Object)flowPath, (Object)dataSetRefs));
    }
}

