/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.reporting;

import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.atlas.NiFiAtlasClient;
import org.apache.nifi.atlas.NiFiFlow;
import org.apache.nifi.atlas.NiFiFlowAnalyzer;
import org.apache.nifi.atlas.hook.NiFiAtlasHook;
import org.apache.nifi.atlas.provenance.StandardAnalysisContext;
import org.apache.nifi.atlas.provenance.lineage.CompleteFlowPathLineage;
import org.apache.nifi.atlas.provenance.lineage.LineageStrategy;
import org.apache.nifi.atlas.provenance.lineage.SimpleFlowPathLineage;
import org.apache.nifi.atlas.resolver.ClusterResolver;
import org.apache.nifi.atlas.resolver.ClusterResolvers;
import org.apache.nifi.atlas.security.AtlasAuthN;
import org.apache.nifi.atlas.security.Basic;
import org.apache.nifi.atlas.security.Kerberos;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.util.provenance.ProvenanceEventConsumer;
import org.apache.nifi.ssl.SSLContextService;

@Tags(value={"atlas", "lineage"})
@CapabilityDescription(value="Report NiFi flow data set level lineage to Apache Atlas. End-to-end lineages across NiFi environments and other systems can be reported if those are connected by different protocols and data set, such as NiFi Site-to-Site, Kafka topic or Hive tables ... etc. Atlas lineage reported by this reporting task can be useful to grasp the high level relationships between processes and data sets, in addition to NiFi provenance events providing detailed event level lineage. See 'Additional Details' for further description and limitations.")
@Stateful(scopes={Scope.LOCAL}, description="Stores the Reporting Task's last event Id so that on restart the task knows where it left off.")
@DynamicProperty(name="hostnamePattern.<ClusterName>", value="hostname Regex patterns", description="White space delimited (including new line) Regular Expressions to resolve a 'Cluster Name' from a hostname or IP address of a transit URI of NiFi provenance record.", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY)
@RequiresInstanceClassLoading
public class ReportLineageToAtlas
extends AbstractReportingTask {
    static final PropertyDescriptor ATLAS_URLS = new PropertyDescriptor.Builder().name("atlas-urls").displayName("Atlas URLs").description("Comma separated URL of Atlas Servers (e.g. http://atlas-server-hostname:21000 or https://atlas-server-hostname:21443). For accessing Atlas behind Knox gateway, specify Knox gateway URL (e.g. https://knox-hostname:8443/gateway/{topology-name}/atlas).").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final AllowableValue ATLAS_AUTHN_BASIC = new AllowableValue("basic", "Basic", "Use username and password.");
    static final AllowableValue ATLAS_AUTHN_KERBEROS = new AllowableValue("kerberos", "Kerberos", "Use Kerberos keytab file.");
    static final PropertyDescriptor ATLAS_AUTHN_METHOD = new PropertyDescriptor.Builder().name("atlas-authentication-method").displayName("Atlas Authentication Method").description("Specify how to authenticate this reporting task to Atlas server.").required(true).allowableValues(new AllowableValue[]{ATLAS_AUTHN_BASIC, ATLAS_AUTHN_KERBEROS}).defaultValue(ATLAS_AUTHN_BASIC.getValue()).build();
    public static final PropertyDescriptor ATLAS_USER = new PropertyDescriptor.Builder().name("atlas-username").displayName("Atlas Username").description("User name to communicate with Atlas.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor ATLAS_PASSWORD = new PropertyDescriptor.Builder().name("atlas-password").displayName("Atlas Password").description("Password to communicate with Atlas.").required(false).sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor ATLAS_CONF_DIR = new PropertyDescriptor.Builder().name("atlas-conf-dir").displayName("Atlas Configuration Directory").description("Directory path that contains 'atlas-application.properties' file. If not specified and 'Create Atlas Configuration File' is disabled, then, 'atlas-application.properties' file under root classpath is used.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor ATLAS_NIFI_URL = new PropertyDescriptor.Builder().name("atlas-nifi-url").displayName("NiFi URL for Atlas").description("NiFi URL is used in Atlas to represent this NiFi cluster (or standalone instance). It is recommended to use one that can be accessible remotely instead of using 'localhost'.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor ATLAS_DEFAULT_CLUSTER_NAME = new PropertyDescriptor.Builder().name("atlas-default-cluster-name").displayName("Atlas Default Cluster Name").description("Cluster name for Atlas entities reported by this ReportingTask. If not specified, 'atlas.cluster.name' in Atlas Configuration File is used. Cluster name mappings can be configured by user defined properties. See additional detail for detail.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor ATLAS_CONF_CREATE = new PropertyDescriptor.Builder().name("atlas-conf-create").displayName("Create Atlas Configuration File").description("If enabled, 'atlas-application.properties' file will be created in 'Atlas Configuration Directory' automatically when this Reporting Task starts. Note that the existing configuration file will be overwritten.").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("ssl-context-service").displayName("SSL Context Service").description("Specifies the SSL Context Service to use for communicating with Atlas and Kafka.").required(false).identifiesControllerService(SSLContextService.class).build();
    static final PropertyDescriptor KAFKA_BOOTSTRAP_SERVERS = new PropertyDescriptor.Builder().name("kafka-bootstrap-servers").displayName("Kafka Bootstrap Servers").description("Kafka Bootstrap Servers to send Atlas hook notification messages based on NiFi provenance events. E.g. 'localhost:9092' NOTE: Once this reporting task has started, restarting NiFi is required to changed this property as Atlas library holds a unmodifiable static reference to Kafka client.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final AllowableValue SEC_PLAINTEXT = new AllowableValue("PLAINTEXT", "PLAINTEXT", "PLAINTEXT");
    static final AllowableValue SEC_SSL = new AllowableValue("SSL", "SSL", "SSL");
    static final AllowableValue SEC_SASL_PLAINTEXT = new AllowableValue("SASL_PLAINTEXT", "SASL_PLAINTEXT", "SASL_PLAINTEXT");
    static final AllowableValue SEC_SASL_SSL = new AllowableValue("SASL_SSL", "SASL_SSL", "SASL_SSL");
    static final PropertyDescriptor KAFKA_SECURITY_PROTOCOL = new PropertyDescriptor.Builder().name("kafka-security-protocol").displayName("Kafka Security Protocol").description("Protocol used to communicate with Kafka brokers to send Atlas hook notification messages. Corresponds to Kafka's 'security.protocol' property.").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new AllowableValue[]{SEC_PLAINTEXT, SEC_SSL, SEC_SASL_PLAINTEXT, SEC_SASL_SSL}).defaultValue(SEC_PLAINTEXT.getValue()).build();
    public static final PropertyDescriptor NIFI_KERBEROS_PRINCIPAL = new PropertyDescriptor.Builder().name("nifi-kerberos-principal").displayName("NiFi Kerberos Principal").description("The Kerberos principal for this NiFi instance to access Atlas API and Kafka brokers. If not set, it is expected to set a JAAS configuration file in the JVM properties defined in the bootstrap.conf file. This principal will be set into 'sasl.jaas.config' Kafka's property.").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor NIFI_KERBEROS_KEYTAB = new PropertyDescriptor.Builder().name("nifi-kerberos-keytab").displayName("NiFi Kerberos Keytab").description("The Kerberos keytab for this NiFi instance to access Atlas API and Kafka brokers. If not set, it is expected to set a JAAS configuration file in the JVM properties defined in the bootstrap.conf file. This principal will be set into 'sasl.jaas.config' Kafka's property.").required(false).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    static final PropertyDescriptor KAFKA_KERBEROS_SERVICE_NAME = new PropertyDescriptor.Builder().name("kafka-kerberos-service-name").displayName("Kafka Kerberos Service Name").description("The Kerberos principal name that Kafka runs for Atlas notification. This can be defined either in Kafka's JAAS config or in Kafka's config. Corresponds to Kafka's 'security.protocol' property. It is ignored unless one of the SASL options of the <Security Protocol> are selected.").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("kafka").build();
    static final AllowableValue LINEAGE_STRATEGY_SIMPLE_PATH = new AllowableValue("SimplePath", "Simple Path", "Map NiFi provenance events and target Atlas DataSets to statically created 'nifi_flow_path' Atlas Processes. See also 'Additional Details'.");
    static final AllowableValue LINEAGE_STRATEGY_COMPLETE_PATH = new AllowableValue("CompletePath", "Complete Path", "Create separate 'nifi_flow_path' Atlas Processes for each distinct input and output DataSet combinations by looking at the complete route for a given FlowFile. See also 'Additional Details.");
    static final PropertyDescriptor NIFI_LINEAGE_STRATEGY = new PropertyDescriptor.Builder().name("nifi-lineage-strategy").displayName("NiFi Lineage Strategy").description("Specifies granularity on how NiFi data flow should be reported to Atlas. NOTE: It is strongly recommended to keep using the same strategy once this reporting task started to keep Atlas data clean. Switching strategies will not delete Atlas entities created by the old strategy. Having mixed entities created by different strategies makes Atlas lineage graph noisy. For more detailed description on each strategy and differences, refer 'NiFi Lineage Strategy' section in Additional Details.").required(true).allowableValues(new AllowableValue[]{LINEAGE_STRATEGY_SIMPLE_PATH, LINEAGE_STRATEGY_COMPLETE_PATH}).defaultValue(LINEAGE_STRATEGY_SIMPLE_PATH.getValue()).build();
    private static final String ATLAS_PROPERTIES_FILENAME = "atlas-application.properties";
    private static final String ATLAS_PROPERTY_CLUSTER_NAME = "atlas.cluster.name";
    private static final String ATLAS_PROPERTY_ENABLE_TLS = "atlas.enableTLS";
    private static final String ATLAS_KAFKA_PREFIX = "atlas.kafka.";
    private static final String ATLAS_PROPERTY_KAFKA_BOOTSTRAP_SERVERS = "atlas.kafka.bootstrap.servers";
    private static final String ATLAS_PROPERTY_KAFKA_CLIENT_ID = "atlas.kafka.client.id";
    private final ServiceLoader<ClusterResolver> clusterResolverLoader = ServiceLoader.load(ClusterResolver.class);
    private volatile AtlasAuthN atlasAuthN;
    private volatile Properties atlasProperties;
    private volatile boolean isTypeDefCreated = false;
    private volatile String defaultClusterName;
    private volatile ProvenanceEventConsumer consumer;
    private volatile ClusterResolvers clusterResolvers;
    private volatile NiFiAtlasHook nifiAtlasHook;
    private volatile LineageStrategy lineageStrategy;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(ATLAS_URLS);
        properties.add(ATLAS_AUTHN_METHOD);
        properties.add(ATLAS_USER);
        properties.add(ATLAS_PASSWORD);
        properties.add(ATLAS_CONF_DIR);
        properties.add(ATLAS_NIFI_URL);
        properties.add(ATLAS_DEFAULT_CLUSTER_NAME);
        properties.add(NIFI_LINEAGE_STRATEGY);
        properties.add(ProvenanceEventConsumer.PROVENANCE_START_POSITION);
        properties.add(ProvenanceEventConsumer.PROVENANCE_BATCH_SIZE);
        properties.add(SSL_CONTEXT_SERVICE);
        properties.add(ATLAS_CONF_CREATE);
        properties.add(KERBEROS_CREDENTIALS_SERVICE);
        properties.add(NIFI_KERBEROS_PRINCIPAL);
        properties.add(NIFI_KERBEROS_KEYTAB);
        properties.add(KAFKA_KERBEROS_SERVICE_NAME);
        properties.add(KAFKA_BOOTSTRAP_SERVERS);
        properties.add(KAFKA_SECURITY_PROTOCOL);
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        for (ClusterResolver resolver : this.clusterResolverLoader) {
            PropertyDescriptor propertyDescriptor = resolver.getSupportedDynamicPropertyDescriptor(propertyDescriptorName);
            if (propertyDescriptor == null) continue;
            return propertyDescriptor;
        }
        return null;
    }

    private void parseAtlasUrls(PropertyValue atlasUrlsProp, Consumer<String> urlStrConsumer) {
        String atlasUrlsStr = atlasUrlsProp.evaluateAttributeExpressions().getValue();
        if (atlasUrlsStr != null && !atlasUrlsStr.isEmpty()) {
            Arrays.stream(atlasUrlsStr.split(",")).map(String::trim).forEach(urlStrConsumer);
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        boolean isSSLContextServiceSet = context.getProperty(SSL_CONTEXT_SERVICE).isSet();
        ValidationResult.Builder invalidSSLService = new ValidationResult.Builder().subject(SSL_CONTEXT_SERVICE.getDisplayName()).valid(false);
        this.parseAtlasUrls(context.getProperty(ATLAS_URLS), input -> {
            ValidationResult.Builder builder = new ValidationResult.Builder().subject(ATLAS_URLS.getDisplayName()).input(input);
            try {
                URL url = new URL((String)input);
                if ("https".equalsIgnoreCase(url.getProtocol()) && !isSSLContextServiceSet) {
                    results.add(invalidSSLService.explanation("required by HTTPS Atlas access").build());
                } else {
                    results.add(builder.explanation("Valid URI").valid(true).build());
                }
            }
            catch (Exception e) {
                results.add(builder.explanation("Contains invalid URI: " + e).valid(false).build());
            }
        });
        String atlasAuthNMethod = context.getProperty(ATLAS_AUTHN_METHOD).getValue();
        AtlasAuthN atlasAuthN = this.getAtlasAuthN(atlasAuthNMethod);
        results.addAll(atlasAuthN.validate(context));
        this.clusterResolverLoader.forEach(resolver -> results.addAll(resolver.validate(context)));
        if (context.getProperty(ATLAS_CONF_CREATE).asBoolean().booleanValue()) {
            Stream.of(ATLAS_CONF_DIR, ATLAS_DEFAULT_CLUSTER_NAME, KAFKA_BOOTSTRAP_SERVERS).filter(p -> !context.getProperty(p).isSet()).forEach(p -> results.add(new ValidationResult.Builder().subject(p.getDisplayName()).explanation("required to create Atlas configuration file.").valid(false).build()));
            this.validateKafkaProperties(context, results, isSSLContextServiceSet, invalidSSLService);
        }
        return results;
    }

    private void validateKafkaProperties(ValidationContext context, Collection<ValidationResult> results, boolean isSSLContextServiceSet, ValidationResult.Builder invalidSSLService) {
        String keytab;
        String principal;
        String kafkaSecurityProtocol = context.getProperty(KAFKA_SECURITY_PROTOCOL).getValue();
        if ((SEC_SSL.equals((Object)kafkaSecurityProtocol) || SEC_SASL_SSL.equals((Object)kafkaSecurityProtocol)) && !isSSLContextServiceSet) {
            results.add(invalidSSLService.explanation("required by SSL Kafka connection").build());
        }
        String explicitPrincipal = context.getProperty(NIFI_KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String explicitKeytab = context.getProperty(NIFI_KERBEROS_KEYTAB).evaluateAttributeExpressions().getValue();
        KerberosCredentialsService credentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        if (credentialsService == null) {
            principal = explicitPrincipal;
            keytab = explicitKeytab;
        } else {
            principal = credentialsService.getPrincipal();
            keytab = credentialsService.getKeytab();
        }
        if (SEC_SASL_PLAINTEXT.equals((Object)kafkaSecurityProtocol) || SEC_SASL_SSL.equals((Object)kafkaSecurityProtocol)) {
            if (!context.getProperty(KAFKA_KERBEROS_SERVICE_NAME).isSet()) {
                results.add(new ValidationResult.Builder().subject(KAFKA_KERBEROS_SERVICE_NAME.getDisplayName()).explanation("Required by Kafka SASL authentication.").valid(false).build());
            }
            if (keytab == null || principal == null) {
                results.add(new ValidationResult.Builder().subject("Kerberos Authentication").explanation("Keytab and Principal are required for Kerberos authentication with Apache Kafka.").valid(false).build());
            }
        }
    }

    @OnScheduled
    public void setup(ConfigurationContext context) throws IOException {
        this.initAtlasProperties(context);
        this.initLineageStrategy(context);
        this.initClusterResolvers(context);
    }

    private void initLineageStrategy(ConfigurationContext context) throws IOException {
        this.nifiAtlasHook = new NiFiAtlasHook();
        String strategy = context.getProperty(NIFI_LINEAGE_STRATEGY).getValue();
        if (LINEAGE_STRATEGY_SIMPLE_PATH.equals((Object)strategy)) {
            this.lineageStrategy = new SimpleFlowPathLineage();
        } else if (LINEAGE_STRATEGY_COMPLETE_PATH.equals((Object)strategy)) {
            this.lineageStrategy = new CompleteFlowPathLineage();
        }
        this.lineageStrategy.setLineageContext(this.nifiAtlasHook);
        this.initProvenanceConsumer(context);
    }

    private void initClusterResolvers(ConfigurationContext context) {
        LinkedHashSet loadedClusterResolvers = new LinkedHashSet();
        this.clusterResolverLoader.forEach(resolver -> {
            resolver.configure((PropertyContext)context);
            loadedClusterResolvers.add(resolver);
        });
        this.clusterResolvers = new ClusterResolvers(Collections.unmodifiableSet(loadedClusterResolvers), this.defaultClusterName);
    }

    private void initAtlasProperties(ConfigurationContext context) throws IOException {
        Object in;
        ArrayList urls = new ArrayList();
        this.parseAtlasUrls(context.getProperty(ATLAS_URLS), urls::add);
        boolean isAtlasApiSecure = urls.stream().anyMatch(url -> url.toLowerCase().startsWith("https"));
        String atlasAuthNMethod = context.getProperty(ATLAS_AUTHN_METHOD).getValue();
        String confDirStr = context.getProperty(ATLAS_CONF_DIR).evaluateAttributeExpressions().getValue();
        File confDir = confDirStr != null && !confDirStr.isEmpty() ? new File(confDirStr) : null;
        this.atlasProperties = new Properties();
        File atlasPropertiesFile = new File(confDir, ATLAS_PROPERTIES_FILENAME);
        Boolean createAtlasConf = context.getProperty(ATLAS_CONF_CREATE).asBoolean();
        if (!createAtlasConf.booleanValue()) {
            if (atlasPropertiesFile.isFile()) {
                this.getLogger().info("Loading {}", new Object[]{atlasPropertiesFile});
                try (FileInputStream in2 = new FileInputStream(atlasPropertiesFile);){
                    this.atlasProperties.load(in2);
                }
            }
            String fileInClasspath = "/atlas-application.properties";
            in = ReportLineageToAtlas.class.getResourceAsStream("/atlas-application.properties");
            Throwable throwable = null;
            try {
                this.getLogger().info("Loading {} from classpath", new Object[]{"/atlas-application.properties"});
                if (in == null) {
                    throw new ProcessException(String.format("Could not find %s in classpath. Please add it to classpath, or specify %s a directory containing Atlas properties file, or enable %s to generate it.", "/atlas-application.properties", ATLAS_CONF_DIR.getDisplayName(), ATLAS_CONF_CREATE.getDisplayName()));
                }
                this.atlasProperties.load((InputStream)in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
        }
        this.defaultClusterName = context.getProperty(ATLAS_DEFAULT_CLUSTER_NAME).evaluateAttributeExpressions().getValue();
        if (this.defaultClusterName == null || this.defaultClusterName.isEmpty()) {
            this.defaultClusterName = this.atlasProperties.getProperty(ATLAS_PROPERTY_CLUSTER_NAME);
        }
        if (this.defaultClusterName == null || this.defaultClusterName.isEmpty()) {
            throw new ProcessException("Default cluster name is not defined.");
        }
        this.atlasAuthN = this.getAtlasAuthN(atlasAuthNMethod);
        this.atlasAuthN.configure((PropertyContext)context);
        if (createAtlasConf.booleanValue()) {
            this.atlasProperties.put(ATLAS_PROPERTY_CLUSTER_NAME, this.defaultClusterName);
            this.atlasProperties.put(ATLAS_PROPERTY_ENABLE_TLS, String.valueOf(isAtlasApiSecure));
            this.setKafkaConfig(this.atlasProperties, (PropertyContext)context);
            this.atlasAuthN.populateProperties(this.atlasProperties);
            FileOutputStream fos = new FileOutputStream(atlasPropertiesFile);
            in = null;
            try {
                String ts = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX").withZone(ZoneOffset.UTC).format(Instant.now());
                this.atlasProperties.store(fos, "Generated by Apache NiFi ReportLineageToAtlas ReportingTask at " + ts);
            }
            catch (Throwable throwable) {
                in = throwable;
                throw throwable;
            }
            finally {
                if (fos != null) {
                    if (in != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)in).addSuppressed(throwable);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
        }
        this.getLogger().debug("Force reloading Atlas application properties.");
        ApplicationProperties.forceReload();
        if (confDir != null) {
            Properties props = System.getProperties();
            String atlasConfProp = "atlas.conf";
            props.setProperty("atlas.conf", confDir.getAbsolutePath());
            this.getLogger().debug("{} has been set to: {}", new Object[]{"atlas.conf", props.getProperty("atlas.conf")});
        }
    }

    private NiFiAtlasClient createNiFiAtlasClient(ReportingContext context) {
        ArrayList urls = new ArrayList();
        this.parseAtlasUrls(context.getProperty(ATLAS_URLS), urls::add);
        try {
            return new NiFiAtlasClient(this.atlasAuthN.createClient(urls.toArray(new String[0])));
        }
        catch (NullPointerException e) {
            throw new ProcessException(String.format("Failed to initialize Atlas client due to %s. Make sure 'atlas-application.properties' is in the directory specified with %s or under root classpath if not specified.", e, ATLAS_CONF_DIR.getDisplayName()), (Throwable)e);
        }
    }

    private AtlasAuthN getAtlasAuthN(String atlasAuthNMethod) {
        AtlasAuthN atlasAuthN;
        switch (atlasAuthNMethod) {
            case "basic": {
                atlasAuthN = new Basic();
                break;
            }
            case "kerberos": {
                atlasAuthN = new Kerberos();
                break;
            }
            default: {
                throw new IllegalArgumentException(atlasAuthNMethod + " is not supported as an Atlas authentication method.");
            }
        }
        return atlasAuthN;
    }

    private void initProvenanceConsumer(ConfigurationContext context) throws IOException {
        this.consumer = new ProvenanceEventConsumer();
        this.consumer.setStartPositionValue(context.getProperty(ProvenanceEventConsumer.PROVENANCE_START_POSITION).getValue());
        this.consumer.setBatchSize(context.getProperty(ProvenanceEventConsumer.PROVENANCE_BATCH_SIZE).asInteger().intValue());
        this.consumer.addTargetEventType(this.lineageStrategy.getTargetEventTypes());
        this.consumer.setLogger(this.getLogger());
        this.consumer.setScheduled(true);
    }

    @OnUnscheduled
    public void onUnscheduled() {
        if (this.consumer != null) {
            this.consumer.setScheduled(false);
        }
    }

    @OnStopped
    public void onStopped() {
        if (this.nifiAtlasHook != null) {
            this.nifiAtlasHook.close();
            this.nifiAtlasHook = null;
        }
    }

    public void onTrigger(ReportingContext context) {
        String clusterNodeId = context.getClusterNodeIdentifier();
        boolean isClustered = context.isClustered();
        if (isClustered && StringUtils.isEmpty((CharSequence)clusterNodeId)) {
            return;
        }
        boolean isResponsibleForPrimaryTasks = !isClustered || this.getNodeTypeProvider().isPrimary();
        NiFiAtlasClient atlasClient = this.createNiFiAtlasClient(context);
        if (!this.isTypeDefCreated) {
            try {
                if (isResponsibleForPrimaryTasks) {
                    atlasClient.registerNiFiTypeDefs(false);
                } else if (!atlasClient.isNiFiTypeDefsRegistered()) {
                    this.getLogger().debug("NiFi type definitions are not ready in Atlas type system yet.");
                    return;
                }
                this.isTypeDefCreated = true;
            }
            catch (AtlasServiceException e) {
                throw new RuntimeException("Failed to check and create NiFi flow type definitions in Atlas due to " + (Object)((Object)e), e);
            }
        }
        NiFiFlow nifiFlow = this.createNiFiFlow(context, atlasClient);
        if (isResponsibleForPrimaryTasks) {
            try {
                atlasClient.registerNiFiFlow(nifiFlow);
            }
            catch (AtlasServiceException e) {
                throw new RuntimeException("Failed to register NiFI flow. " + (Object)((Object)e), e);
            }
        }
        this.nifiAtlasHook.setAtlasClient(atlasClient);
        this.consumeNiFiProvenanceEvents(context, nifiFlow);
    }

    private NiFiFlow createNiFiFlow(ReportingContext context, NiFiAtlasClient atlasClient) {
        String clusterName;
        ProcessGroupStatus rootProcessGroup = context.getEventAccess().getGroupStatus("root");
        String flowName = rootProcessGroup.getName();
        String nifiUrl = context.getProperty(ATLAS_NIFI_URL).evaluateAttributeExpressions().getValue();
        try {
            String nifiHostName = new URL(nifiUrl).getHost();
            clusterName = this.clusterResolvers.fromHostNames(nifiHostName);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to parse NiFi URL, " + e.getMessage(), e);
        }
        NiFiFlow existingNiFiFlow = null;
        try {
            existingNiFiFlow = atlasClient.fetchNiFiFlow(rootProcessGroup.getId(), clusterName);
        }
        catch (AtlasServiceException e) {
            if (ClientResponse.Status.NOT_FOUND.equals((Object)e.getStatus())) {
                this.getLogger().debug("Existing flow was not found for {}@{}", new Object[]{rootProcessGroup.getId(), clusterName});
            }
            throw new RuntimeException("Failed to fetch existing NiFI flow. " + (Object)((Object)e), e);
        }
        NiFiFlow nifiFlow = existingNiFiFlow != null ? existingNiFiFlow : new NiFiFlow(rootProcessGroup.getId());
        nifiFlow.setFlowName(flowName);
        nifiFlow.setUrl(nifiUrl);
        nifiFlow.setClusterName(clusterName);
        NiFiFlowAnalyzer flowAnalyzer = new NiFiFlowAnalyzer();
        flowAnalyzer.analyzeProcessGroup(nifiFlow, rootProcessGroup);
        flowAnalyzer.analyzePaths(nifiFlow);
        return nifiFlow;
    }

    private void consumeNiFiProvenanceEvents(ReportingContext context, NiFiFlow nifiFlow) {
        EventAccess eventAccess = context.getEventAccess();
        StandardAnalysisContext analysisContext = new StandardAnalysisContext(nifiFlow, this.clusterResolvers, (ProvenanceRepository)eventAccess.getProvenanceRepository());
        this.consumer.consumeEvents(context, (componentMapHolder, events) -> {
            for (ProvenanceEventRecord event : events) {
                try {
                    this.lineageStrategy.processEvent(analysisContext, nifiFlow, event);
                }
                catch (Exception e) {
                    this.getLogger().error("Skipping failed analyzing event {} due to {}.", new Object[]{event, e, e});
                }
            }
            this.nifiAtlasHook.commitMessages();
        });
    }

    private void setKafkaConfig(Map<Object, Object> mapToPopulate, PropertyContext context) {
        String kafkaBootStrapServers = context.getProperty(KAFKA_BOOTSTRAP_SERVERS).evaluateAttributeExpressions().getValue();
        mapToPopulate.put(ATLAS_PROPERTY_KAFKA_BOOTSTRAP_SERVERS, kafkaBootStrapServers);
        mapToPopulate.put(ATLAS_PROPERTY_KAFKA_CLIENT_ID, String.format("%s.%s", this.getName(), this.getIdentifier()));
        String kafkaSecurityProtocol = context.getProperty(KAFKA_SECURITY_PROTOCOL).getValue();
        mapToPopulate.put("atlas.kafka.security.protocol", kafkaSecurityProtocol);
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        if (sslContextService != null && sslContextService.isKeyStoreConfigured()) {
            mapToPopulate.put("atlas.kafka.ssl.keystore.location", sslContextService.getKeyStoreFile());
            mapToPopulate.put("atlas.kafka.ssl.keystore.password", sslContextService.getKeyStorePassword());
            String keyPass = sslContextService.getKeyPassword() == null ? sslContextService.getKeyStorePassword() : sslContextService.getKeyPassword();
            mapToPopulate.put("atlas.kafka.ssl.key.password", keyPass);
            mapToPopulate.put("atlas.kafka.ssl.keystore.type", sslContextService.getKeyStoreType());
        }
        if (sslContextService != null && sslContextService.isTrustStoreConfigured()) {
            mapToPopulate.put("atlas.kafka.ssl.truststore.location", sslContextService.getTrustStoreFile());
            mapToPopulate.put("atlas.kafka.ssl.truststore.password", sslContextService.getTrustStorePassword());
            mapToPopulate.put("atlas.kafka.ssl.truststore.type", sslContextService.getTrustStoreType());
        }
        if (SEC_SASL_PLAINTEXT.equals((Object)kafkaSecurityProtocol) || SEC_SASL_SSL.equals((Object)kafkaSecurityProtocol)) {
            this.setKafkaJaasConfig(mapToPopulate, context);
        }
    }

    private void setKafkaJaasConfig(Map<Object, Object> mapToPopulate, PropertyContext context) {
        String keytab;
        String principal;
        String explicitPrincipal = context.getProperty(NIFI_KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String explicitKeytab = context.getProperty(NIFI_KERBEROS_KEYTAB).evaluateAttributeExpressions().getValue();
        KerberosCredentialsService credentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        if (credentialsService == null) {
            principal = explicitPrincipal;
            keytab = explicitKeytab;
        } else {
            principal = credentialsService.getPrincipal();
            keytab = credentialsService.getKeytab();
        }
        String serviceName = context.getProperty(KAFKA_KERBEROS_SERVICE_NAME).evaluateAttributeExpressions().getValue();
        if (StringUtils.isNotBlank((CharSequence)keytab) && StringUtils.isNotBlank((CharSequence)principal) && StringUtils.isNotBlank((CharSequence)serviceName)) {
            mapToPopulate.put("atlas.jaas.KafkaClient.loginModuleControlFlag", "required");
            mapToPopulate.put("atlas.jaas.KafkaClient.loginModuleName", "com.sun.security.auth.module.Krb5LoginModule");
            mapToPopulate.put("atlas.jaas.KafkaClient.option.keyTab", keytab);
            mapToPopulate.put("atlas.jaas.KafkaClient.option.principal", principal);
            mapToPopulate.put("atlas.jaas.KafkaClient.option.serviceName", serviceName);
            mapToPopulate.put("atlas.jaas.KafkaClient.option.storeKey", "True");
            mapToPopulate.put("atlas.jaas.KafkaClient.option.useKeyTab", "True");
            mapToPopulate.put("atlas.jaas.ticketBased-KafkaClient.loginModuleControlFlag", "required");
            mapToPopulate.put("atlas.jaas.ticketBased-KafkaClient.loginModuleName", "com.sun.security.auth.module.Krb5LoginModule");
            mapToPopulate.put("atlas.jaas.ticketBased-KafkaClient.option.useTicketCache", "true");
            mapToPopulate.put("atlas.kafka.sasl.kerberos.service.name", serviceName);
        }
    }
}

