/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.atlas.resolver.ClusterResolver;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;

public class ClusterResolvers
implements ClusterResolver {
    private final Set<ClusterResolver> resolvers;
    private final String defaultClusterName;

    public ClusterResolvers(Set<ClusterResolver> resolvers, String defaultClusterName) {
        this.resolvers = resolvers;
        this.defaultClusterName = defaultClusterName;
    }

    @Override
    public PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        for (ClusterResolver resolver : this.resolvers) {
            PropertyDescriptor descriptor = resolver.getSupportedDynamicPropertyDescriptor(propertyDescriptorName);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (ClusterResolver resolver : this.resolvers) {
            results.addAll(resolver.validate(validationContext));
        }
        return results;
    }

    @Override
    public void configure(PropertyContext context) {
        for (ClusterResolver resolver : this.resolvers) {
            resolver.configure(context);
        }
    }

    @Override
    public String fromHostNames(String ... hostNames) {
        for (ClusterResolver resolver : this.resolvers) {
            String clusterName = resolver.fromHostNames(hostNames);
            if (clusterName == null || clusterName.isEmpty()) continue;
            return clusterName;
        }
        return this.defaultClusterName;
    }

    @Override
    public String fromHints(Map<String, String> hints) {
        for (ClusterResolver resolver : this.resolvers) {
            String clusterName = resolver.fromHints(hints);
            if (clusterName == null || clusterName.isEmpty()) continue;
            return clusterName;
        }
        return this.defaultClusterName;
    }
}

