/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.atlas.resolver.ClusterResolver;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;

public class RegexClusterResolver
implements ClusterResolver {
    public static final String PATTERN_PROPERTY_PREFIX = "hostnamePattern.";
    public static final String PATTERN_PROPERTY_PREFIX_DESC = "White space delimited (including new line) Regular Expressions to resolve a 'Cluster Name' from a hostname or IP address of a transit URI of NiFi provenance record.";
    private Map<String, Set<Pattern>> clusterNamePatterns;

    @Override
    public PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        if (propertyDescriptorName.startsWith(PATTERN_PROPERTY_PREFIX)) {
            return new PropertyDescriptor.Builder().name(propertyDescriptorName).description(PATTERN_PROPERTY_PREFIX_DESC).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).sensitive(false).build();
        }
        return null;
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        this.consumeConfigurations(validationContext.getAllProperties(), (clusterNamePatterns, patterns) -> {}, (entry, e) -> {
            ValidationResult result = new ValidationResult.Builder().subject((String)entry.getKey()).input((String)entry.getValue()).explanation(e.getMessage()).valid(false).build();
            validationResults.add(result);
        });
        return validationResults;
    }

    @Override
    public void configure(PropertyContext context) {
        this.clusterNamePatterns = new HashMap<String, Set<Pattern>>();
        this.consumeConfigurations(context.getAllProperties(), (clusterName, patterns) -> this.clusterNamePatterns.put((String)clusterName, (Set<Pattern>)patterns), null);
    }

    private void consumeConfigurations(Map<String, String> allProperties, BiConsumer<String, Set<Pattern>> consumer, BiConsumer<Map.Entry<String, String>, RuntimeException> errorHandler) {
        allProperties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(PATTERN_PROPERTY_PREFIX)).forEach(entry -> {
            try {
                String clusterName = ((String)entry.getKey()).substring(PATTERN_PROPERTY_PREFIX.length());
                String[] regexsArray = ((String)entry.getValue()).split("\\s");
                List<String> regexs = Arrays.stream(regexsArray).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                Set<Pattern> patterns = this.parseClusterNamePatterns(clusterName, regexs);
                consumer.accept(clusterName, patterns);
            }
            catch (RuntimeException e) {
                if (errorHandler != null) {
                    errorHandler.accept((Map.Entry<String, String>)entry, e);
                }
                throw e;
            }
        });
    }

    private Set<Pattern> parseClusterNamePatterns(String clusterName, List<String> regexs) {
        if (clusterName == null || clusterName.isEmpty()) {
            throw new IllegalArgumentException("Empty cluster name is not allowed.");
        }
        if (regexs.size() == 0) {
            throw new IllegalArgumentException(String.format("At least one cluster name pattern is required, [%s].", clusterName));
        }
        return regexs.stream().map(Pattern::compile).collect(Collectors.toSet());
    }

    @Override
    public String fromHostNames(String ... hostNames) {
        for (Map.Entry<String, Set<Pattern>> entry : this.clusterNamePatterns.entrySet()) {
            for (Pattern pattern : entry.getValue()) {
                for (String hostname : hostNames) {
                    if (!pattern.matcher(hostname).matches()) continue;
                    return entry.getKey();
                }
            }
        }
        return null;
    }
}

