/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.atlas.AtlasClientV2;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.atlas.reporting.ReportLineageToAtlas;
import org.apache.nifi.atlas.security.AtlasAuthN;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kerberos.KerberosCredentialsService;

public class Kerberos
implements AtlasAuthN {
    private static final String ALLOW_EXPLICIT_KEYTAB = "NIFI_ALLOW_EXPLICIT_KEYTAB";
    private String principal;
    private String keytab;

    @Override
    public Collection<ValidationResult> validate(ValidationContext context) {
        String allowExplicitKeytabVariable;
        String resolvedKeytab;
        String resolvedPrincipal;
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        String explicitPrincipal = context.getProperty(ReportLineageToAtlas.NIFI_KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String explicitKeytab = context.getProperty(ReportLineageToAtlas.NIFI_KERBEROS_KEYTAB).evaluateAttributeExpressions().getValue();
        KerberosCredentialsService credentialsService = (KerberosCredentialsService)context.getProperty(ReportLineageToAtlas.KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        if (credentialsService == null) {
            resolvedPrincipal = explicitPrincipal;
            resolvedKeytab = explicitKeytab;
        } else {
            resolvedPrincipal = credentialsService.getPrincipal();
            resolvedKeytab = credentialsService.getKeytab();
        }
        if (resolvedPrincipal == null || resolvedKeytab == null) {
            problems.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("Both the Principal and the Keytab must be specified when using Kerberos authentication, either via the explicit properties or the Kerberos Credentials Service.").build());
        }
        if (credentialsService != null && (explicitPrincipal != null || explicitKeytab != null)) {
            problems.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("Cannot specify both a Kerberos Credentials Service and a principal/keytab").build());
        }
        if ("false".equalsIgnoreCase(allowExplicitKeytabVariable = System.getenv(ALLOW_EXPLICIT_KEYTAB)) && (explicitPrincipal != null || explicitKeytab != null)) {
            problems.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("The 'NIFI_ALLOW_EXPLICIT_KEYTAB' system environment variable is configured to forbid explicitly configuring principal/keytab in processors. The Kerberos Credentials Service should be used instead of setting the Kerberos Keytab or Kerberos Principal property.").build());
        }
        return problems;
    }

    @Override
    public void populateProperties(Properties properties) {
        properties.put("atlas.authentication.method.kerberos", "true");
    }

    @Override
    public void configure(PropertyContext context) {
        String explicitPrincipal = context.getProperty(ReportLineageToAtlas.NIFI_KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String explicitKeytab = context.getProperty(ReportLineageToAtlas.NIFI_KERBEROS_KEYTAB).evaluateAttributeExpressions().getValue();
        KerberosCredentialsService credentialsService = (KerberosCredentialsService)context.getProperty(ReportLineageToAtlas.KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        if (credentialsService == null) {
            this.principal = explicitPrincipal;
            this.keytab = explicitKeytab;
        } else {
            this.principal = credentialsService.getPrincipal();
            this.keytab = credentialsService.getKeytab();
        }
    }

    @Override
    public AtlasClientV2 createClient(String[] baseUrls) {
        UserGroupInformation ugi;
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)hadoopConf);
        try {
            UserGroupInformation.loginUserFromKeytab((String)this.principal, (String)this.keytab);
            ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to login with Kerberos due to: " + e, e);
        }
        return new AtlasClientV2(ugi, null, baseUrls);
    }
}

